/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.request.ServerReloadRequest;
import com.alibaba.nacos.api.remote.response.ServerReloadResponse;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.core.utils.Loggers;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServerReloaderRequestHandler
extends RequestHandler<ServerReloadRequest, ServerReloadResponse> {
    @Autowired
    private ConnectionManager connectionManager;

    @Override
    public ServerReloadResponse handle(ServerReloadRequest request, RequestMeta meta) throws NacosException {
        ServerReloadResponse response = new ServerReloadResponse();
        Loggers.REMOTE.info("server reload request receive,reload count={},redirectServer={},requestIp={}", new Object[]{request.getReloadCount(), request.getReloadServer(), meta.getClientIp()});
        int reloadCount = request.getReloadCount();
        HashMap<String, String> filter = new HashMap<String, String>(2);
        filter.put("source", "sdk");
        int sdkCount = this.connectionManager.currentClientsCount(filter);
        if (sdkCount <= reloadCount) {
            response.setMessage("ignore");
        } else {
            reloadCount = (int)Math.max((float)reloadCount, (float)sdkCount * 0.9f);
            this.connectionManager.loadCount(reloadCount, request.getReloadServer());
            response.setMessage("ok");
        }
        return response;
    }
}

