/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.storage.kv;

import com.alibaba.nacos.common.utils.ByteUtils;
import com.alibaba.nacos.core.exception.ErrorCode;
import com.alibaba.nacos.core.exception.KvStorageException;
import com.alibaba.nacos.core.storage.kv.KvStorage;
import com.alibaba.nacos.sys.utils.DiskUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FileKvStorage
implements KvStorage {
    private final String baseDir;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    public FileKvStorage(String baseDir) throws IOException {
        this.baseDir = baseDir;
        DiskUtils.forceMkdir((String)baseDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(byte[] key) throws KvStorageException {
        this.readLock.lock();
        try {
            String fileName = new String(key);
            File file = Paths.get(this.baseDir, fileName).toFile();
            if (file.exists()) {
                byte[] byArray = DiskUtils.readFileBytes((File)file);
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<byte[], byte[]> batchGet(List<byte[]> keys) throws KvStorageException {
        this.readLock.lock();
        try {
            HashMap<byte[], byte[]> result = new HashMap<byte[], byte[]>(keys.size());
            for (byte[] key : keys) {
                byte[] val = this.get(key);
                if (val == null) continue;
                result.put(key, val);
            }
            HashMap<byte[], byte[]> hashMap = result;
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(byte[] key, byte[] value) throws KvStorageException {
        this.readLock.lock();
        try {
            String fileName = new String(key);
            File file = Paths.get(this.baseDir, fileName).toFile();
            try {
                DiskUtils.touch((File)file);
                DiskUtils.writeFile((File)file, (byte[])value, (boolean)false);
            }
            catch (IOException e) {
                throw new KvStorageException(ErrorCode.KVStorageWriteError, (Throwable)e);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchPut(List<byte[]> keys, List<byte[]> values) throws KvStorageException {
        this.readLock.lock();
        try {
            if (keys.size() != values.size()) {
                throw new KvStorageException(ErrorCode.KVStorageBatchWriteError, "key's size must be equal to value's size");
            }
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                this.put(keys.get(i), values.get(i));
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void delete(byte[] key) throws KvStorageException {
        this.readLock.lock();
        try {
            String fileName = new String(key);
            DiskUtils.deleteFile((String)this.baseDir, (String)fileName);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchDelete(List<byte[]> keys) throws KvStorageException {
        this.readLock.lock();
        try {
            for (byte[] key : keys) {
                this.delete(key);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void doSnapshot(String backupPath) throws KvStorageException {
        this.writeLock.lock();
        try {
            File srcDir = Paths.get(this.baseDir, new String[0]).toFile();
            File descDir = Paths.get(backupPath, new String[0]).toFile();
            DiskUtils.copyDirectory((File)srcDir, (File)descDir);
        }
        catch (IOException e) {
            throw new KvStorageException(ErrorCode.IOCopyDirError, (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void snapshotLoad(String path) throws KvStorageException {
        this.writeLock.lock();
        try {
            File srcDir = Paths.get(path, new String[0]).toFile();
            if (srcDir.exists()) {
                DiskUtils.deleteDirThenMkdir((String)this.baseDir);
                File descDir = Paths.get(this.baseDir, new String[0]).toFile();
                DiskUtils.copyDirectory((File)srcDir, (File)descDir);
            }
        }
        catch (IOException e) {
            throw new KvStorageException(ErrorCode.IOCopyDirError, (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public List<byte[]> allKeys() throws KvStorageException {
        LinkedList<byte[]> result = new LinkedList<byte[]>();
        File[] files = new File(this.baseDir).listFiles();
        if (null != files) {
            for (File each : files) {
                if (!each.isFile()) continue;
                result.add(ByteUtils.toBytes((String)each.getName()));
            }
        }
        return result;
    }

    @Override
    public void shutdown() {
    }
}

