/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.utils;

import com.alibaba.nacos.common.utils.NumberUtils;

public class RemoteUtils {
    public static final float LOADER_FACTOR = 0.1f;
    private static final int REMOTE_EXECUTOR_TIMES_OF_PROCESSORS = 16;
    private static final int REMOTE_EXECUTOR_QUEUE_SIZE = 16384;

    public static int getRemoteExecutorTimesOfProcessors() {
        String timesString = System.getProperty("remote.executor.times.of.processors");
        if (NumberUtils.isDigits((String)timesString)) {
            int times = Integer.parseInt(timesString);
            return times > 0 ? times : 16;
        }
        return 16;
    }

    public static int getRemoteExecutorQueueSize() {
        String queueSizeString = System.getProperty("remote.executor.queue.size");
        if (NumberUtils.isDigits((String)queueSizeString)) {
            int size = Integer.parseInt(queueSizeString);
            return size > 0 ? size : 16384;
        }
        return 16384;
    }
}

