/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.common;

import com.alibaba.nacos.istio.common.NacosServiceInfoResourceWatcher;
import com.alibaba.nacos.istio.common.ResourceSnapshot;
import com.alibaba.nacos.istio.misc.IstioConfig;
import com.alibaba.nacos.istio.model.IstioService;
import com.alibaba.nacos.istio.util.IstioExecutor;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NacosResourceManager {
    private ResourceSnapshot resourceSnapshot = new ResourceSnapshot();
    @Autowired
    NacosServiceInfoResourceWatcher serviceInfoResourceWatcher;
    @Autowired
    private IstioConfig istioConfig;

    public void start() {
        IstioExecutor.registerNacosResourceWatcher(this.serviceInfoResourceWatcher, (long)this.istioConfig.getMcpPushInterval() * 2L, this.istioConfig.getMcpPushInterval());
    }

    public Map<String, IstioService> services() {
        return this.serviceInfoResourceWatcher.snapshot();
    }

    public IstioConfig getIstioConfig() {
        return this.istioConfig;
    }

    public synchronized ResourceSnapshot getResourceSnapshot() {
        return this.resourceSnapshot;
    }

    public synchronized void setResourceSnapshot(ResourceSnapshot resourceSnapshot) {
        this.resourceSnapshot = resourceSnapshot;
    }

    public void initResourceSnapshot() {
        ResourceSnapshot resourceSnapshot = this.getResourceSnapshot();
        resourceSnapshot.initResourceSnapshot(this);
    }

    public ResourceSnapshot createResourceSnapshot() {
        ResourceSnapshot resourceSnapshot = new ResourceSnapshot();
        resourceSnapshot.initResourceSnapshot(this);
        this.setResourceSnapshot(resourceSnapshot);
        return resourceSnapshot;
    }
}

