/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.util;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.istio.model.IstioService;
import com.alibaba.nacos.istio.model.ServiceEntryWrapper;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.google.protobuf.Timestamp;
import istio.mcp.v1alpha1.MetadataOuterClass;
import istio.networking.v1alpha3.GatewayOuterClass;
import istio.networking.v1alpha3.ServiceEntryOuterClass;
import istio.networking.v1alpha3.WorkloadEntryOuterClass;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class IstioCrdUtil {
    public static final String VALID_DEFAULT_GROUP_NAME = "DEFAULT-GROUP";
    private static final String ISTIO_HOSTNAME = "istio.hostname";
    public static final String VALID_LABEL_KEY_FORMAT = "^([a-zA-Z0-9](?:[-a-zA-Z0-9]*[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[-a-zA-Z0-9]*[a-zA-Z0-9])?)*/)?((?:[A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9])$";
    public static final String VALID_LABEL_VALUE_FORMAT = "^((?:[A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9])?$";

    public static String buildServiceNameForServiceEntry(Service service) {
        String group = !"DEFAULT_GROUP".equals(service.getGroup()) ? service.getGroup() : VALID_DEFAULT_GROUP_NAME;
        return service.getName() + "." + group + "." + service.getNamespace();
    }

    public static ServiceEntryWrapper buildServiceEntry(String serviceName, String domainSuffix, IstioService istioService) {
        if (istioService.getHosts().isEmpty()) {
            return null;
        }
        ServiceEntryOuterClass.ServiceEntry.Builder serviceEntryBuilder = ServiceEntryOuterClass.ServiceEntry.newBuilder().setResolution(ServiceEntryOuterClass.ServiceEntry.Resolution.STATIC).setLocation(ServiceEntryOuterClass.ServiceEntry.Location.MESH_INTERNAL);
        int port = 0;
        String protocol = "http";
        String hostname = serviceName;
        for (Instance instance : istioService.getHosts()) {
            String metaHostname;
            if (port == 0) {
                port = instance.getPort();
            }
            if (StringUtils.isNotEmpty((String)((String)instance.getMetadata().get("protocol"))) && ((protocol = (String)instance.getMetadata().get("protocol")).equals("triple") || protocol.equals("tri"))) {
                protocol = "grpc";
            }
            if (StringUtils.isNotEmpty((String)(metaHostname = (String)instance.getMetadata().get(ISTIO_HOSTNAME)))) {
                hostname = metaHostname;
            }
            if (!instance.isHealthy() || !instance.isEnabled()) continue;
            HashMap<String, String> metadata = new HashMap<String, String>(8);
            if (StringUtils.isNotEmpty((String)instance.getClusterName())) {
                metadata.put("cluster", instance.getClusterName());
            }
            for (Map.Entry entry : instance.getMetadata().entrySet()) {
                if (!Pattern.matches(VALID_LABEL_KEY_FORMAT, (CharSequence)entry.getKey()) || !Pattern.matches(VALID_LABEL_VALUE_FORMAT, (CharSequence)entry.getValue())) continue;
                metadata.put((String)entry.getKey(), (String)entry.getValue());
            }
            WorkloadEntryOuterClass.WorkloadEntry workloadEntry = WorkloadEntryOuterClass.WorkloadEntry.newBuilder().setAddress(instance.getIp()).setWeight((int)instance.getWeight()).putAllLabels(metadata).putPorts(protocol, instance.getPort()).build();
            serviceEntryBuilder.addEndpoints(workloadEntry);
        }
        serviceEntryBuilder.addHosts(hostname + "." + domainSuffix).addPorts(GatewayOuterClass.Port.newBuilder().setNumber(port).setName(protocol).setProtocol(protocol.toUpperCase()).build());
        ServiceEntryOuterClass.ServiceEntry serviceEntry = serviceEntryBuilder.build();
        Date createTimestamp = istioService.getCreateTimeStamp();
        MetadataOuterClass.Metadata metadata = MetadataOuterClass.Metadata.newBuilder().setName(istioService.getNamespace() + "/" + serviceName).putAnnotations("virtual", "1").putLabels("registryType", "nacos").setCreateTime(Timestamp.newBuilder().setSeconds(createTimestamp.getTime() / 1000L).build()).setVersion(String.valueOf(istioService.getRevision())).build();
        return new ServiceEntryWrapper(metadata, serviceEntry);
    }
}

