/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.ephemeral.distro.component;

import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.distributed.distro.component.DistroCallback;
import com.alibaba.nacos.core.distributed.distro.component.DistroTransportAgent;
import com.alibaba.nacos.core.distributed.distro.entity.DistroData;
import com.alibaba.nacos.core.distributed.distro.entity.DistroKey;
import com.alibaba.nacos.core.distributed.distro.exception.DistroException;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.combined.DistroHttpCombinedKey;
import com.alibaba.nacos.naming.misc.NamingProxy;
import java.util.ArrayList;
import java.util.List;

public class DistroHttpAgent
implements DistroTransportAgent {
    private final ServerMemberManager memberManager;

    public DistroHttpAgent(ServerMemberManager memberManager) {
        this.memberManager = memberManager;
    }

    public boolean supportCallbackTransport() {
        return false;
    }

    public boolean syncData(DistroData data, String targetServer) {
        if (!this.memberManager.hasMember(targetServer)) {
            return true;
        }
        byte[] dataContent = data.getContent();
        return NamingProxy.syncData(dataContent, data.getDistroKey().getTargetServer());
    }

    public void syncData(DistroData data, String targetServer, DistroCallback callback) {
        throw new UnsupportedOperationException("Http distro agent do not support this method");
    }

    public boolean syncVerifyData(DistroData verifyData, String targetServer) {
        if (!this.memberManager.hasMember(targetServer)) {
            return true;
        }
        NamingProxy.syncCheckSums(verifyData.getContent(), targetServer);
        return true;
    }

    public void syncVerifyData(DistroData verifyData, String targetServer, DistroCallback callback) {
        throw new UnsupportedOperationException("Http distro agent do not support this method");
    }

    public DistroData getData(DistroKey key, String targetServer) {
        try {
            List<String> toUpdateKeys = null;
            if (key instanceof DistroHttpCombinedKey) {
                toUpdateKeys = ((DistroHttpCombinedKey)key).getActualResourceTypes();
            } else {
                toUpdateKeys = new ArrayList<String>(1);
                toUpdateKeys.add(key.getResourceKey());
            }
            byte[] queriedData = NamingProxy.getData(toUpdateKeys, key.getTargetServer());
            return new DistroData(key, queriedData);
        }
        catch (Exception e) {
            throw new DistroException(String.format("Get data from %s failed.", key.getTargetServer()), (Throwable)e);
        }
    }

    public DistroData getDatumSnapshot(String targetServer) {
        try {
            byte[] allDatum = NamingProxy.getAllData(targetServer);
            return new DistroData(new DistroKey("snapshot", "com.alibaba.nacos.naming.iplist."), allDatum);
        }
        catch (Exception e) {
            throw new DistroException(String.format("Get snapshot from %s failed.", targetServer), (Throwable)e);
        }
    }
}

