/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute;

import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute.ServiceMetadataUpgradeHelper;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

public class DefaultServiceMetadataUpgradeHelper
implements ServiceMetadataUpgradeHelper {
    @Override
    public Service toV1Service(Service v1, com.alibaba.nacos.naming.core.v2.pojo.Service v2, ServiceMetadata v2meta) {
        if (null == v1) {
            v1 = new Service(v2.getGroupedServiceName());
            v1.setGroupName(v2.getGroup());
            v1.setNamespaceId(v2.getNamespace());
        }
        v1.setSelector(v2meta.getSelector());
        v1.setProtectThreshold(v2meta.getProtectThreshold());
        v1.setMetadata(v2meta.getExtendData());
        for (Map.Entry<String, ClusterMetadata> entry : v2meta.getClusters().entrySet()) {
            if (!v1.getClusterMap().containsKey(entry.getKey())) {
                v1.addCluster(this.toV1Cluster(new Cluster(entry.getKey(), v1), entry.getValue()));
                continue;
            }
            this.toV1Cluster(v1.getClusterMap().get(entry.getKey()), entry.getValue());
        }
        return v1;
    }

    @Override
    public Cluster toV1Cluster(Cluster v1, ClusterMetadata v2meta) {
        v1.setDefCkport(v2meta.getHealthyCheckPort());
        v1.setUseIPPort4Check(v2meta.isUseInstancePortForCheck());
        v1.setHealthChecker(v2meta.getHealthChecker());
        v1.setMetadata(v2meta.getExtendData());
        return v1;
    }

    @Override
    public ServiceMetadata toV2ServiceMetadata(Service service, boolean ephemeral) {
        ServiceMetadata result = new ServiceMetadata();
        result.setEphemeral(ephemeral);
        result.setProtectThreshold(service.getProtectThreshold());
        result.setSelector(service.getSelector());
        result.setExtendData(service.getMetadata());
        for (Map.Entry<String, Cluster> entry : service.getClusterMap().entrySet()) {
            result.getClusters().put(entry.getKey(), this.toV2ClusterMetadata(entry.getValue()));
        }
        return result;
    }

    @Override
    public ClusterMetadata toV2ClusterMetadata(Cluster v1) {
        ClusterMetadata result = new ClusterMetadata();
        result.setHealthyCheckPort(v1.getDefCkport());
        result.setUseInstancePortForCheck(v1.isUseIPPort4Check());
        result.setExtendData(v1.getMetadata());
        result.setHealthChecker(v1.getHealthChecker());
        result.setHealthyCheckType(v1.getHealthChecker().getType());
        return result;
    }

    @Configuration
    public static class Config {
        @Bean
        @ConditionalOnMissingBean(value={ServiceMetadataUpgradeHelper.class})
        public ServiceMetadataUpgradeHelper defaultServiceMetadataUpgradeHelper() {
            return new DefaultServiceMetadataUpgradeHelper();
        }
    }
}

