/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.web;

import com.alibaba.nacos.api.naming.remote.request.AbstractNamingRequest;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.auth.parser.ResourceParser;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.ReflectUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import javax.servlet.http.HttpServletRequest;

public class NamingResourceParser
implements ResourceParser {
    private static final String AUTH_NAMING_PREFIX = "naming/";

    public String parseName(Object requestObj) {
        AbstractNamingRequest request;
        String namespaceId = null;
        String serviceName = null;
        String groupName = null;
        if (requestObj instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)requestObj;
            namespaceId = NamespaceUtil.processNamespaceParameter((String)req.getParameter("namespaceId"));
            serviceName = req.getParameter("serviceName");
            groupName = req.getParameter("groupName");
        } else if (requestObj instanceof AbstractNamingRequest) {
            request = (AbstractNamingRequest)requestObj;
            namespaceId = request.getNamespace();
            groupName = request.getGroupName();
            serviceName = request.getServiceName();
        } else if (requestObj instanceof Request) {
            request = (Request)requestObj;
            namespaceId = (String)ReflectUtils.getFieldValue((Object)request, (String)"namespace", (Object)"");
            groupName = (String)ReflectUtils.getFieldValue((Object)request, (String)"groupName", (Object)"");
            serviceName = (String)ReflectUtils.getFieldValue((Object)request, (String)"serviceName", (Object)"");
        }
        if (StringUtils.isBlank(groupName)) {
            groupName = NamingUtils.getGroupName(serviceName);
        }
        serviceName = NamingUtils.getServiceName(serviceName);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)namespaceId)) {
            sb.append(namespaceId);
        }
        if (StringUtils.isBlank((CharSequence)groupName)) {
            sb.append(":").append('*');
        } else {
            sb.append(":").append(groupName);
        }
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            sb.append(":").append(AUTH_NAMING_PREFIX).append('*');
        } else {
            sb.append(":").append(AUTH_NAMING_PREFIX).append(serviceName);
        }
        return sb.toString();
    }
}

