/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.sys.env;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.boot.origin.TextResourceOrigin;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class OriginTrackedPropertiesLoader {
    private final Resource resource;

    OriginTrackedPropertiesLoader(Resource resource) {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        this.resource = resource;
    }

    public Map<String, OriginTrackedValue> load() throws IOException {
        return this.load(true);
    }

    public Map<String, OriginTrackedValue> load(boolean expandLists) throws IOException {
        try (CharacterReader reader = new CharacterReader(this.resource);){
            LinkedHashMap<String, OriginTrackedValue> result = new LinkedHashMap<String, OriginTrackedValue>();
            StringBuilder buffer = new StringBuilder();
            while (reader.read()) {
                String key = this.loadKey(buffer, reader).trim();
                if (expandLists && key.endsWith("[]")) {
                    key = key.substring(0, key.length() - 2);
                    int index = 0;
                    do {
                        OriginTrackedValue value = this.loadValue(buffer, reader, true);
                        this.put(result, key + "[" + index++ + "]", value);
                        if (reader.isEndOfLine()) continue;
                        reader.read();
                    } while (!reader.isEndOfLine());
                    continue;
                }
                OriginTrackedValue value = this.loadValue(buffer, reader, false);
                this.put(result, key, value);
            }
            LinkedHashMap<String, OriginTrackedValue> linkedHashMap = result;
            return linkedHashMap;
        }
    }

    private void put(Map<String, OriginTrackedValue> result, String key, OriginTrackedValue value) {
        if (!key.isEmpty()) {
            result.put(key, value);
        }
    }

    private String loadKey(StringBuilder buffer, CharacterReader reader) throws IOException {
        buffer.setLength(0);
        boolean previousWhitespace = false;
        while (!reader.isEndOfLine()) {
            if (reader.isPropertyDelimiter()) {
                reader.read();
                return buffer.toString();
            }
            if (!reader.isWhiteSpace() && previousWhitespace) {
                return buffer.toString();
            }
            previousWhitespace = reader.isWhiteSpace();
            buffer.append(reader.getCharacter());
            reader.read();
        }
        return buffer.toString();
    }

    private OriginTrackedValue loadValue(StringBuilder buffer, CharacterReader reader, boolean splitLists) throws IOException {
        buffer.setLength(0);
        while (reader.isWhiteSpace() && !reader.isEndOfLine()) {
            reader.read();
        }
        TextResourceOrigin.Location location = reader.getLocation();
        while (!(reader.isEndOfLine() || splitLists && reader.isListDelimiter())) {
            buffer.append(reader.getCharacter());
            reader.read();
        }
        TextResourceOrigin origin = new TextResourceOrigin(this.resource, location);
        return OriginTrackedValue.of((Object)buffer.toString(), (Origin)origin);
    }

    private static class CharacterReader
    implements Closeable {
        private final String[] escapes = new String[]{"trnf", "\t\r\n\f"};
        private final LineNumberReader reader;
        private int columnNumber = -1;
        private boolean escaped;
        private int character;

        CharacterReader(Resource resource) throws IOException {
            this.reader = new LineNumberReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.ISO_8859_1));
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        public boolean read() throws IOException {
            return this.read(false);
        }

        public boolean read(boolean wrappedLine) throws IOException {
            this.escaped = false;
            this.character = this.reader.read();
            ++this.columnNumber;
            if (this.columnNumber == 0) {
                this.skipLeadingWhitespace();
                if (!wrappedLine) {
                    this.skipComment();
                }
            }
            if (this.character == 92) {
                this.escaped = true;
                this.readEscaped();
            } else if (this.character == 10) {
                this.columnNumber = -1;
            }
            return !this.isEndOfFile();
        }

        private void skipLeadingWhitespace() throws IOException {
            while (this.isWhiteSpace()) {
                this.character = this.reader.read();
                ++this.columnNumber;
            }
        }

        private void skipComment() throws IOException {
            if (this.character == 35 || this.character == 33) {
                while (this.character != 10 && this.character != -1) {
                    this.character = this.reader.read();
                }
                this.columnNumber = -1;
                this.read();
            }
        }

        private void readEscaped() throws IOException {
            this.character = this.reader.read();
            int escapeIndex = this.escapes[0].indexOf(this.character);
            if (escapeIndex != -1) {
                this.character = this.escapes[1].charAt(escapeIndex);
            } else if (this.character == 10) {
                this.columnNumber = -1;
                this.read(true);
            } else if (this.character == 117) {
                this.readUnicode();
            }
        }

        private void readUnicode() throws IOException {
            this.character = 0;
            for (int i = 0; i < 4; ++i) {
                int digit = this.reader.read();
                if (digit >= 48 && digit <= 57) {
                    this.character = (this.character << 4) + digit - 48;
                    continue;
                }
                if (digit >= 97 && digit <= 102) {
                    this.character = (this.character << 4) + digit - 97 + 10;
                    continue;
                }
                if (digit >= 65 && digit <= 70) {
                    this.character = (this.character << 4) + digit - 65 + 10;
                    continue;
                }
                throw new IllegalStateException("Malformed \\uxxxx encoding.");
            }
        }

        public boolean isWhiteSpace() {
            return !this.escaped && (this.character == 32 || this.character == 9 || this.character == 12);
        }

        public boolean isEndOfFile() {
            return this.character == -1;
        }

        public boolean isEndOfLine() {
            return this.character == -1 || !this.escaped && this.character == 10;
        }

        public boolean isListDelimiter() {
            return !this.escaped && this.character == 44;
        }

        public boolean isPropertyDelimiter() {
            return !this.escaped && (this.character == 61 || this.character == 58);
        }

        public char getCharacter() {
            return (char)this.character;
        }

        public TextResourceOrigin.Location getLocation() {
            return new TextResourceOrigin.Location(this.reader.getLineNumber(), this.columnNumber);
        }
    }
}

