/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.oss.http;

import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.pig4cloud.plugin.oss.service.OssTemplate;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Validated
@RestController
@RequestMapping(value={"${oss.http.prefix:}/oss"})
@Api(tags={"oss:http\u63a5\u53e3"})
@Tag(name="OssEndpoint", description="oss:http\u63a5\u53e3")
public class OssEndpoint {
    private final OssTemplate ossTemplate;

    @PostMapping(value={"/bucket/{bucketName}"})
    public Bucket createBucket(@PathVariable @NotBlank String bucketName) {
        this.ossTemplate.createBucket(bucketName);
        return this.ossTemplate.getBucket(bucketName).get();
    }

    @GetMapping(value={"/bucket"})
    public List<Bucket> getBuckets() {
        return this.ossTemplate.getAllBuckets();
    }

    @GetMapping(value={"/bucket/{bucketName}"})
    public Bucket getBucket(@PathVariable @NotBlank String bucketName) {
        return this.ossTemplate.getBucket(bucketName).orElseThrow(() -> new IllegalArgumentException("Bucket Name not found!"));
    }

    @DeleteMapping(value={"/bucket/{bucketName}"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteBucket(@PathVariable @NotBlank String bucketName) {
        this.ossTemplate.removeBucket(bucketName);
    }

    @PostMapping(value={"/object/{bucketName}"})
    public S3ObjectSummary createObject(@RequestBody @NotNull MultipartFile object, @PathVariable @NotBlank String bucketName) {
        String name = object.getOriginalFilename();
        this.ossTemplate.putObject(bucketName, name, object.getInputStream(), object.getSize(), object.getContentType());
        S3Object objectInfo = this.ossTemplate.getObjectInfo(bucketName, name);
        ObjectMetadata objectMetadata = objectInfo.getObjectMetadata();
        S3ObjectSummary objectSummary = new S3ObjectSummary();
        objectSummary.setKey(objectInfo.getKey());
        objectSummary.setBucketName(bucketName);
        objectSummary.setETag(objectMetadata.getETag());
        objectSummary.setLastModified(objectMetadata.getLastModified());
        objectSummary.setSize(objectMetadata.getContentLength());
        return objectSummary;
    }

    @PostMapping(value={"/object/{bucketName}/{objectName}"})
    public S3ObjectSummary createObject(@RequestBody @NotNull MultipartFile object, @PathVariable @NotBlank String bucketName, @PathVariable @NotBlank String objectName) {
        this.ossTemplate.putObject(bucketName, objectName, object.getInputStream(), object.getSize(), object.getContentType());
        S3Object objectInfo = this.ossTemplate.getObjectInfo(bucketName, objectName);
        ObjectMetadata objectMetadata = objectInfo.getObjectMetadata();
        S3ObjectSummary objectSummary = new S3ObjectSummary();
        objectSummary.setKey(objectInfo.getKey());
        objectSummary.setBucketName(bucketName);
        objectSummary.setETag(objectMetadata.getETag());
        objectSummary.setLastModified(objectMetadata.getLastModified());
        objectSummary.setSize(objectMetadata.getContentLength());
        return objectSummary;
    }

    @GetMapping(value={"/object/{bucketName}/{objectName}"})
    public List<S3ObjectSummary> filterObject(@PathVariable @NotBlank String bucketName, @PathVariable @NotBlank String objectName) {
        return this.ossTemplate.getAllObjectsByPrefix(bucketName, objectName);
    }

    @GetMapping(value={"/object/{bucketName}/{objectName}/{expires}"})
    public Map<String, Object> getObjectUrl(@PathVariable @NotBlank String bucketName, @PathVariable @NotBlank String objectName, @PathVariable @NotNull Integer expires) {
        HashMap<String, Object> responseBody = new HashMap<String, Object>(8);
        responseBody.put("bucket", bucketName);
        responseBody.put("object", objectName);
        responseBody.put("url", this.ossTemplate.getObjectURL(bucketName, objectName, expires));
        responseBody.put("expires", expires);
        return responseBody;
    }

    @GetMapping(value={"/object/put/{bucketName}/{objectName}/{expires}"})
    public Map<String, Object> getPutObjectUrl(@PathVariable @NotBlank String bucketName, @PathVariable @NotBlank String objectName, @PathVariable @NotNull Integer expires) {
        HashMap<String, Object> responseBody = new HashMap<String, Object>(8);
        responseBody.put("bucket", bucketName);
        responseBody.put("object", objectName);
        responseBody.put("url", this.ossTemplate.getPutObjectURL(bucketName, objectName, expires));
        responseBody.put("expires", expires);
        return responseBody;
    }

    @ResponseStatus(value=HttpStatus.ACCEPTED)
    @DeleteMapping(value={"/object/{bucketName}/{objectName}/"})
    public void deleteObject(@PathVariable @NotBlank String bucketName, @PathVariable @NotBlank String objectName) {
        this.ossTemplate.removeObject(bucketName, objectName);
    }

    public OssEndpoint(OssTemplate ossTemplate) {
        this.ossTemplate = ossTemplate;
    }
}

