/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AuditEventDefaultFormatter;
import com.puppycrawl.tools.checkstyle.AuditEventFormatter;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

public class DefaultLogger
extends AutomaticBean
implements AuditListener {
    private final PrintWriter infoWriter;
    private final boolean closeInfo;
    private final PrintWriter errorWriter;
    private final boolean closeError;
    private final AuditEventFormatter formatter;

    public DefaultLogger(OutputStream outputStream, boolean closeStreamsAfterUse) {
        this(outputStream, closeStreamsAfterUse, outputStream, false);
    }

    public DefaultLogger(OutputStream infoStream, boolean closeInfoAfterUse, OutputStream errorStream, boolean closeErrorAfterUse) {
        this(infoStream, closeInfoAfterUse, errorStream, closeErrorAfterUse, new AuditEventDefaultFormatter());
    }

    public DefaultLogger(OutputStream infoStream, boolean closeInfoAfterUse, OutputStream errorStream, boolean closeErrorAfterUse, AuditEventFormatter messageFormatter) {
        this.closeInfo = closeInfoAfterUse;
        this.closeError = closeErrorAfterUse;
        OutputStreamWriter infoStreamWriter = new OutputStreamWriter(infoStream, StandardCharsets.UTF_8);
        OutputStreamWriter errorStreamWriter = new OutputStreamWriter(errorStream, StandardCharsets.UTF_8);
        this.infoWriter = new PrintWriter(infoStreamWriter);
        this.errorWriter = infoStream == errorStream ? this.infoWriter : new PrintWriter(errorStreamWriter);
        this.formatter = messageFormatter;
    }

    @Override
    public void addError(AuditEvent event) {
        SeverityLevel severityLevel = event.getSeverityLevel();
        if (severityLevel != SeverityLevel.IGNORE) {
            String errorMessage = this.formatter.format(event);
            this.errorWriter.println(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addException(AuditEvent event, Throwable throwable) {
        PrintWriter printWriter = this.errorWriter;
        synchronized (printWriter) {
            this.errorWriter.println("Error auditing " + event.getFileName());
            throwable.printStackTrace(this.errorWriter);
        }
    }

    @Override
    public void auditStarted(AuditEvent event) {
        this.infoWriter.println("Starting audit...");
        this.infoWriter.flush();
    }

    @Override
    public void auditFinished(AuditEvent event) {
        this.infoWriter.println("Audit done.");
        this.closeStreams();
    }

    @Override
    public void fileStarted(AuditEvent event) {
    }

    @Override
    public void fileFinished(AuditEvent event) {
        this.infoWriter.flush();
    }

    private void closeStreams() {
        this.infoWriter.flush();
        if (this.closeInfo) {
            this.infoWriter.close();
        }
        this.errorWriter.flush();
        if (this.closeError) {
            this.errorWriter.close();
        }
    }
}

