/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

@FileStatefulCheck
public class MultipleStringLiteralsCheck
extends AbstractCheck {
    public static final String MSG_KEY = "multiple.string.literal";
    private final Map<String, List<StringInfo>> stringMap = new HashMap<String, List<StringInfo>>();
    private final BitSet ignoreOccurrenceContext = new BitSet();
    private int allowedDuplicates = 1;
    private Pattern ignoreStringsRegexp;

    public MultipleStringLiteralsCheck() {
        this.setIgnoreStringsRegexp(Pattern.compile("^\"\"$"));
        this.ignoreOccurrenceContext.set(159);
    }

    public void setAllowedDuplicates(int allowedDuplicates) {
        this.allowedDuplicates = allowedDuplicates;
    }

    public final void setIgnoreStringsRegexp(Pattern ignoreStringsRegexp) {
        this.ignoreStringsRegexp = ignoreStringsRegexp == null || ignoreStringsRegexp.pattern().isEmpty() ? null : ignoreStringsRegexp;
    }

    public final void setIgnoreOccurrenceContext(String ... strRep) {
        this.ignoreOccurrenceContext.clear();
        for (String s : strRep) {
            int type = TokenUtil.getTokenId(s);
            this.ignoreOccurrenceContext.set(type);
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{139};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (!this.isInIgnoreOccurrenceContext(ast)) {
            String currentString = ast.getText();
            if (this.ignoreStringsRegexp == null || !this.ignoreStringsRegexp.matcher(currentString).find()) {
                List<StringInfo> hitList = this.stringMap.get(currentString);
                if (hitList == null) {
                    hitList = new ArrayList<StringInfo>();
                    this.stringMap.put(currentString, hitList);
                }
                int line = ast.getLineNo();
                int col = ast.getColumnNo();
                hitList.add(new StringInfo(line, col));
            }
        }
    }

    private boolean isInIgnoreOccurrenceContext(DetailAST ast) {
        boolean isInIgnoreOccurrenceContext = false;
        DetailAST token = ast;
        while (token.getParent() != null) {
            int type = token.getType();
            if (this.ignoreOccurrenceContext.get(type)) {
                isInIgnoreOccurrenceContext = true;
                break;
            }
            token = token.getParent();
        }
        return isInIgnoreOccurrenceContext;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.stringMap.clear();
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        for (Map.Entry<String, List<StringInfo>> stringListEntry : this.stringMap.entrySet()) {
            List<StringInfo> hits = stringListEntry.getValue();
            if (hits.size() <= this.allowedDuplicates) continue;
            StringInfo firstFinding = hits.get(0);
            int line = firstFinding.getLine();
            int col = firstFinding.getCol();
            this.log(line, col, MSG_KEY, stringListEntry.getKey(), hits.size());
        }
    }

    private static final class StringInfo {
        private final int line;
        private final int col;

        StringInfo(int line, int col) {
            this.line = line;
            this.col = col;
        }

        private int getLine() {
            return this.line;
        }

        private int getCol() {
            return this.col;
        }
    }
}

