/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@StatelessCheck
public class WriteTagCheck
extends AbstractCheck {
    public static final String MSG_MISSING_TAG = "type.missingTag";
    public static final String MSG_WRITE_TAG = "javadoc.writeTag";
    public static final String MSG_TAG_FORMAT = "type.tagFormat";
    private Pattern tagRegExp;
    private Pattern tagFormat;
    private String tag;
    private SeverityLevel tagSeverity = SeverityLevel.INFO;

    public void setTag(String tag) {
        this.tag = tag;
        this.tagRegExp = CommonUtil.createPattern(tag + "\\s*(.*$)");
    }

    public void setTagFormat(Pattern pattern) {
        this.tagFormat = pattern;
    }

    public final void setTagSeverity(SeverityLevel severity) {
        this.tagSeverity = severity;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{15, 14, 154, 157};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 154, 157, 9, 8, 155, 161};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        int lineNo;
        FileContents contents = this.getFileContents();
        TextBlock cmt = contents.getJavadocBefore(lineNo = ast.getLineNo());
        if (cmt == null) {
            this.log(lineNo, MSG_MISSING_TAG, this.tag);
        } else {
            this.checkTag(lineNo, cmt.getText());
        }
    }

    private void checkTag(int lineNo, String ... comment) {
        if (this.tagRegExp != null) {
            int tagCount = 0;
            for (int i = 0; i < comment.length; ++i) {
                String commentValue = comment[i];
                Matcher matcher = this.tagRegExp.matcher(commentValue);
                if (!matcher.find()) continue;
                ++tagCount;
                int contentStart = matcher.start(1);
                String content = commentValue.substring(contentStart);
                if (this.tagFormat == null || this.tagFormat.matcher(content).find()) {
                    this.logTag(lineNo + i - comment.length, this.tag, content);
                    continue;
                }
                this.log(lineNo + i - comment.length, MSG_TAG_FORMAT, this.tag, this.tagFormat.pattern());
            }
            if (tagCount == 0) {
                this.log(lineNo, MSG_MISSING_TAG, this.tag);
            }
        }
    }

    private void logTag(int line, String tagName, String tagValue) {
        String originalSeverity = this.getSeverity();
        this.setSeverity(this.tagSeverity.getName());
        this.log(line, MSG_WRITE_TAG, tagName, tagValue);
        this.setSeverity(originalSeverity);
    }
}

