/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileSetCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.File;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class AbstractFileSetCheck
extends AbstractViolationReporter
implements FileSetCheck {
    private final ThreadLocal<FileContext> context = ThreadLocal.withInitial(() -> new FileContext());
    private MessageDispatcher messageDispatcher;
    private String[] fileExtensions = CommonUtil.EMPTY_STRING_ARRAY;
    private int tabWidth = 8;

    protected abstract void processFiltered(File var1, FileText var2) throws CheckstyleException;

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void beginProcessing(String charset) {
    }

    @Override
    public final SortedSet<LocalizedMessage> process(File file, FileText fileText) throws CheckstyleException {
        SortedSet messages = this.context.get().messages;
        this.context.get().fileContents = new FileContents(fileText);
        messages.clear();
        if (CommonUtil.matchesFileExtension(file, this.fileExtensions)) {
            this.processFiltered(file, fileText);
        }
        TreeSet<LocalizedMessage> result = new TreeSet<LocalizedMessage>(messages);
        messages.clear();
        return result;
    }

    @Override
    public void finishProcessing() {
    }

    @Override
    public final void setMessageDispatcher(MessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
    }

    protected final MessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    public SortedSet<LocalizedMessage> getMessages() {
        return new TreeSet<LocalizedMessage>(this.context.get().messages);
    }

    public final void setFileContents(FileContents contents) {
        this.context.get().fileContents = contents;
    }

    protected final FileContents getFileContents() {
        return this.context.get().fileContents;
    }

    public String[] getFileExtensions() {
        return Arrays.copyOf(this.fileExtensions, this.fileExtensions.length);
    }

    public final void setFileExtensions(String ... extensions) {
        if (extensions == null) {
            throw new IllegalArgumentException("Extensions array can not be null");
        }
        this.fileExtensions = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            String extension = extensions[i];
            this.fileExtensions[i] = CommonUtil.startsWithChar(extension, '.') ? extension : "." + extension;
        }
    }

    protected final int getTabWidth() {
        return this.tabWidth;
    }

    public final void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    protected void addMessages(SortedSet<LocalizedMessage> messages) {
        this.context.get().messages.addAll(messages);
    }

    @Override
    public final void log(int line, String key, Object ... args) {
        this.context.get().messages.add(new LocalizedMessage(line, this.getMessageBundle(), key, args, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(key)));
    }

    @Override
    public final void log(int lineNo, int colNo, String key, Object ... args) {
        int col = 1 + CommonUtil.lengthExpandedTabs(this.context.get().fileContents.getLine(lineNo - 1), colNo, this.tabWidth);
        this.context.get().messages.add(new LocalizedMessage(lineNo, col, this.getMessageBundle(), key, args, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(key)));
    }

    protected final void fireErrors(String fileName) {
        TreeSet<LocalizedMessage> errors = new TreeSet<LocalizedMessage>(this.context.get().messages);
        this.context.get().messages.clear();
        this.messageDispatcher.fireErrors(fileName, errors);
    }

    private static class FileContext {
        private final SortedSet<LocalizedMessage> messages = new TreeSet<LocalizedMessage>();
        private FileContents fileContents;

        private FileContext() {
        }
    }
}

