/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;

public class FinalClassCheck
extends AbstractCheck {
    public static final String MSG_KEY = "final.class";
    private static final String PACKAGE_SEPARATOR = ".";
    private Deque<ClassDesc> classes;
    private String packageName;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 8, 16};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.classes = new ArrayDeque<ClassDesc>();
        this.packageName = "";
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        switch (ast.getType()) {
            case 16: {
                this.packageName = FinalClassCheck.extractQualifiedName(ast);
                break;
            }
            case 14: {
                this.registerNestedSubclassToOuterSuperClasses(ast);
                boolean isFinal = modifiers.branchContains(39);
                boolean isAbstract = modifiers.branchContains(40);
                String qualifiedClassName = this.getQualifiedClassName(ast);
                this.classes.push(new ClassDesc(qualifiedClassName, isFinal, isAbstract));
                break;
            }
            case 8: {
                if (ScopeUtils.isInEnumBlock(ast)) break;
                ClassDesc desc = this.classes.peek();
                if (modifiers.branchContains(61)) {
                    desc.registerPrivateCtor();
                    break;
                }
                desc.registerNonPrivateCtor();
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        ClassDesc desc;
        if (!(ast.getType() != 14 || !(desc = this.classes.pop()).isWithPrivateCtor() || desc.isDeclaredAsAbstract() || desc.isDeclaredAsFinal() || desc.isWithNonPrivateCtor() || desc.isWithNestedSubclass() || ScopeUtils.isInInterfaceOrAnnotationBlock(ast))) {
            String qualifiedName = desc.getQualifiedName();
            String className = FinalClassCheck.getClassNameFromQualifiedName(qualifiedName);
            this.log(ast.getLineNo(), MSG_KEY, className);
        }
    }

    private static String extractQualifiedName(DetailAST classExtend) {
        String className;
        if (classExtend.findFirstToken(58) == null) {
            DetailAST firstChild = classExtend.findFirstToken(59);
            LinkedList<String> qualifiedNameParts = new LinkedList<String>();
            qualifiedNameParts.add(0, firstChild.findFirstToken(58).getText());
            for (DetailAST traverse = firstChild.findFirstToken(59); traverse != null; traverse = traverse.findFirstToken(59)) {
                qualifiedNameParts.add(0, traverse.findFirstToken(58).getText());
            }
            className = String.join((CharSequence)PACKAGE_SEPARATOR, qualifiedNameParts);
        } else {
            className = classExtend.findFirstToken(58).getText();
        }
        return className;
    }

    private void registerNestedSubclassToOuterSuperClasses(DetailAST classAst) {
        String currentAstSuperClassName = FinalClassCheck.getSuperClassName(classAst);
        if (currentAstSuperClassName != null) {
            for (ClassDesc classDesc : this.classes) {
                String classDescQualifiedName = classDesc.getQualifiedName();
                if (!FinalClassCheck.doesNameInExtendMatchSuperClassName(classDescQualifiedName, currentAstSuperClassName)) continue;
                classDesc.registerNestedSubclass();
            }
        }
    }

    private String getQualifiedClassName(DetailAST classAst) {
        String className = classAst.findFirstToken(58).getText();
        String outerClassQualifiedName = null;
        if (!this.classes.isEmpty()) {
            outerClassQualifiedName = this.classes.peek().getQualifiedName();
        }
        return FinalClassCheck.getQualifiedClassName(this.packageName, outerClassQualifiedName, className);
    }

    private static String getQualifiedClassName(String packageName, String outerClassQualifiedName, String className) {
        String qualifiedClassName = outerClassQualifiedName == null ? (packageName.isEmpty() ? className : packageName + PACKAGE_SEPARATOR + className) : outerClassQualifiedName + PACKAGE_SEPARATOR + className;
        return qualifiedClassName;
    }

    private static String getSuperClassName(DetailAST classAst) {
        String superClassName = null;
        DetailAST classExtend = classAst.findFirstToken(18);
        if (classExtend != null) {
            superClassName = FinalClassCheck.extractQualifiedName(classExtend);
        }
        return superClassName;
    }

    private static boolean doesNameInExtendMatchSuperClassName(String superClassQualifiedName, String superClassInExtendClause) {
        String superClassNormalizedName = superClassQualifiedName;
        if (!superClassInExtendClause.contains(PACKAGE_SEPARATOR)) {
            superClassNormalizedName = FinalClassCheck.getClassNameFromQualifiedName(superClassQualifiedName);
        }
        return superClassNormalizedName.equals(superClassInExtendClause);
    }

    private static String getClassNameFromQualifiedName(String qualifiedName) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(PACKAGE_SEPARATOR) + 1);
    }

    private static final class ClassDesc {
        private final String qualifiedName;
        private final boolean declaredAsFinal;
        private final boolean declaredAsAbstract;
        private boolean withNonPrivateCtor;
        private boolean withPrivateCtor;
        private boolean withNestedSubclass;

        ClassDesc(String qualifiedName, boolean declaredAsFinal, boolean declaredAsAbstract) {
            this.qualifiedName = qualifiedName;
            this.declaredAsFinal = declaredAsFinal;
            this.declaredAsAbstract = declaredAsAbstract;
        }

        private String getQualifiedName() {
            return this.qualifiedName;
        }

        private void registerPrivateCtor() {
            this.withPrivateCtor = true;
        }

        private void registerNonPrivateCtor() {
            this.withNonPrivateCtor = true;
        }

        private void registerNestedSubclass() {
            this.withNestedSubclass = true;
        }

        private boolean isWithPrivateCtor() {
            return this.withPrivateCtor;
        }

        private boolean isWithNonPrivateCtor() {
            return this.withNonPrivateCtor;
        }

        private boolean isWithNestedSubclass() {
            return this.withNestedSubclass;
        }

        private boolean isDeclaredAsFinal() {
            return this.declaredAsFinal;
        }

        private boolean isDeclaredAsAbstract() {
            return this.declaredAsAbstract;
        }
    }
}

