/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.model.BucketLifecycleConfiguration;
import com.qcloud.cos.model.SetBucketLifecycleConfigurationRequest;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.model.lifecycle.LifecycleFilter;
import com.qcloud.cos.model.lifecycle.LifecyclePrefixPredicate;
import com.qcloud.cos.region.Region;
import java.util.ArrayList;
import java.util.List;

public class BucketLifecycleDemo {
    private String bucketName = "example-12500000000";
    private COSClient cosClient = this.COSBuilder();

    private COSClient COSBuilder() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-shanghai"));
        return new COSClient(cred, clientConfig);
    }

    private void addLifeCycle(String id, String path) {
        ArrayList<BucketLifecycleConfiguration.Rule> rules = new ArrayList<BucketLifecycleConfiguration.Rule>();
        BucketLifecycleConfiguration.Rule deletePrefixRule = new BucketLifecycleConfiguration.Rule();
        deletePrefixRule.setId(id);
        deletePrefixRule.setFilter(new LifecycleFilter(new LifecyclePrefixPredicate(path)));
        deletePrefixRule.setExpirationInDays(7);
        deletePrefixRule.setStatus("Enabled");
        BucketLifecycleConfiguration.Rule standardIaRule = new BucketLifecycleConfiguration.Rule();
        standardIaRule.setId(id + System.currentTimeMillis());
        standardIaRule.setFilter(new LifecycleFilter(new LifecyclePrefixPredicate(path)));
        ArrayList<BucketLifecycleConfiguration.Transition> standardIaTransitions = new ArrayList<BucketLifecycleConfiguration.Transition>();
        BucketLifecycleConfiguration.Transition standardTransition = new BucketLifecycleConfiguration.Transition();
        standardTransition.setDays(20);
        standardTransition.setStorageClass(StorageClass.Standard_IA.toString());
        standardIaTransitions.add(standardTransition);
        standardIaRule.setTransitions(standardIaTransitions);
        standardIaRule.setStatus("Enabled");
        standardIaRule.setExpirationInDays(30);
        rules.add(deletePrefixRule);
        BucketLifecycleConfiguration bucketLifecycleConfiguration = new BucketLifecycleConfiguration();
        bucketLifecycleConfiguration.setRules(rules);
        SetBucketLifecycleConfigurationRequest setBucketLifecycleConfigurationRequest = new SetBucketLifecycleConfigurationRequest(this.bucketName, bucketLifecycleConfiguration);
        this.cosClient.setBucketLifecycleConfiguration(setBucketLifecycleConfigurationRequest);
    }

    private void queryPath() {
        BucketLifecycleConfiguration queryLifeCycleRet = this.cosClient.getBucketLifecycleConfiguration(this.bucketName);
        if (queryLifeCycleRet == null) {
            return;
        }
        List<BucketLifecycleConfiguration.Rule> ruleLists = queryLifeCycleRet.getRules();
        for (BucketLifecycleConfiguration.Rule next : ruleLists) {
            System.out.println("path:" + next.getId());
        }
    }

    private Boolean deletedAllLifeCycle() {
        COSClient cosClient = this.COSBuilder();
        cosClient.deleteBucketLifecycleConfiguration(this.bucketName);
        return true;
    }

    public static void main(String[] args) throws InterruptedException {
        BucketLifecycleDemo manage = new BucketLifecycleDemo();
        manage.deletedAllLifeCycle();
        manage.addLifeCycle("warehouse-ods-apx", "warehouse/ods/apx/");
        manage.addLifeCycle("warehouse-ods-apx2", "warehouse/ods/apx2/");
        manage.queryPath();
    }
}

