/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.auth;

import com.qcloud.cos.auth.AnonymousCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSSessionCredentials;
import com.qcloud.cos.http.CosHttpRequest;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.utils.UrlEncoderUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.HmacUtils;

public class COSSigner {
    private boolean isAnonymous(COSCredentials cred) {
        return cred instanceof AnonymousCOSCredentials;
    }

    public <X extends CosServiceRequest> void sign(CosHttpRequest<X> request, COSCredentials cred, Date expiredTime) {
        if (this.isAnonymous(cred)) {
            return;
        }
        String authoriationStr = this.buildAuthorizationStr(request.getHttpMethod(), request.getResourcePath(), request.getHeaders(), request.getParameters(), cred, expiredTime);
        request.addHeader("Authorization", authoriationStr);
        if (cred instanceof COSSessionCredentials) {
            request.addHeader("x-cos-security-token", ((COSSessionCredentials)cred).getSessionToken());
        }
    }

    public String buildAuthorizationStr(HttpMethodName methodName, String resouce_path, COSCredentials cred, Date expiredTime) {
        return this.buildAuthorizationStr(methodName, resouce_path, new HashMap<String, String>(), new HashMap<String, String>(), cred, expiredTime);
    }

    public String buildAuthorizationStr(HttpMethodName methodName, String resouce_path, Map<String, String> headerMap, Map<String, String> paramMap, COSCredentials cred, Date expiredTime) {
        String qSignTimeStr;
        if (this.isAnonymous(cred)) {
            return null;
        }
        Map<String, String> signHeaders = this.buildSignHeaders(headerMap);
        TreeMap<String, String> sortedSignHeaders = new TreeMap<String, String>();
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        sortedSignHeaders.putAll(signHeaders);
        sortedParams.putAll(paramMap);
        String qHeaderListStr = this.buildSignMemberStr(sortedSignHeaders);
        String qUrlParamListStr = this.buildSignMemberStr(sortedParams);
        String qKeyTimeStr = qSignTimeStr = this.buildTimeStr(expiredTime);
        String signKey = HmacUtils.hmacSha1Hex((String)cred.getCOSSecretKey(), (String)qKeyTimeStr);
        String formatMethod = methodName.toString().toLowerCase();
        String formatUri = resouce_path;
        String formatParameters = this.formatMapToStr(sortedParams);
        String formatHeaders = this.formatMapToStr(sortedSignHeaders);
        String formatStr = formatMethod + "\n" + formatUri + "\n" + formatParameters + "\n" + formatHeaders + "\n";
        String hashFormatStr = DigestUtils.sha1Hex((String)formatStr);
        String stringToSign = "sha1" + "\n" + qSignTimeStr + "\n" + hashFormatStr + "\n";
        String signature = HmacUtils.hmacSha1Hex((String)signKey, (String)stringToSign);
        String authoriationStr = "q-sign-algorithm" + "=" + "sha1" + "&" + "q-ak" + "=" + cred.getCOSAccessKeyId() + "&" + "q-sign-time" + "=" + qSignTimeStr + "&" + "q-key-time" + "=" + qKeyTimeStr + "&" + "q-header-list" + "=" + qHeaderListStr + "&" + "q-url-param-list" + "=" + qUrlParamListStr + "&" + "q-signature" + "=" + signature;
        return authoriationStr;
    }

    private Map<String, String> buildSignHeaders(Map<String, String> originHeaders) {
        HashMap<String, String> signHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> headerEntry : originHeaders.entrySet()) {
            String key = headerEntry.getKey();
            if (!key.equalsIgnoreCase("content-type") && !key.equalsIgnoreCase("content-md5") && !key.startsWith("x") && !key.startsWith("X")) continue;
            String lowerKey = key.toLowerCase();
            String value = headerEntry.getValue();
            signHeaders.put(lowerKey, value);
        }
        return signHeaders;
    }

    private String buildSignMemberStr(Map<String, String> signHeaders) {
        StringBuilder strBuilder = new StringBuilder();
        boolean seenOne = false;
        for (String key : signHeaders.keySet()) {
            if (!seenOne) {
                seenOne = true;
            } else {
                strBuilder.append(";");
            }
            strBuilder.append(key.toLowerCase());
        }
        return strBuilder.toString();
    }

    private String formatMapToStr(Map<String, String> kVMap) {
        StringBuilder strBuilder = new StringBuilder();
        boolean seeOne = false;
        for (Map.Entry<String, String> entry : kVMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String lowerKey = key.toLowerCase();
            String encodeKey = UrlEncoderUtils.encode(lowerKey);
            String encodedValue = "";
            if (value != null) {
                encodedValue = UrlEncoderUtils.encode(value);
            }
            if (!seeOne) {
                seeOne = true;
            } else {
                strBuilder.append("&");
            }
            strBuilder.append(encodeKey).append("=").append(encodedValue);
        }
        return strBuilder.toString();
    }

    private String buildTimeStr(Date expiredTime) {
        StringBuilder strBuilder = new StringBuilder();
        long startTime = System.currentTimeMillis() / 1000L;
        long endTime = expiredTime.getTime() / 1000L;
        strBuilder.append(startTime).append(";").append(endTime);
        return strBuilder.toString();
    }
}

