/*
 * Decompiled with CFR 0.152.
 */
package qiniu.happydns.local;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Random;
import qiniu.happydns.DnsException;
import qiniu.happydns.Domain;
import qiniu.happydns.IResolver;
import qiniu.happydns.Record;
import qiniu.happydns.local.DnsMessage;

public final class Resolver
implements IResolver {
    private static final Random random = new Random();
    final InetAddress address;
    private final int timeout;

    public Resolver(InetAddress address) {
        this(address, 20);
    }

    public Resolver(InetAddress address, int timeout) {
        this.address = address;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Record[] resolve(Domain domain) throws IOException {
        int id;
        Random random = Resolver.random;
        synchronized (random) {
            id = Resolver.random.nextInt() & 0xFF;
        }
        byte[] query = DnsMessage.buildQuery(domain.domain, id);
        byte[] answer = this.udpCommunicate(query);
        if (answer == null) {
            throw new DnsException(domain.domain, "cant get answer");
        }
        return DnsMessage.parseResponse(answer, id, domain.domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] udpCommunicate(byte[] question) throws IOException {
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            DatagramPacket packet = new DatagramPacket(question, question.length, this.address, 53);
            socket.setSoTimeout(this.timeout * 1000);
            socket.send(packet);
            packet = new DatagramPacket(new byte[1500], 1500);
            socket.receive(packet);
            byte[] byArray = packet.getData();
            return byArray;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }
}

