/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.rtc;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.rtc.ServiceCallFunc;
import com.qiniu.rtc.model.AppParam;
import com.qiniu.rtc.model.AppResult;
import com.qiniu.rtc.model.CallbackParam;
import com.qiniu.rtc.model.ForwardParam;
import com.qiniu.rtc.model.ForwardResult;
import com.qiniu.rtc.model.MergeJob;
import com.qiniu.rtc.model.MergeParam;
import com.qiniu.rtc.model.MergeResult;
import com.qiniu.rtc.model.MergeTrackParam;
import com.qiniu.rtc.model.QRTCResult;
import com.qiniu.rtc.model.RoomAccess;
import com.qiniu.rtc.model.RoomParam;
import com.qiniu.rtc.model.RoomResult;
import com.qiniu.rtc.model.UrlParam;
import com.qiniu.rtc.model.WatermarksParam;
import com.qiniu.rtc.service.AppService;
import com.qiniu.rtc.service.CallbackService;
import com.qiniu.rtc.service.ForwardService;
import com.qiniu.rtc.service.MergeService;
import com.qiniu.rtc.service.MergeServiceV4;
import com.qiniu.rtc.service.RoomService;
import com.qiniu.util.Auth;
import com.qiniu.util.Json;
import com.qiniu.util.StringUtils;
import java.util.Map;

public class QRTCClient {
    private final String accessKey;
    private final String secretKey;
    private RoomService roomService;
    private ForwardService forwardService;
    private CallbackService callbackService;
    private MergeService mergeService;
    private MergeServiceV4 mergeServiceV4;
    private AppService appService;
    private final String appId;

    public QRTCClient(String accessKey, String secretKey, String appId) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.appId = appId;
        Auth auth = this.auth();
        this.initService(auth);
    }

    private void initService(Auth auth) {
        this.forwardService = new ForwardService(auth);
        this.roomService = new RoomService(auth);
        this.callbackService = new CallbackService(auth);
        this.mergeService = new MergeService(auth);
        this.appService = new AppService(auth);
        this.mergeServiceV4 = new MergeServiceV4(auth);
    }

    public QRTCResult<AppResult> getApp() throws QiniuException {
        ServiceCallFunc func = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                return QRTCClient.this.appService.getApp(QRTCClient.this.appId);
            }
        };
        return this.buildResult(func, AppResult.class);
    }

    public QRTCResult<AppResult> deleteApp() throws QiniuException {
        ServiceCallFunc func = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                return QRTCClient.this.appService.deleteApp(QRTCClient.this.appId);
            }
        };
        return this.buildResult(func, AppResult.class);
    }

    public QRTCResult<AppResult> updateApp(final AppParam appParam) throws QiniuException {
        ServiceCallFunc func = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                return QRTCClient.this.appService.updateApp(appParam);
            }
        };
        return this.buildResult(func, AppResult.class);
    }

    public QRTCResult<RoomResult> createRoom(final RoomParam roomParam) throws QiniuException {
        ServiceCallFunc func = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                return QRTCClient.this.roomService.createRoom(QRTCClient.this.appId, roomParam);
            }
        };
        return this.buildResult(func, RoomResult.class);
    }

    public QRTCResult<RoomResult> deleteRoom(final String roomName) throws QiniuException {
        ServiceCallFunc func = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                return QRTCClient.this.roomService.deleteRoom(QRTCClient.this.appId, roomName);
            }
        };
        return this.buildResult(func, RoomResult.class);
    }

    public QRTCResult<RoomResult> listUser(final String roomName) throws QiniuException {
        ServiceCallFunc func = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                return QRTCClient.this.roomService.listUser(QRTCClient.this.appId, roomName);
            }
        };
        return this.buildResult(func, RoomResult.class);
    }

    public QRTCResult<RoomResult> kickUser(final String roomName, final String userId) throws QiniuException {
        ServiceCallFunc func = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                return QRTCClient.this.roomService.kickUser(QRTCClient.this.appId, roomName, userId);
            }
        };
        return this.buildResult(func, RoomResult.class);
    }

    public QRTCResult<RoomResult> listActiveRoom(final String roomNamePrefix, final int offset, final int limit) throws QiniuException {
        ServiceCallFunc func = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                UrlParam pageParam = UrlParam.builder().offset(offset).limit(limit).build();
                return QRTCClient.this.roomService.listActiveRoom(QRTCClient.this.appId, roomNamePrefix, pageParam);
            }
        };
        return this.buildResult(func, RoomResult.class);
    }

    public String getRoomToken(String roomName, String userId, long expireAt, String permission) throws Exception {
        RoomAccess access = new RoomAccess(this.appId, roomName, userId, expireAt, permission);
        return this.roomService.getRoomToken(access);
    }

    public QRTCResult<ForwardResult> createForwardJob(final String roomId, final ForwardParam param) throws QiniuException {
        ServiceCallFunc createForwardJobFunc = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                return QRTCClient.this.forwardService.createForwardJob(QRTCClient.this.appId, roomId, param);
            }
        };
        return this.buildResult(createForwardJobFunc, ForwardResult.class);
    }

    public QRTCResult<ForwardResult> stopForwardJob(final String roomId, final ForwardParam param) throws QiniuException {
        ServiceCallFunc stopForwardJobFunc = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                return QRTCClient.this.forwardService.stopForwardJob(QRTCClient.this.appId, roomId, param);
            }
        };
        return this.buildResult(stopForwardJobFunc, ForwardResult.class);
    }

    public QRTCResult<Map> setHttpCallback(final CallbackParam param) throws QiniuException {
        ServiceCallFunc func = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                return QRTCClient.this.callbackService.setHttpCallback(QRTCClient.this.appId, param);
            }
        };
        return this.buildResult(func, Map.class);
    }

    @Deprecated
    public QRTCResult<MergeResult> createMergeJob(final String roomName, final MergeParam mergeParam) throws QiniuException {
        ServiceCallFunc func = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                return QRTCClient.this.mergeService.createMergeJob(mergeParam, QRTCClient.this.appId, roomName);
            }
        };
        return this.buildResult(func, MergeResult.class);
    }

    @Deprecated
    public QRTCResult<MergeResult> updateMergeTrack(final MergeTrackParam mergeTrackParam, final String roomName, final String jobId) throws QiniuException {
        ServiceCallFunc updateMergeTrackFunc = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                UrlParam mergeTrackUrlParam = UrlParam.builder().appId(QRTCClient.this.appId).roomName(roomName).jobId(jobId).build();
                return QRTCClient.this.mergeService.updateMergeTrack(mergeTrackParam, mergeTrackUrlParam);
            }
        };
        return this.buildResult(updateMergeTrackFunc, MergeResult.class);
    }

    @Deprecated
    public QRTCResult<MergeResult> updateMergeWatermarks(final WatermarksParam watermarksParam, final String roomName, final String jobId) throws QiniuException {
        ServiceCallFunc updateMergeWatermarksFunc = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                UrlParam mergeWatermarksUrlParam = UrlParam.builder().appId(QRTCClient.this.appId).roomName(roomName).jobId(jobId).build();
                return QRTCClient.this.mergeService.updateMergeWatermarks(watermarksParam, mergeWatermarksUrlParam);
            }
        };
        return this.buildResult(updateMergeWatermarksFunc, MergeResult.class);
    }

    @Deprecated
    public QRTCResult<MergeResult> stopMergeJob(final String roomName, final String jobId) throws QiniuException {
        ServiceCallFunc func = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                return QRTCClient.this.mergeService.stopMergeJob(QRTCClient.this.appId, roomName, jobId);
            }
        };
        return this.buildResult(func, MergeResult.class);
    }

    public QRTCResult<MergeResult> createMergeJob(final String roomName, final MergeJob job) throws QiniuException {
        ServiceCallFunc func = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                return QRTCClient.this.mergeServiceV4.createMergeJob(job, QRTCClient.this.appId, roomName);
            }
        };
        return this.buildResult(func, MergeResult.class);
    }

    public QRTCResult<MergeResult> updateMergeJob(final String roomName, final MergeJob job) throws QiniuException {
        ServiceCallFunc func = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                return QRTCClient.this.mergeServiceV4.updateMergeJob(job, QRTCClient.this.appId, roomName);
            }
        };
        return this.buildResult(func, MergeResult.class);
    }

    public QRTCResult<MergeResult> stopMergeJobById(final String roomName, final String jobId) throws QiniuException {
        ServiceCallFunc func = new ServiceCallFunc(){

            @Override
            public Response call() throws QiniuException {
                return QRTCClient.this.mergeServiceV4.stopMergeJob(jobId, QRTCClient.this.appId, roomName);
            }
        };
        return this.buildResult(func, MergeResult.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> QRTCResult<T> buildResult(ServiceCallFunc func, Class<T> tClass) throws QiniuException {
        try (Response response = null;){
            response = func.call();
            QRTCResult<T> qRTCResult = this.fetchResponse(tClass, response);
            return qRTCResult;
        }
    }

    private <T> QRTCResult<T> fetchResponse(Class<T> tClass, Response response) throws QiniuException {
        if (null == response || StringUtils.isNullOrEmpty(response.bodyString())) {
            return QRTCResult.fail(-1, "response is null");
        }
        return this.formatResult(tClass, response);
    }

    private <T> QRTCResult<T> formatResult(Class<T> tClass, Response response) throws QiniuException {
        T t = Json.decode(response.bodyString(), tClass);
        QRTCResult<T> result = QRTCResult.success(response.statusCode, t);
        return result;
    }

    private Auth auth() {
        return Auth.create(this.accessKey, this.secretKey);
    }
}

