/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.storage.AutoRegion;
import com.qiniu.storage.RegionReqInfo;
import java.util.Arrays;
import java.util.List;

public class Region
implements Cloneable {
    private long timestamp = -1L;
    private String region = "z0";
    private List<String> srcUpHosts;
    private List<String> accUpHosts;
    private String iovipHost;
    private String ioSrcHost;
    private String rsHost = "rs.qbox.me";
    private String rsfHost = "rsf.qbox.me";
    private String apiHost = "api.qiniuapi.com";
    private String ucHost = "uc.qbox.me";

    Region() {
    }

    Region(long timestamp, String region, List<String> srcUpHosts, List<String> accUpHosts, String iovipHost, String ioSrcHost, String rsHost, String rsfHost, String apiHost, String ucHost) {
        this.timestamp = timestamp;
        this.region = region;
        this.srcUpHosts = srcUpHosts;
        this.accUpHosts = accUpHosts;
        this.iovipHost = iovipHost;
        this.ioSrcHost = ioSrcHost;
        this.rsHost = rsHost;
        this.rsfHost = rsfHost;
        this.apiHost = apiHost;
        this.ucHost = ucHost;
    }

    public static Region region0() {
        return new Builder().region("z0").srcUpHost("up.qiniup.com").accUpHost("upload.qiniup.com").iovipHost("iovip.qbox.me").rsHost("rs.qbox.me").rsfHost("rsf.qbox.me").apiHost("api.qiniuapi.com").build();
    }

    public static Region huadong() {
        return Region.region0();
    }

    public static Region regionCnEast2() {
        return new Builder().region("cn-east-2").srcUpHost("up-cn-east-2.qiniup.com").accUpHost("upload-cn-east-2.qiniup.com").iovipHost("iovip-cn-east-2.qiniuio.com").rsHost("rs-cn-east-2.qiniuapi.com").rsfHost("rsf-cn-east-2.qiniuapi.com").apiHost("api-cn-east-2.qiniuapi.com").build();
    }

    public static Region huadongZheJiang2() {
        return Region.regionCnEast2();
    }

    public static Region qvmRegion0() {
        return new Builder().region("z0").srcUpHost("free-qvm-z0-xs.qiniup.com").accUpHost("free-qvm-z0-xs.qiniup.com").iovipHost("iovip.qbox.me").rsHost("rs.qbox.me").rsfHost("rsf.qbox.me").apiHost("api.qiniu.com").build();
    }

    public static Region qvmHuadong() {
        return Region.qvmRegion0();
    }

    public static Region region1() {
        return new Builder().region("z1").srcUpHost("up-z1.qiniup.com").accUpHost("upload-z1.qiniup.com").iovipHost("iovip-z1.qbox.me").rsHost("rs-z1.qbox.me").rsfHost("rsf-z1.qbox.me").apiHost("api-z1.qiniuapi.com").build();
    }

    public static Region huabei() {
        return Region.region1();
    }

    public static Region qvmRegion1() {
        return new Builder().region("z1").srcUpHost("free-qvm-z1-zz.qiniup.com").accUpHost("free-qvm-z1-zz.qiniup.com").iovipHost("iovip-z1.qbox.me").rsHost("rs-z1.qbox.me").rsfHost("rsf-z1.qbox.me").apiHost("api-z1.qiniu.com").build();
    }

    public static Region qvmHuabei() {
        return Region.qvmRegion1();
    }

    public static Region region2() {
        return new Builder().region("z2").srcUpHost("up-z2.qiniup.com").accUpHost("upload-z2.qiniup.com").iovipHost("iovip-z2.qbox.me").rsHost("rs-z2.qbox.me").rsfHost("rsf-z2.qbox.me").apiHost("api-z2.qiniuapi.com").build();
    }

    public static Region huanan() {
        return Region.region2();
    }

    public static Region regionApNorthEast1() {
        return new Builder().region("ap-northeast-1").srcUpHost("up-ap-northeast-1.qiniup.com").accUpHost("upload-ap-northeast-1.qiniup.com").iovipHost("iovip-ap-northeast-1.qiniuio.com").rsHost("rs-ap-northeast-1.qiniuapi.com").rsfHost("rsf-ap-northeast-1.qiniuapi.com").apiHost("api-ap-northeast-1.qiniuapi.com").build();
    }

    public static Region regionNa0() {
        return new Builder().region("na0").srcUpHost("up-na0.qiniup.com").accUpHost("upload-na0.qiniup.com").iovipHost("iovip-na0.qbox.me").rsHost("rs-na0.qbox.me").rsfHost("rsf-na0.qbox.me").apiHost("api-na0.qiniuapi.com").build();
    }

    public static Region beimei() {
        return Region.regionNa0();
    }

    public static Region regionAs0() {
        return new Builder().region("na0").srcUpHost("up-as0.qiniup.com").accUpHost("upload-as0.qiniup.com").iovipHost("iovip-as0.qbox.me").rsHost("rs-as0.qbox.me").rsfHost("rsf-as0.qbox.me").apiHost("api-as0.qiniuapi.com").build();
    }

    public static Region xinjiapo() {
        return Region.regionAs0();
    }

    public static Region autoRegion() {
        return Region.autoRegion("https://uc.qbox.me");
    }

    public static Region autoRegion(String ucServer) {
        return new Builder().autoRegion(ucServer);
    }

    boolean switchRegion(RegionReqInfo regionReqInfo) {
        return false;
    }

    String getRegion(RegionReqInfo regionReqInfo) {
        return this.region;
    }

    Region getCurrentRegion(RegionReqInfo regionReqInfo) {
        return this;
    }

    List<String> getSrcUpHost(RegionReqInfo regionReqInfo) throws QiniuException {
        return this.srcUpHosts;
    }

    List<String> getAccUpHost(RegionReqInfo regionReqInfo) throws QiniuException {
        return this.accUpHosts;
    }

    String getIovipHost(RegionReqInfo regionReqInfo) throws QiniuException {
        return this.iovipHost;
    }

    String getIoSrcHost(RegionReqInfo regionReqInfo) throws QiniuException {
        return this.ioSrcHost;
    }

    String getRsHost(RegionReqInfo regionReqInfo) throws QiniuException {
        return this.rsHost;
    }

    String getRsfHost(RegionReqInfo regionReqInfo) throws QiniuException {
        return this.rsfHost;
    }

    String getApiHost(RegionReqInfo regionReqInfo) throws QiniuException {
        return this.apiHost;
    }

    String getUcHost(RegionReqInfo regionReqInfo) throws QiniuException {
        return this.ucHost;
    }

    boolean isValid() {
        if (this.timestamp < 0L) {
            return true;
        }
        return System.currentTimeMillis() < this.timestamp * 1000L;
    }

    public Object clone() {
        Region newRegion = new Region();
        newRegion.timestamp = this.timestamp;
        newRegion.region = this.region;
        newRegion.srcUpHosts = this.srcUpHosts;
        newRegion.accUpHosts = this.accUpHosts;
        newRegion.iovipHost = this.iovipHost;
        newRegion.ioSrcHost = this.ioSrcHost;
        newRegion.rsHost = this.rsHost;
        newRegion.rsfHost = this.rsfHost;
        newRegion.apiHost = this.apiHost;
        newRegion.ucHost = this.ucHost;
        return newRegion;
    }

    public static class Builder {
        protected Region region;

        public Builder() {
            this.init();
        }

        public Builder(Region originRegion) {
            this.init();
            this.region.region = originRegion.region;
            this.region.srcUpHosts = originRegion.srcUpHosts;
            this.region.accUpHosts = originRegion.accUpHosts;
            this.region.iovipHost = originRegion.iovipHost;
            this.region.ioSrcHost = originRegion.ioSrcHost;
            this.region.rsHost = originRegion.rsHost;
            this.region.rsfHost = originRegion.rsfHost;
            this.region.apiHost = originRegion.apiHost;
        }

        protected void init() {
            this.region = new Region();
        }

        public Builder region(String region) {
            this.region.region = region;
            return this;
        }

        public Builder srcUpHost(String ... srcUpHosts) {
            this.region.srcUpHosts = Arrays.asList(srcUpHosts);
            return this;
        }

        public Builder accUpHost(String ... accUpHosts) {
            this.region.accUpHosts = Arrays.asList(accUpHosts);
            return this;
        }

        public Builder iovipHost(String iovipHost) {
            this.region.iovipHost = iovipHost;
            return this;
        }

        public Builder ioSrcHost(String ioSrcHost) {
            this.region.ioSrcHost = ioSrcHost;
            return this;
        }

        public Builder rsHost(String rsHost) {
            this.region.rsHost = rsHost;
            return this;
        }

        public Builder rsfHost(String rsfHost) {
            this.region.rsfHost = rsfHost;
            return this;
        }

        public Builder apiHost(String apiHost) {
            this.region.apiHost = apiHost;
            return this;
        }

        public Region autoRegion(String ucServer) {
            return new AutoRegion(ucServer);
        }

        public Region build() {
            return this.region;
        }
    }
}

