/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.storage.ApiUpload;
import com.qiniu.storage.ApiUtils;
import java.io.InputStream;

public class ApiUploadV1PutChunk
extends ApiUpload {
    public ApiUploadV1PutChunk(Client client) {
        super(client);
    }

    public ApiUploadV1PutChunk(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends ApiUpload.Response {
        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
        }

        public String getCtx() {
            return this.getStringValueFromDataMap("ctx");
        }

        public String getChecksum() {
            return this.getStringValueFromDataMap("checksum");
        }

        public Long getOffset() {
            return this.getLongValueFromDataMap("offset");
        }

        public String getHost() {
            return this.getStringValueFromDataMap("host");
        }

        public Long getCrc32() {
            return this.getLongValueFromDataMap("crc32");
        }

        public Long getExpiredAt() {
            return this.getLongValueFromDataMap("expired_at");
        }
    }

    public static class Request
    extends ApiUpload.Request {
        private String blockLastContext;
        private Integer chunkOffset;

        public Request(String urlPrefix, String token, String blockLastContext, Integer chunkOffset) {
            super(urlPrefix);
            this.setToken(token);
            this.setMethod(MethodType.POST);
            this.blockLastContext = blockLastContext;
            this.chunkOffset = chunkOffset;
        }

        public Request setChunkData(byte[] data, int offset, int size, String contentType) {
            super.setBody(data, offset, size, contentType);
            return this;
        }

        public Request setChunkData(InputStream data, String contentType, long limitSize) {
            super.setBody(data, contentType, limitSize);
            return this;
        }

        @Override
        protected void buildPath() throws QiniuException {
            if (this.chunkOffset == null) {
                ApiUtils.throwInvalidRequestParamException("chunk offset");
            }
            if (this.blockLastContext == null) {
                ApiUtils.throwInvalidRequestParamException("block last context");
            }
            this.addPathSegment("bput");
            this.addPathSegment(this.blockLastContext);
            this.addPathSegment(this.chunkOffset + "");
            super.buildPath();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            if (!this.hasBody()) {
                ApiUtils.throwInvalidRequestParamException("block chunk data");
            }
        }
    }
}

