/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.storage.ApiUpload;
import com.qiniu.storage.ApiUtils;
import com.qiniu.storage.UploadToken;
import com.qiniu.util.StringUtils;
import java.io.InputStream;

public class ApiUploadV2UploadPart
extends ApiUpload {
    public ApiUploadV2UploadPart(Client client) {
        super(client);
    }

    public ApiUploadV2UploadPart(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends ApiUpload.Response {
        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
        }

        public String getMd5() {
            return this.getStringValueFromDataMap("md5");
        }

        public String getEtag() {
            return this.getStringValueFromDataMap("etag");
        }
    }

    public static class Request
    extends ApiUpload.Request {
        private String key;
        private String uploadId;
        private Integer partNumber;

        public Request(String urlPrefix, String token, String uploadId, Integer partNumber) {
            super(urlPrefix);
            this.setToken(token);
            this.setMethod(MethodType.PUT);
            this.uploadId = uploadId;
            this.partNumber = partNumber;
        }

        public Request setKey(String key) {
            this.key = key;
            return this;
        }

        public Request setUploadData(byte[] data, int offset, int size, String contentType) {
            super.setBody(data, offset, size, contentType);
            return this;
        }

        public Request setUploadData(InputStream data, String contentType, long limitSize) {
            super.setBody(data, contentType, limitSize);
            return this;
        }

        @Override
        protected void buildPath() throws QiniuException {
            UploadToken token = this.getUploadToken();
            if (token == null || !token.isValid()) {
                ApiUtils.throwInvalidRequestParamException("token");
            }
            if (StringUtils.isNullOrEmpty(this.uploadId)) {
                ApiUtils.throwInvalidRequestParamException("uploadId");
            }
            if (this.partNumber == null) {
                ApiUtils.throwInvalidRequestParamException("partNumber");
            }
            String bucket = this.getUploadToken().getBucket();
            this.addPathSegment("buckets");
            this.addPathSegment(bucket);
            this.addPathSegment("objects");
            this.addPathSegment(ApiUtils.resumeV2EncodeKey(this.key));
            this.addPathSegment("uploads");
            this.addPathSegment(this.uploadId);
            this.addPathSegment(this.partNumber + "");
            super.buildPath();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            if (!this.hasBody()) {
                ApiUtils.throwInvalidRequestParamException("upload data");
            }
        }
    }
}

