/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.common;

import java.io.File;
import java.nio.charset.Charset;

public final class Constants {
    public static final String VERSION = "7.15.1";
    public static final int BLOCK_SIZE = 0x400000;
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final int CONNECT_TIMEOUT = 10;
    public static final int WRITE_TIMEOUT = 0;
    public static final int READ_TIMEOUT = 30;
    public static final int DISPATCHER_MAX_REQUESTS = 64;
    public static final int DISPATCHER_MAX_REQUESTS_PER_HOST = 16;
    public static final int CONNECTION_POOL_MAX_IDLE_COUNT = 32;
    public static final int CONNECTION_POOL_MAX_IDLE_MINUTES = 5;
    public static final String CACHE_DIR = Constants.getCacheDir();

    private Constants() {
    }

    private static String getCacheDir() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null || tmpDir.isEmpty()) {
            return null;
        }
        String qiniuDir = tmpDir + "com.qiniu.java-sdk";
        File dir = new File(qiniuDir);
        if (!dir.exists()) {
            return dir.mkdirs() ? qiniuDir : null;
        }
        if (dir.isDirectory()) {
            return qiniuDir;
        }
        return null;
    }
}

