/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.Api;
import com.qiniu.storage.ConfigHelper;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.HostProvider;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.ResumeUploadSource;
import com.qiniu.storage.Retry;
import com.qiniu.storage.UploadOptions;
import com.qiniu.storage.UploadToken;
import java.io.IOException;
import java.util.List;

abstract class ResumeUploadPerformer {
    final Client client;
    private final Recorder recorder;
    private final Configuration config;
    final ConfigHelper configHelper;
    final String key;
    final UploadToken token;
    final ResumeUploadSource uploadSource;
    final UploadOptions options;
    private Api.Config uploadApiConfig;

    ResumeUploadPerformer(Client client, String key, UploadToken token, ResumeUploadSource source, Recorder recorder, UploadOptions options, Configuration config) {
        this.client = client;
        this.key = key;
        this.token = token;
        this.uploadSource = source;
        this.options = options == null ? UploadOptions.defaultOptions() : options;
        this.recorder = recorder;
        this.config = config;
        this.configHelper = new ConfigHelper(config);
        List<String> ipHosts = this.configHelper.upHostsWithoutScheme();
        this.uploadApiConfig = new Api.Config.Builder().setSingleHostRetryMax(config.retryMax).setHostRetryMax(ipHosts.size()).setRetryInterval(Retry.staticInterval(config.retryInterval)).setHostFreezeDuration(config.hostFreezeDuration).setHostProvider(HostProvider.arrayProvider(ipHosts.toArray(new String[0]))).build();
    }

    protected Api.Config getUploadApiConfig() {
        return this.uploadApiConfig;
    }

    boolean isAllBlocksUploadingOrUploaded() {
        return this.uploadSource.isAllBlocksUploadingOrUploaded();
    }

    boolean isAllBlocksUploaded() {
        return this.uploadSource.isAllBlocksUploaded();
    }

    abstract boolean shouldUploadInit();

    abstract Response uploadInit() throws QiniuException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response uploadNextData() throws QiniuException {
        ResumeUploadSource.Block block = null;
        Object object = this;
        synchronized (object) {
            block = this.getNextUploadingBlock();
            if (block != null) {
                block.isUploading = true;
            }
        }
        if (block == null) {
            return Response.createSuccessResponse();
        }
        try {
            object = this.uploadBlock(block);
            return object;
        }
        finally {
            block.isUploading = false;
        }
    }

    abstract Response uploadBlock(ResumeUploadSource.Block var1) throws QiniuException;

    abstract Response completeUpload() throws QiniuException;

    private ResumeUploadSource.Block getNextUploadingBlock() throws QiniuException {
        ResumeUploadSource.Block block = null;
        try {
            block = this.uploadSource.getNextUploadingBlock();
        }
        catch (IOException e) {
            throw QiniuException.unrecoverable(e);
        }
        return block;
    }
}

