/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.processing;

import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.processing.OperationStatus;
import com.qiniu.storage.Configuration;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;

public final class OperationManager {
    private final Client client;
    private final Auth auth;
    private final Configuration configuration;

    public OperationManager(Auth auth, Configuration cfg) {
        this.auth = auth;
        this.configuration = cfg.clone();
        this.client = new Client(this.configuration);
    }

    public String pfop(String bucket, String key, String fops) throws QiniuException {
        return this.pfop(bucket, key, fops, null);
    }

    public String pfop(String bucket, String key, String fops, StringMap params) throws QiniuException {
        params = params == null ? new StringMap() : params;
        params.put("bucket", bucket).put("key", key).put("fops", fops);
        byte[] data = StringUtils.utf8Bytes(params.formString());
        String url = this.configuration.apiHost(this.auth.accessKey, bucket) + "/pfop/";
        StringMap headers = this.auth.authorization(url, data, "application/x-www-form-urlencoded");
        Response response = this.client.post(url, data, headers, "application/x-www-form-urlencoded");
        PfopResult status = response.jsonToObject(PfopResult.class);
        if (status != null) {
            return status.persistentId;
        }
        return null;
    }

    public String pfop(String bucket, String key, String fops, String pipeline, String notifyURL) throws QiniuException {
        StringMap params = new StringMap().put("pipeline", pipeline).putNotEmpty("notifyURL", notifyURL);
        return this.pfop(bucket, key, fops, params);
    }

    public String pfop(String bucket, String key, String fops, String pipeline, boolean force) throws QiniuException {
        StringMap params = new StringMap().put("pipeline", pipeline).putWhen("force", 1, force);
        return this.pfop(bucket, key, fops, params);
    }

    public String pfop(String bucket, String key, String fops, String pipeline, String notifyURL, boolean force) throws QiniuException {
        StringMap params = new StringMap().put("pipeline", pipeline).put("notifyURL", notifyURL).putWhen("force", 1, force);
        return this.pfop(bucket, key, fops, params);
    }

    public OperationStatus prefop(String persistentId) throws QiniuException {
        StringMap params = new StringMap().put("id", persistentId);
        byte[] data = StringUtils.utf8Bytes(params.formString());
        Zone zone = null;
        String[] items = persistentId.trim().split("\\.");
        if (items.length != 2) {
            throw new QiniuException(new Exception("invalid persistentId"));
        }
        String zoneCode = items[0];
        if (zoneCode.equals("z0")) {
            zone = Zone.zone0();
        } else if (zoneCode.equals("z1")) {
            zone = Zone.zone1();
        } else if (zoneCode.equals("z2")) {
            zone = Zone.zone2();
        } else if (zoneCode.equals("na0")) {
            zone = Zone.zoneNa0();
        } else {
            throw new QiniuException(new Exception("invalid persistentId"));
        }
        String apiHost = zone.getApiHttp();
        if (this.configuration != null && this.configuration.useHttpsDomains) {
            apiHost = zone.getApiHttps();
        }
        String url = String.format("%s/status/get/prefop", apiHost);
        Response response = new Client().post(url, data, null, "application/x-www-form-urlencoded");
        OperationStatus status = response.jsonToObject(OperationStatus.class);
        return status;
    }

    private class PfopResult {
        public String persistentId;

        private PfopResult() {
        }
    }
}

