/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.util;

import com.qiniu.util.Etag;
import com.qiniu.util.UrlSafeBase64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class EtagV2 {
    private EtagV2() {
    }

    public static String data(byte[] data, int offset, int length, long blockSize) {
        try {
            return EtagV2.stream((InputStream)new ByteArrayInputStream(data, offset, length), (long)length, blockSize);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String data(byte[] data, long blockSize) {
        return EtagV2.data(data, 0, data.length, blockSize);
    }

    public static String data(byte[] data, int offset, int length, long[] parts) {
        try {
            return EtagV2.stream((InputStream)new ByteArrayInputStream(data, offset, length), (long)length, parts);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String data(byte[] data, long[] parts) {
        return EtagV2.data(data, 0, data.length, parts);
    }

    public static String file(String filePath, long blockSize) throws IOException {
        return EtagV2.file(new File(filePath), blockSize);
    }

    public static String file(String filePath, long[] parts) throws IOException {
        return EtagV2.file(new File(filePath), parts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String file(File file, long blockSize) throws IOException {
        FileInputStream fi = null;
        try {
            fi = new FileInputStream(file);
            String string = EtagV2.stream((InputStream)fi, file.length(), blockSize);
            return string;
        }
        finally {
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String file(File file, long[] parts) throws IOException {
        FileInputStream fi = null;
        try {
            fi = new FileInputStream(file);
            String string = EtagV2.stream((InputStream)fi, file.length(), parts);
            return string;
        }
        finally {
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static String stream(InputStream in, long len, long blockSize) throws IOException {
        if (blockSize == 0x400000L || len <= blockSize && len <= 0x400000L) {
            return Etag.stream(in, len);
        }
        int size = (int)((len + blockSize - 1L) / blockSize);
        long[] parts = new long[size];
        Arrays.fill(parts, 0, size - 1, blockSize);
        parts[size - 1] = len % blockSize;
        return EtagV2.etagV2(in, len, parts);
    }

    public static String stream(InputStream in, long len, long[] parts) throws IOException {
        if (EtagV2.is4MBParts(parts)) {
            return Etag.stream(in, len);
        }
        return EtagV2.etagV2(in, len, parts);
    }

    private static boolean is4MBParts(long[] parts) {
        int idx = 0;
        int last = parts.length - 1;
        for (long part : parts) {
            if (idx != last && part != 0x400000L || part > 0x400000L) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    private static String etagV2(InputStream in, long len, long[] parts) throws IOException {
        MessageDigest sha1;
        long partSize = 0L;
        for (long part : parts) {
            partSize += part;
        }
        if (len != partSize) {
            throw new IOException("etag calc failed: size not equal with part size");
        }
        try {
            sha1 = MessageDigest.getInstance("sha-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        for (long part : parts) {
            String partEtag = Etag.stream(in, part);
            byte[] bytes = UrlSafeBase64.decode(partEtag);
            sha1.update(bytes, 1, bytes.length - 1);
        }
        byte[] digest = sha1.digest();
        byte[] ret = new byte[digest.length + 1];
        ret[0] = -98;
        System.arraycopy(digest, 0, ret, 1, digest.length);
        return UrlSafeBase64.encodeToString(ret);
    }
}

