/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.Types;
import com.querydsl.codegen.EntitySerializer;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.core.types.dsl.BeanPath;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.ComparablePath;
import com.querydsl.core.types.dsl.DatePath;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.TimePath;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;

public final class EmbeddableSerializer
extends EntitySerializer {
    @Inject
    public EmbeddableSerializer(TypeMappings typeMappings, @Named(value="keywords") Collection<String> keywords) {
        super(typeMappings, keywords);
    }

    @Override
    protected void introClassHeader(CodeWriter writer, EntityType model) throws IOException {
        Class<BeanPath> pathType;
        Type queryType = this.typeMappings.getPathType((Type)model, model, true);
        TypeCategory category = model.getOriginalCategory();
        if (model.getProperties().isEmpty()) {
            switch (category) {
                case COMPARABLE: {
                    pathType = ComparablePath.class;
                    break;
                }
                case ENUM: {
                    pathType = EnumPath.class;
                    break;
                }
                case DATE: {
                    pathType = DatePath.class;
                    break;
                }
                case DATETIME: {
                    pathType = DateTimePath.class;
                    break;
                }
                case TIME: {
                    pathType = TimePath.class;
                    break;
                }
                case NUMERIC: {
                    pathType = NumberPath.class;
                    break;
                }
                case STRING: {
                    pathType = StringPath.class;
                    break;
                }
                case BOOLEAN: {
                    pathType = BooleanPath.class;
                    break;
                }
                default: {
                    pathType = BeanPath.class;
                    break;
                }
            }
        } else {
            pathType = BeanPath.class;
        }
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        writer.line(new String[]{"@Generated(\"", this.getClass().getName(), "\")"});
        if (category == TypeCategory.BOOLEAN || category == TypeCategory.STRING) {
            writer.beginClass(queryType, (Type)new ClassType(pathType, new Type[0]), new Type[0]);
        } else {
            writer.beginClass(queryType, (Type)new ClassType(category, pathType, new Type[]{model}), new Type[0]);
        }
        writer.privateStaticFinal((Type)Types.LONG_P, "serialVersionUID", model.hashCode() + "L");
    }
}

