/*
 * Decompiled with CFR 0.152.
 */
package com.quigley.zabbixj.agent;

import com.quigley.zabbixj.agent.active.ActiveThread;
import com.quigley.zabbixj.agent.passive.ListenerThread;
import com.quigley.zabbixj.metrics.MetricsContainer;
import com.quigley.zabbixj.metrics.MetricsProvider;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZabbixAgent {
    private boolean enablePassive = true;
    private InetAddress listenAddress = null;
    private int listenPort = 10050;
    private boolean enableActive = false;
    private String hostName;
    private InetAddress serverAddress = null;
    private int serverPort = 10051;
    private int refreshInterval = 120;
    private MetricsContainer metricsContainer = new MetricsContainer();
    private ListenerThread listenerThread;
    private ActiveThread activeThread;
    private static Logger log = LoggerFactory.getLogger(ZabbixAgent.class);

    public void start() throws Exception {
        if (log.isInfoEnabled()) {
            log.info("Starting Zabbix agent.");
        }
        if (this.enablePassive) {
            if (log.isInfoEnabled()) {
                log.info("Starting passive listener.");
            }
            this.listenerThread = this.listenAddress == null ? new ListenerThread(this.metricsContainer, this.listenPort) : new ListenerThread(this.metricsContainer, this.listenAddress, this.listenPort);
            this.listenerThread.start();
            if (log.isInfoEnabled()) {
                log.info("Passive listener started.");
            }
        }
        if (this.enableActive) {
            if (log.isInfoEnabled()) {
                log.info("Starting active agent.");
            }
            this.activeThread = new ActiveThread(this.metricsContainer, this.hostName, this.serverAddress, this.serverPort, this.refreshInterval);
            this.activeThread.start();
            if (log.isInfoEnabled()) {
                log.info("Active agent started.");
            }
        }
        if (log.isInfoEnabled()) {
            log.info("Zabbix agent started.");
        }
    }

    public void stop() {
        if (log.isInfoEnabled()) {
            log.info("Stopping Zabbix agent.");
        }
        if (this.enablePassive) {
            if (log.isInfoEnabled()) {
                log.info("Stopping passive listener.");
            }
            this.listenerThread.shutdown();
            try {
                this.listenerThread.join();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (log.isInfoEnabled()) {
                log.info("Passive listener stopped.");
            }
        }
        if (this.enableActive) {
            if (log.isInfoEnabled()) {
                log.info("Stopping active agent.");
            }
            this.activeThread.shutdown();
            try {
                this.activeThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (log.isInfoEnabled()) {
                log.info("Active agent stopped.");
            }
        }
        if (log.isInfoEnabled()) {
            log.info("Zabbix agent stopped.");
        }
    }

    public boolean isEnablePassive() {
        return this.enablePassive;
    }

    public void setEnablePassive(boolean enablePassive) {
        this.enablePassive = enablePassive;
    }

    public String getListenAddress() {
        return this.listenAddress.getHostAddress();
    }

    public void setListenAddress(String listenAddress) throws UnknownHostException {
        this.listenAddress = InetAddress.getByName(listenAddress);
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    public boolean isEnableActive() {
        return this.enableActive;
    }

    public void setEnableActive(boolean enableActive) {
        this.enableActive = enableActive;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public InetAddress getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(InetAddress serverAddress) {
        this.serverAddress = serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public void addProvider(String name, MetricsProvider provider) {
        this.metricsContainer.addProvider(name, provider);
    }

    public void setProviders(Map<String, MetricsProvider> providers) {
        this.metricsContainer.addProviders(providers);
    }
}

