/*
 * Decompiled with CFR 0.152.
 */
package com.quigley.zabbixj.agent.active;

import com.quigley.zabbixj.ZabbixException;
import com.quigley.zabbixj.metrics.MetricsContainer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveThread
extends Thread {
    private boolean running = true;
    private Map<Integer, List<String>> checks = new HashMap<Integer, List<String>>();
    private Map<Integer, Long> lastChecked = new HashMap<Integer, Long>();
    private long lastRefresh;
    private MetricsContainer metricsContainer;
    private String hostName;
    private InetAddress serverAddress;
    private int serverPort;
    private int refreshInterval;
    private static Logger log = LoggerFactory.getLogger(ActiveThread.class);

    public ActiveThread(MetricsContainer metricsContainer, String hostName, InetAddress serverAddress, int serverPort, int refreshInterval) {
        this.metricsContainer = metricsContainer;
        this.hostName = hostName;
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
        this.refreshInterval = refreshInterval;
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug("ActiveThread Starting.");
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Starting initial refresh of active checks.");
            }
            this.requestActiveChecks();
            if (log.isDebugEnabled()) {
                log.debug("Initial refresh of active checks completed.");
            }
        }
        catch (Exception e) {
            log.error("Initial refresh failed.", (Throwable)e);
        }
        while (this.running) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                return;
            }
            long clock = System.currentTimeMillis() / 1000L;
            if (clock - this.lastRefresh >= (long)this.refreshInterval) {
                try {
                    this.requestActiveChecks();
                }
                catch (Exception e) {
                    log.error("Unable to refresh.", (Throwable)e);
                }
            }
            for (int delay : this.checks.keySet()) {
                long delayLastChecked = this.lastChecked.get(delay);
                if (clock - delayLastChecked < (long)delay) continue;
                try {
                    this.sendMetrics(delay, this.checks.get(delay));
                }
                catch (Exception e) {
                    log.error("Unable to send metrics.", (Throwable)e);
                }
            }
        }
    }

    private void requestActiveChecks() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Requesting a list of active checks from the server.");
        }
        Socket socket = new Socket(this.serverAddress, this.serverPort);
        InputStream input = socket.getInputStream();
        OutputStream output = socket.getOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JSONObject request = new JSONObject();
        request.put("request", (Object)"active checks");
        request.put("host", (Object)this.hostName);
        byte[] buffer = this.getRequest(request);
        output.write(buffer);
        output.flush();
        buffer = new byte[10240];
        int read = 0;
        while ((read = input.read(buffer, 0, 10240)) != -1) {
            baos.write(buffer, 0, read);
        }
        socket.close();
        JSONObject response = this.getResponse(baos.toByteArray());
        if (response.getString("response").equals("success")) {
            this.refreshFromActiveChecksResponse(response);
        } else {
            log.warn("Server reported a failure when requesting active checks:" + response.getString("info"));
        }
        this.lastRefresh = System.currentTimeMillis() / 1000L;
    }

    private void refreshFromActiveChecksResponse(JSONObject response) throws JSONException {
        ActiveChecksResponseIndex index = this.getActiveChecksResponseIndex(response);
        this.insertNewChecks(index);
        this.pruneChangedChecks(index);
        this.pruneUnusedDelays(index);
    }

    private ActiveChecksResponseIndex getActiveChecksResponseIndex(JSONObject response) throws JSONException {
        ActiveChecksResponseIndex index = new ActiveChecksResponseIndex();
        JSONArray data = response.getJSONArray("data");
        for (int i = 0; i < data.length(); ++i) {
            JSONObject check = data.getJSONObject(i);
            String key = check.getString("key");
            int delay = check.getInt("delay");
            index.add(key, delay);
        }
        return index;
    }

    private void insertNewChecks(ActiveChecksResponseIndex index) {
        long clock = System.currentTimeMillis() / 1000L;
        for (String key : index.getIndex().keySet()) {
            List<String> keysForDelay;
            int delay = index.getIndex().get(key);
            if (!this.checks.containsKey(delay)) {
                if (log.isDebugEnabled()) {
                    log.debug("Inserting new check list for delay '" + delay + "'.");
                }
                this.checks.put(delay, new ArrayList());
            }
            if (!(keysForDelay = this.checks.get(delay)).contains(key)) {
                if (log.isDebugEnabled()) {
                    log.debug("Adding new key '" + key + "' to check list for delay '" + delay + "'.");
                }
                keysForDelay.add(key);
            }
            if (this.lastChecked.containsKey(delay)) continue;
            this.lastChecked.put(delay, clock);
        }
    }

    private void pruneChangedChecks(ActiveChecksResponseIndex index) {
        for (int delay : index.getDelays()) {
            List<String> keysForDelay = this.checks.get(delay);
            for (String key : new ArrayList<String>(keysForDelay)) {
                if (index.getIndex().containsKey(key)) {
                    int currentDelay = index.getIndex().get(key);
                    if (currentDelay == delay) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Removing '" + key + "' from delay '" + delay + "' list.");
                    }
                    keysForDelay.remove(key);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Removing '" + key + "' from delay '" + delay + "' list.");
                }
                keysForDelay.remove(key);
            }
            this.checks.put(delay, keysForDelay);
        }
    }

    private void pruneUnusedDelays(ActiveChecksResponseIndex index) {
        for (int delay : new ArrayList<Integer>(this.lastChecked.keySet())) {
            if (index.getDelays().contains(delay)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Removing unused delay '" + delay + "' from last checked list.");
            }
            this.lastChecked.remove(delay);
        }
        for (int delay : new ArrayList<Integer>(this.checks.keySet())) {
            if (index.getDelays().contains(delay)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Removing unused delay '" + delay + "' from checks.");
            }
            this.checks.remove(delay);
        }
    }

    private void sendMetrics(int delay, List<String> keyList) throws Exception {
        if (log.isDebugEnabled()) {
            String message = "Sending metrics for delay '" + delay + "' with keys: ";
            for (int i = 0; i < keyList.size(); ++i) {
                if (i > 0) {
                    message = message + ", ";
                }
                message = message + keyList.get(i);
            }
            log.debug(message);
        }
        long clock = System.currentTimeMillis() / 1000L;
        JSONObject metrics = new JSONObject();
        metrics.put("request", (Object)"agent data");
        JSONArray data = new JSONArray();
        for (String keyName : keyList) {
            JSONObject key = new JSONObject();
            key.put("host", (Object)this.hostName);
            key.put("key", (Object)keyName);
            try {
                Object value = this.metricsContainer.getMetric(keyName);
                key.put("value", (Object)value.toString());
            }
            catch (Exception e) {
                key.put("value", (Object)"ZBX_NOTSUPPORTED");
            }
            key.put("clock", (Object)("" + clock));
            data.put((Object)key);
        }
        metrics.put("data", (Object)data);
        metrics.put("clock", (Object)("" + clock));
        Socket socket = new Socket(this.serverAddress, this.serverPort);
        InputStream input = socket.getInputStream();
        OutputStream output = socket.getOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        output.write(this.getRequest(metrics));
        output.flush();
        byte[] buffer = new byte[10240];
        int read = 0;
        while ((read = input.read(buffer, 0, 10240)) != -1) {
            baos.write(buffer, 0, read);
        }
        socket.close();
        JSONObject response = this.getResponse(baos.toByteArray());
        if (response.getString("response").equals("success")) {
            if (log.isDebugEnabled()) {
                log.debug("The server reported success '" + response.getString("info") + "'.");
            }
        } else {
            log.error("Failure!");
        }
        this.lastChecked.put(delay, clock);
    }

    private byte[] getRequest(JSONObject jsonObject) throws Exception {
        int i;
        byte[] requestBytes = jsonObject.toString().getBytes();
        String header = "ZBXD\u0001";
        byte[] headerBytes = header.getBytes();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeLong(requestBytes.length);
        dos.flush();
        dos.close();
        bos.close();
        byte[] requestLengthBytes = bos.toByteArray();
        byte[] allBytes = new byte[headerBytes.length + requestLengthBytes.length + requestBytes.length];
        int index = 0;
        for (i = 0; i < headerBytes.length; ++i) {
            allBytes[index++] = headerBytes[i];
        }
        for (i = 0; i < requestLengthBytes.length; ++i) {
            allBytes[index++] = requestLengthBytes[7 - i];
        }
        for (i = 0; i < requestBytes.length; ++i) {
            allBytes[index++] = requestBytes[i];
        }
        return allBytes;
    }

    private JSONObject getResponse(byte[] responseBytes) throws Exception {
        byte[] sizeBuffer = new byte[8];
        int index = 0;
        for (int i = 12; i > 4; --i) {
            sizeBuffer[index++] = responseBytes[i];
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(sizeBuffer);
        DataInputStream dis = new DataInputStream(bais);
        long size = dis.readLong();
        dis.close();
        bais.close();
        byte[] jsonBuffer = new byte[responseBytes.length - 13];
        if ((long)jsonBuffer.length != size) {
            throw new ZabbixException("Reported and actual buffer sizes differ!");
        }
        index = 0;
        for (int i = 13; i < responseBytes.length; ++i) {
            jsonBuffer[index++] = responseBytes[i];
        }
        JSONObject response = new JSONObject(new String(jsonBuffer));
        return response;
    }

    public void shutdown() {
        this.running = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActiveChecksResponseIndex {
        private Map<String, Integer> index = new HashMap<String, Integer>();
        private List<Integer> delays = new ArrayList<Integer>();

        public Map<String, Integer> getIndex() {
            return this.index;
        }

        public List<Integer> getDelays() {
            return this.delays;
        }

        public void add(String key, int delay) {
            this.index.put(key, delay);
            if (!this.delays.contains(delay)) {
                this.delays.add(delay);
            }
        }
    }
}

