/*
 * Decompiled with CFR 0.152.
 */
package com.quigley.zabbixj.agent.passive;

import com.quigley.zabbixj.agent.passive.WorkerThread;
import com.quigley.zabbixj.metrics.MetricsContainer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerThread
extends Thread {
    private boolean running = true;
    private MetricsContainer container;
    private ServerSocket serverSocket;
    private static Logger log = LoggerFactory.getLogger(ListenerThread.class);

    public ListenerThread(MetricsContainer container, int port) throws Exception {
        this.container = container;
        this.serverSocket = new ServerSocket(port, 5);
        this.serverSocket.setSoTimeout(1000);
    }

    public ListenerThread(MetricsContainer container, InetAddress address, int port) throws Exception {
        this.container = container;
        this.serverSocket = new ServerSocket(port, 5, address);
        this.serverSocket.setSoTimeout(1000);
    }

    public void run() {
        if (log.isDebugEnabled()) {
            log.debug("ListenerThread Starting.");
        }
        while (this.running) {
            try {
                Socket clientSocket = this.serverSocket.accept();
                WorkerThread worker = new WorkerThread(this.container, clientSocket);
                worker.start();
            }
            catch (SocketTimeoutException ste) {
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error("Error Accepting: " + e.toString());
            }
        }
    }

    public void shutdown() {
        this.running = false;
    }
}

