/*
 * Decompiled with CFR 0.152.
 */
package com.quigley.zabbixj.agent.passive;

import com.quigley.zabbixj.metrics.MetricsContainer;
import com.quigley.zabbixj.metrics.MetricsException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerThread
extends Thread {
    private MetricsContainer container;
    private Socket socket;
    private static Logger log = LoggerFactory.getLogger(WorkerThread.class);

    public WorkerThread(MetricsContainer container, Socket socket) {
        this.container = container;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String client = this.socket.getInetAddress().getHostAddress();
        if (log.isDebugEnabled()) {
            log.info("Accepted Connection From: " + client);
        }
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            this.socket.setSoTimeout(1000);
            out = new PrintWriter(this.socket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            String inputLine = in.readLine();
            if (inputLine.substring(0, 4).equals("ZBXD")) {
                inputLine = inputLine.substring(13, inputLine.length());
            }
            if (inputLine != null) {
                try {
                    Object value = this.container.getMetric(inputLine);
                    out.print(value.toString());
                    out.flush();
                }
                catch (MetricsException me) {
                    if (log.isErrorEnabled()) {
                        log.error("Client: " + client + " Sent Unknown Key: " + inputLine);
                    }
                    out.print("ZBX_NOTSUPPORTED");
                    out.flush();
                }
            }
        }
        catch (SocketTimeoutException ste) {
            log.debug(client + ": Timeout Detected.");
        }
        catch (Exception e) {
            log.error(client + ": Error: " + e.toString());
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug(client + ": Disconnected.");
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {}
            try {
                this.socket.close();
            }
            catch (Exception e) {}
        }
    }
}

