/*
 * Decompiled with CFR 0.152.
 */
package com.quigley.zabbixj.metrics;

import com.quigley.zabbixj.metrics.MetricsException;
import com.quigley.zabbixj.metrics.MetricsKey;
import com.quigley.zabbixj.metrics.MetricsProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricsContainer {
    private Map<String, MetricsProvider> container = new HashMap<String, MetricsProvider>();
    private static Logger log = LoggerFactory.getLogger(MetricsProvider.class);

    public String[] listProviders() {
        String[] providers = new String[this.container.size()];
        int i = 0;
        Iterator<String> ki = this.container.keySet().iterator();
        while (ki.hasNext()) {
            providers[i++] = ki.next();
        }
        return providers;
    }

    public void addProvider(String name, MetricsProvider provider) {
        if (log.isInfoEnabled()) {
            log.info("Adding Provider: " + provider.getClass().getName() + "=" + name);
        }
        this.container.put(name, provider);
    }

    public void addProviders(Map<String, MetricsProvider> providers) {
        if (log.isInfoEnabled()) {
            for (String name : providers.keySet()) {
                MetricsProvider provider = providers.get(name);
                log.info("Adding Provider: " + provider.getClass().getName() + "=" + name);
            }
        }
        this.container.putAll(providers);
    }

    public MetricsProvider getProvider(String name) throws MetricsException {
        if (this.container.containsKey(name)) {
            return this.container.get(name);
        }
        throw new MetricsException("No MetricsProvider with name: " + name);
    }

    public Object getMetric(String key) throws MetricsException {
        MetricsKey mk = new MetricsKey(key);
        MetricsProvider provider = this.getProvider(mk.getProvider());
        return provider.getValue(mk);
    }
}

