/*
 * Decompiled with CFR 0.152.
 */
package com.quigley.zabbixj.metrics;

import com.quigley.zabbixj.metrics.MetricsException;
import java.util.StringTokenizer;

public class MetricsKey {
    private String provider;
    private String key;
    private String[] parameters;
    private static final char KEY_SEPARATOR = '.';
    private static final char PARAMS_START = '[';
    private static final char PARAMS_END = ']';
    private static final char PARAMS_SEPARATOR = ',';

    public MetricsKey(String keyData) throws MetricsException {
        this.parseKey(keyData);
    }

    public String getProvider() {
        return this.provider;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isParameters() {
        return this.parameters != null;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("MetricsKey:(");
        out.append("provider:(").append(this.provider).append(") ");
        out.append("key:(").append(this.key).append(") ");
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
                out.append("parameter[").append(i).append("]:(").append(this.parameters[i]).append(")");
            }
        }
        out.append(")");
        return out.toString();
    }

    private void parseKey(String keyData) throws MetricsException {
        block6: {
            try {
                int firstSepIdx = keyData.indexOf(46);
                if (firstSepIdx > 0) {
                    this.provider = keyData.substring(0, firstSepIdx);
                    String localStr = keyData.substring(firstSepIdx + 1, keyData.length());
                    int startParamsIdx = localStr.indexOf(91) + 1;
                    int endParamsIdx = localStr.lastIndexOf(93);
                    if (startParamsIdx != -1 && endParamsIdx != -1) {
                        this.key = localStr.substring(0, localStr.indexOf(91));
                        String paramsStr = localStr.substring(startParamsIdx, endParamsIdx);
                        StringTokenizer paramsStrTokens = new StringTokenizer(paramsStr, ",");
                        this.parameters = new String[paramsStrTokens.countTokens()];
                        int i = 0;
                        while (paramsStrTokens.hasMoreTokens()) {
                            this.parameters[i++] = paramsStrTokens.nextToken();
                        }
                    } else {
                        this.key = localStr;
                    }
                    break block6;
                }
                String msg = "Key string does not contain separator character!";
                throw new MetricsException(msg);
            }
            catch (Exception e) {
                String msg = "Parse Error: " + e.toString();
                throw new MetricsException(msg, e);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        MetricsKey mk = new MetricsKey(args[0]);
        System.out.println(mk.toString());
    }
}

