/*
 * Decompiled with CFR 0.152.
 */
package cn.com.do1.apisdk.util;

import cn.com.do1.apisdk.inter.rep.vo.DownloadResultVO;
import cn.com.do1.apisdk.util.JSONUtil;
import cn.com.do1.apisdk.util.QwSdkUtil;
import cn.com.do1.apisdk.util.SdkConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;

public class HttpDownloadUtil {
    private static final String TOKEN = QwSdkUtil.getCacheToken();
    private static final String URL = SdkConfig.getString("baseUrl") + "/api/download/download.do";
    private static final String URLB = SdkConfig.getString("baseUrl") + "/api/download/downloadBatch.do";
    private static final int CONNECT_TIME_OUT = 5000;
    private static final int SOCKET_TIME_OUT = 1800000;
    private static final int BYTE_SIZE = 1024;
    private static final String ZIP_ENCODING = "GBK";

    public static File sendGet(String savePath, Map<String, String> parameters) throws IOException {
        parameters.put("token", TOKEN);
        String fileUrl = parameters.get("fileUrl");
        String[] split = fileUrl.split("/");
        String fileName = split[split.length - 1];
        File file = new File(savePath + File.separator + fileName);
        InputStream inputStream = null;
        FileOutputStream downloadFile = null;
        StringBuilder sb = new StringBuilder();
        String params = "";
        try {
            if (parameters.size() == 1) {
                for (String name : parameters.keySet()) {
                    sb.append(name).append("=").append(URLEncoder.encode(parameters.get(name), "UTF-8"));
                }
                params = sb.toString();
            } else {
                for (String name : parameters.keySet()) {
                    sb.append(name).append("=").append(URLEncoder.encode(parameters.get(name), "UTF-8")).append("&");
                }
                String temp_params = sb.toString();
                params = temp_params.substring(0, temp_params.length() - 1);
            }
            String full_url = URL + "?" + params;
            GetMethod getMethod = new GetMethod(full_url);
            getMethod.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
            HttpClient client = new HttpClient();
            client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            client.getHttpConnectionManager().getParams().setSoTimeout(1800000);
            int status = client.executeMethod((HttpMethod)getMethod);
            if (status == 200) {
                int len;
                inputStream = getMethod.getResponseBodyAsStream();
                downloadFile = new FileOutputStream(file);
                byte[] b = new byte[1024];
                while ((len = inputStream.read(b)) > 0) {
                    downloadFile.write(b, 0, len);
                }
            }
        }
        catch (Exception e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(downloadFile);
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(downloadFile);
        IOUtils.closeQuietly((InputStream)inputStream);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadResultVO sendPost(String savePath, Map<String, Object> parameters) throws IOException {
        parameters.put("token", TOKEN);
        InputStream inputStream = null;
        FileOutputStream downloadFile = null;
        StringBuilder sb = new StringBuilder();
        String params = "";
        DownloadResultVO downloadResultVO = new DownloadResultVO();
        Object fileUrls = parameters.get("fileUrls");
        parameters.put("fileUrls", JSONUtil.arrayToString(fileUrls));
        File zipFile = new File(savePath + File.separator + UUID.randomUUID().toString() + ".zip");
        try {
            if (parameters.size() == 1) {
                for (String name : parameters.keySet()) {
                    sb.append(name).append("=").append(URLEncoder.encode((String)parameters.get(name), "UTF-8"));
                }
                params = sb.toString();
            } else {
                for (String name : parameters.keySet()) {
                    sb.append(name).append("=").append(URLEncoder.encode((String)parameters.get(name), "UTF-8")).append("&");
                }
                String temp_params = sb.toString();
                params = temp_params.substring(0, temp_params.length() - 1);
            }
            String full_url = URLB + "?" + params;
            PostMethod postMethod = new PostMethod(full_url);
            postMethod.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
            HttpClient client = new HttpClient();
            client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            client.getHttpConnectionManager().getParams().setSoTimeout(1800000);
            int status = client.executeMethod((HttpMethod)postMethod);
            if (status == 200) {
                int len;
                inputStream = postMethod.getResponseBodyAsStream();
                downloadFile = new FileOutputStream(zipFile);
                byte[] b = new byte[1024];
                while ((len = inputStream.read(b)) > 0) {
                    downloadFile.write(b, 0, len);
                }
                List<File> fileList = HttpDownloadUtil.unZipAndDownload(savePath, zipFile);
                File file = fileList.get(fileList.size() - 1);
                FileInputStream exportFile = new FileInputStream(file);
                BufferedReader br = new BufferedReader(new InputStreamReader(exportFile));
                StringBuilder stringBuffer = new StringBuilder();
                String str = null;
                while ((str = br.readLine()) != null) {
                    stringBuffer.append(str);
                }
                String returnJson = stringBuffer.toString();
                Map map = HttpDownloadUtil.getFileByUrl((List)fileUrls, fileList);
                downloadResultVO.setFiles(map);
                downloadResultVO.setResultString(returnJson);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(downloadFile);
            IOUtils.closeQuietly(inputStream);
            zipFile.delete();
            throw throwable;
        }
        IOUtils.closeQuietly(downloadFile);
        IOUtils.closeQuietly((InputStream)inputStream);
        zipFile.delete();
        return downloadResultVO;
    }

    private static List<File> unZipAndDownload(String savePath, File zip) throws IOException {
        ArrayList<File> fileList = new ArrayList<File>();
        ZipFile zipFile = new ZipFile(zip, Charset.forName(ZIP_ENCODING));
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String filename = entry.getName();
            File file = new File(savePath + "/" + filename);
            InputStream inputStream = zipFile.getInputStream(entry);
            FileOutputStream outputStream = new FileOutputStream(file);
            byte[] buf = new byte[(int)entry.getSize()];
            while ((len = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, len);
            }
            fileList.add(file);
            inputStream.close();
            outputStream.close();
        }
        zipFile.close();
        return fileList;
    }

    public static Map getFileByUrl(List<String> fileUrls, List<File> fileList) {
        HashMap<String, File> map = new HashMap<String, File>(fileUrls.size());
        for (String fileUrl : fileUrls) {
            String[] split = fileUrl.split("/");
            String fileName = split[split.length - 1];
            for (File file : fileList) {
                if (!fileName.equals(file.getName())) continue;
                map.put(fileUrl, file);
            }
        }
        return map;
    }
}

