/*
 * Decompiled with CFR 0.152.
 */
package cn.com.do1.apisdk.util;

import cn.com.do1.apisdk.util.CycleDetectionStrategyImpl;
import cn.com.do1.apisdk.util.DateTimeJsonValueProcesser;
import cn.com.do1.apisdk.util.DefaultDefaultValueProcessor;
import cn.com.do1.apisdk.util.JsonFormatTool;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.DefaultValueProcessor;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.CycleDetectionStrategy;
import net.sf.json.util.PropertyFilter;
import net.sf.json.xml.XMLSerializer;

public class JSONUtil {
    private static final JsonConfig config = new JsonConfig();

    public static String stringify(Object o) {
        if (o == null) {
            return "";
        }
        if (o.getClass().isArray() || o instanceof Iterable) {
            return JsonFormatTool.formatJson(JSONUtil.arrayToString(o));
        }
        return JsonFormatTool.formatJson(JSONUtil.objectToString(o));
    }

    public static String objectToString(Object o) {
        JSONObject json = null;
        json = JSONObject.fromObject((Object)o, (JsonConfig)config);
        return json.toString();
    }

    public static String arrayToString(Object o) {
        JSONArray json = null;
        json = JSONArray.fromObject((Object)o, (JsonConfig)config);
        return json.toString();
    }

    public static <T> T stringToObject(String jsonStr, Class<T> clazz) {
        JSONObject json = null;
        json = JSONObject.fromObject((Object)jsonStr, (JsonConfig)config);
        return (T)JSONObject.toBean((JSONObject)json, clazz);
    }

    public static <T> T stringToObject(String jsonStr, Class<T> clazz, Map<String, Class> classMap) {
        JSONObject json = null;
        json = JSONObject.fromObject((Object)jsonStr, (JsonConfig)config);
        return (T)JSONObject.toBean((JSONObject)json, clazz, classMap);
    }

    public static <T> List<T> stringToObjectList(String jsonStr, Class<T> clazz) {
        JSONArray json = null;
        json = JSONArray.fromObject((Object)jsonStr);
        return JSONArray.toList((JSONArray)json, clazz);
    }

    public static <T> List<T> stringToObjectList(String jsonStr, Class<T> clazz, Map<String, Class> classMap) {
        JSONArray json = null;
        json = JSONArray.fromObject((Object)jsonStr);
        return JSONArray.toList((JSONArray)json, clazz, classMap);
    }

    public static <T> T[] stringToObjectArray(String jsonStr, Class<T> clazz, Map<String, Class> classMap) {
        JSONArray json = null;
        json = JSONArray.fromObject((Object)jsonStr);
        return (Object[])JSONArray.toArray((JSONArray)json, clazz, classMap);
    }

    public static <T> T[] stringToObjectArray(String jsonStr, Class<T> clazz) {
        JSONArray json = null;
        json = JSONArray.fromObject((Object)jsonStr);
        return (Object[])JSONArray.toArray((JSONArray)json, clazz);
    }

    public static String objectToString(Object o, String ... excludes) {
        JSONObject json = null;
        JsonConfig config = JSONUtil.config.copy();
        config.setExcludes(excludes);
        json = JSONObject.fromObject((Object)o, (JsonConfig)config);
        return json.toString();
    }

    public static String arrayToString(Object o, String ... excludes) {
        JSONArray json = null;
        JsonConfig config = JSONUtil.config.copy();
        config.setExcludes(excludes);
        json = JSONArray.fromObject((Object)o, (JsonConfig)config);
        return json.toString();
    }

    public static String xmlToJsonString(String xml) {
        XMLSerializer xmlSerializer = new XMLSerializer();
        return xmlSerializer.read(xml).toString();
    }

    public static String objectToStringJs(Object o, String ... excludes) {
        JSONObject json = null;
        JsonConfig config = JSONUtil.config.copy();
        config.setExcludes(excludes);
        config.registerJsonValueProcessor(Date.class, (JsonValueProcessor)new DateTimeJsonValueProcesser());
        json = JSONObject.fromObject((Object)o, (JsonConfig)config);
        return json.toString();
    }

    public static String arrayToStringJs(Object o, String ... excludes) {
        JSONArray json = null;
        JsonConfig config = JSONUtil.config.copy();
        config.setExcludes(excludes);
        config.registerJsonValueProcessor(Date.class, (JsonValueProcessor)new DateTimeJsonValueProcesser());
        json = JSONArray.fromObject((Object)o, (JsonConfig)config);
        return json.toString();
    }

    static {
        config.setJsonPropertyFilter(new PropertyFilter(){

            public boolean apply(Object object, String fieldName, Object fieldValue) {
                if (fieldValue == null || "".equals(fieldValue)) {
                    return true;
                }
                if (fieldValue instanceof Collection && ((Collection)fieldValue).size() == 0) {
                    return true;
                }
                return fieldValue.getClass().isArray() && Array.getLength(fieldValue) == 0;
            }
        });
        config.setCycleDetectionStrategy((CycleDetectionStrategy)new CycleDetectionStrategyImpl());
        config.registerDefaultValueProcessor(Boolean.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor());
        config.registerDefaultValueProcessor(Integer.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor());
        config.registerDefaultValueProcessor(Double.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor());
        config.registerDefaultValueProcessor(Float.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor());
        config.registerDefaultValueProcessor(Short.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor());
        config.registerDefaultValueProcessor(Long.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor());
        config.registerDefaultValueProcessor(BigInteger.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor());
        config.registerDefaultValueProcessor(BigDecimal.class, (DefaultValueProcessor)new DefaultDefaultValueProcessor());
    }
}

