/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.view.excel2007;

import com.runqian.base4.resources.EngineMessage;
import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.util.Sentence;
import com.runqian.report4.control.ControlUtils;
import com.runqian.report4.model.NormalCell;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.IReport;
import java.awt.Color;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Excel2007Cell {
    private IReport rd;
    private int row;
    private short col;
    private XSSFWorkbook wb;
    private ArrayList<XSSFCellStyle> styles;
    private ArrayList<XSSFFont> fonts;
    private Hashtable<String, String> formats;
    public static int COLOR_TRANSPARENT = 0xFFFFFF;

    public Excel2007Cell(IReport rd, int row, short col, XSSFWorkbook wb, ArrayList<XSSFFont> fonts, ArrayList<XSSFCellStyle> styles, Hashtable<String, String> formats) {
        this.rd = rd;
        this.row = row;
        this.col = col;
        this.wb = wb;
        this.fonts = fonts;
        this.styles = styles;
        this.formats = formats;
    }

    XSSFCellStyle getStyle(boolean hasExp) {
        XSSFCellStyle style;
        boolean wordwrap;
        INormalCell cell;
        short format;
        XSSFColor backColor;
        XSSFColor borderBottomColor;
        XSSFColor borderTopColor;
        XSSFColor borderRightColor;
        XSSFColor borderLeftColor;
        short borderBottom;
        short borderTop;
        short borderRight;
        short borderLeft;
        short valign;
        short align;
        block27: {
            byte alignh;
            align = 2;
            valign = 1;
            borderLeft = 0;
            borderRight = 0;
            borderTop = 0;
            borderBottom = 0;
            borderLeftColor = new XSSFColor();
            borderRightColor = new XSSFColor();
            borderTopColor = new XSSFColor();
            borderBottomColor = new XSSFColor();
            backColor = new XSSFColor();
            format = 49;
            cell = this.rd.getCell(this.row, this.col);
            if (cell == null) {
                cell = new NormalCell();
            }
            if ((alignh = cell.getHAlign()) == -48) {
                align = 1;
            } else if (alignh == -46) {
                align = 3;
            }
            byte alignv = cell.getVAlign();
            if (alignv == -32) {
                valign = 0;
            } else if (alignv == -30) {
                valign = 2;
            }
            wordwrap = cell.getTextWrap();
            borderLeft = this.getBorderStyle(cell.getLBStyle(), cell.getLBWidth());
            borderLeftColor = this.getColor(cell.getLBColor());
            borderTop = this.getBorderStyle(cell.getTBStyle(), cell.getTBWidth());
            borderTopColor = this.getColor(cell.getTBColor());
            borderRight = this.getBorderStyle(cell.getRBStyle(), cell.getRBWidth());
            borderRightColor = this.getColor(cell.getRBColor());
            borderBottom = this.getBorderStyle(cell.getBBStyle(), cell.getBBWidth());
            borderBottomColor = this.getColor(cell.getBBColor());
            backColor = cell.getBackColor() == COLOR_TRANSPARENT ? this.getColor(cell.getBackColor()) : this.getColor(cell.getBackColor());
            String s = this.getText();
            s = s.trim();
            if (cell.getValue() instanceof Date && ((Date)cell.getValue()).getTime() >= 0L) {
                String fmt = cell.getFormat();
                XSSFDataFormat dFormat = this.wb.createDataFormat();
                format = fmt != null && fmt.trim().length() > 0 ? (short)dFormat.getFormat(this.parseFormat(fmt)) : (cell.getValue() instanceof Timestamp ? (short)dFormat.getFormat("yyyy-mm-dd hh:mm:ss.000") : (cell.getValue() instanceof Time ? (short)dFormat.getFormat("hh:mm:ss") : (short)dFormat.getFormat("yyyy-mm-dd")));
            } else {
                if (cell.getValue() instanceof Number && (!s.startsWith("0") || s.indexOf(".") >= 0 || s.trim().length() <= 1)) {
                    String fmt;
                    try {
                        double d = Double.parseDouble(s);
                        if (s.toLowerCase().indexOf("e") >= 0) {
                            throw new Exception();
                        }
                        if (!(d <= 9.9999999999999E13)) break block27;
                        fmt = cell.getFormat();
                        if (fmt != null && fmt.trim().length() > 0) {
                            format = this.getFormat(fmt.trim());
                            break block27;
                        }
                        if (d == 0.0) {
                            fmt = "0";
                            format = this.getFormat(fmt);
                            break block27;
                        }
                        fmt = "#";
                        int pos = s.indexOf(".");
                        if (pos > 0) {
                            fmt = String.valueOf(fmt) + ".";
                            s = s.trim();
                            int m = pos;
                            while (m < s.length() - 1) {
                                fmt = String.valueOf(fmt) + "0";
                                ++m;
                            }
                        }
                        format = this.getFormat(fmt);
                    }
                    catch (Throwable e) {
                        String s1 = this.getValue();
                        s1 = s1.trim();
                        if (!s1.equals(s)) {
                            try {
                                fmt = cell.getFormat();
                                if (fmt != null && fmt.trim().length() > 0) {
                                    format = this.getFormat(fmt.trim());
                                }
                                break block27;
                            }
                            catch (Throwable e1) {
                                if (s.length() == 0 || s.length() > 80) {
                                    format = 0;
                                }
                                break block27;
                            }
                        }
                        if (s.length() == 0 || s.length() > 80) {
                            format = 0;
                        }
                        break block27;
                    }
                }
                if (s.length() == 0 || s.length() > 80) {
                    format = 0;
                }
            }
        }
        XSSFFont font = this.getFont(cell);
        int i = 0;
        while (i < this.styles.size()) {
            style = this.styles.get(i);
            if (style.getAlignment() == align && style.getVerticalAlignment() == valign && style.getWrapText() == wordwrap && style.getBorderLeft() == borderLeft && style.getBorderRight() == borderRight && style.getBorderTop() == borderTop && style.getBorderBottom() == borderBottom && borderLeftColor.equals((Object)style.getLeftBorderXSSFColor()) && borderRightColor.equals((Object)style.getRightBorderXSSFColor()) && borderTopColor.equals((Object)style.getTopBorderXSSFColor()) && borderBottomColor.equals((Object)style.getBottomBorderXSSFColor()) && backColor.equals((Object)style.getFillForegroundXSSFColor()) && style.getDataFormat() == format && style.getFontIndex() == font.getIndex()) {
                return style;
            }
            ++i;
        }
        style = this.wb.createCellStyle();
        style.setAlignment(align);
        style.setVerticalAlignment(valign);
        style.setWrapText(wordwrap);
        style.setBorderLeft(borderLeft);
        style.setBorderRight(borderRight);
        style.setBorderTop(borderTop);
        style.setBorderBottom(borderBottom);
        style.setLeftBorderColor(borderLeftColor);
        style.setRightBorderColor(borderRightColor);
        style.setTopBorderColor(borderTopColor);
        style.setBottomBorderColor(borderBottomColor);
        style.setFillForegroundColor(backColor);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setDataFormat(format);
        if (cell.getAdjustSizeMode() != 51 && cell.getAdjustSizeMode() != 48) {
            wordwrap = wordwrap;
        }
        style.setFont((Font)font);
        this.styles.add(style);
        return style;
    }

    String getText() {
        return ControlUtils.getCellText((IReport)this.rd, (int)this.row, (short)this.col, (boolean)false);
    }

    String getValue() {
        INormalCell cell = this.rd.getCell(this.row, this.col);
        if (cell == null) {
            return "";
        }
        Object obj = cell.getValue();
        if (obj == null) {
            return "";
        }
        String text = "";
        if (obj instanceof byte[]) {
            try {
                text = new String((byte[])obj, "GBK");
            }
            catch (Exception exception) {}
        } else {
            text = obj.toString();
        }
        return text;
    }

    private short getBorderStyle(byte borderStyle, float width) {
        if (borderStyle == 80) {
            return 0;
        }
        if (borderStyle == 82) {
            if ((double)width > 1.0) {
                return 8;
            }
            return 3;
        }
        if (borderStyle == 81) {
            if ((double)width > 1.0) {
                return 10;
            }
            return 9;
        }
        if (borderStyle == 84) {
            return 6;
        }
        if (borderStyle == 83) {
            if ((double)width < 0.75) {
                return 1;
            }
            if ((double)width <= 1.0) {
                return 1;
            }
            if ((double)width <= 1.5) {
                return 2;
            }
            if ((double)width <= 2.0) {
                return 5;
            }
            return 5;
        }
        if (borderStyle == 85) {
            return 7;
        }
        return 1;
    }

    private XSSFColor getColor(int color) {
        XSSFColor xc = new XSSFColor(new Color(color));
        return xc;
    }

    private XSSFFont getFont(INormalCell cell) {
        XSSFFont font;
        String fontName = cell.getFontName();
        short fontSize = cell.getFontSize();
        XSSFColor fontColor = this.getColor(cell.getForeColor());
        short fontBold = cell.isBold() ? (short)700 : 400;
        boolean fontItalic = cell.isItalic();
        byte fontUnderline = cell.isUnderline() ? (byte)1 : 0;
        int i = 0;
        while (i < this.fonts.size()) {
            font = this.fonts.get(i);
            if (font.getFontName().equalsIgnoreCase(fontName) && font.getFontHeightInPoints() == fontSize && fontColor.equals((Object)font.getXSSFColor()) && font.getBoldweight() == fontBold && font.getItalic() == fontItalic && font.getUnderline() == fontUnderline) {
                return font;
            }
            ++i;
        }
        font = this.wb.createFont();
        font.setFontName(fontName);
        font.setFontHeightInPoints(fontSize);
        font.setColor(fontColor);
        font.setBoldweight(fontBold);
        font.setItalic(fontItalic);
        font.setUnderline(fontUnderline);
        this.fonts.add(font);
        return font;
    }

    private short getFormat(String fmt) {
        if (this.formats.containsKey(fmt)) {
            String s = this.formats.get(fmt);
            return Short.parseShort(s);
        }
        short format = this.wb.createDataFormat().getFormat(fmt);
        this.formats.put(fmt, String.valueOf(format));
        return format;
    }

    private String parseFormat(String format) {
        MessageManager mm = EngineMessage.get();
        if (format.indexOf(97) > 0) {
            while (format.indexOf("aa") > 0) {
                format = Sentence.replace((String)format, (int)0, (String)"aa", (String)"a", (int)0);
            }
            format = Sentence.replace((String)format, (int)0, (String)"a", (String)mm.getMessage("Excel.AMPM"), (int)0);
        }
        if (format.indexOf(69) > 0) {
            while (format.indexOf("EE") > 0) {
                format = Sentence.replace((String)format, (int)0, (String)"EE", (String)"E", (int)0);
            }
            format = Sentence.replace((String)format, (int)0, (String)"E", (String)"aaaa", (int)0);
        }
        return format;
    }
}

