/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.view.excel2007;

import com.runqian.base4.tool.Lang;
import com.runqian.base4.util.Sentence;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.view.excel2007.Sheet2007Transfer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Excel2007Importer {
    private XSSFWorkbook wb;
    private XSSFSheet[] sheets;
    private String[] sheetNames;
    private List fileNames;
    private XSSFFont[] fonts;
    private String excelFile = "";
    private boolean formulaAsExp = false;
    private boolean richText = false;

    public Excel2007Importer() {
    }

    public void setExcelFile(String excelFile) throws Exception {
        this.excelFile = excelFile;
        FileInputStream fis = new FileInputStream(excelFile);
        this.init(fis);
        fis.close();
    }

    public void setExcelStream(InputStream is) throws Exception {
        this.init(is);
    }

    public String[] getSheetNames() {
        return this.sheetNames;
    }

    public Excel2007Importer(String excelFile) throws Exception {
        this.excelFile = excelFile;
        FileInputStream fis = new FileInputStream(excelFile);
        this.init(fis);
        fis.close();
    }

    public Excel2007Importer(byte[] buf) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        this.init(is);
        ((InputStream)is).close();
    }

    public Excel2007Importer(InputStream fis) throws Exception {
        this.init(fis);
    }

    private void init(InputStream fis) throws Exception {
        this.wb = new XSSFWorkbook(fis);
        ArrayList<XSSFSheet> al = new ArrayList<XSSFSheet>();
        ArrayList<String> al_names = new ArrayList<String>();
        int i = 0;
        while (i < this.wb.getNumberOfSheets()) {
            XSSFSheet sheet = this.wb.getSheetAt(i);
            if (sheet.getLastRowNum() >= 0) {
                al.add(sheet);
                al_names.add(this.wb.getSheetName(i));
            }
            ++i;
        }
        if (al.size() == 0) {
            throw new Exception(String.valueOf(Lang.getText((String)"excelimporter.file")) + this.excelFile + Lang.getText((String)"excelimporter.nocontent"));
        }
        this.sheets = new XSSFSheet[al.size()];
        this.sheetNames = new String[al.size()];
        this.fileNames = new ArrayList(al.size());
        i = 0;
        while (i < this.sheets.length) {
            this.sheets[i] = (XSSFSheet)al.get(i);
            this.sheetNames[i] = (String)al_names.get(i);
            ++i;
        }
        short fontCount = this.wb.getNumberOfFonts();
        this.fonts = new XSSFFont[fontCount];
        int i2 = 0;
        while (i2 < this.fonts.length) {
            this.fonts[i2] = this.wb.getFontAt((short)i2);
            ++i2;
        }
    }

    public void setFormulaAsExp(Boolean b) {
        if (b == null) {
            return;
        }
        this.formulaAsExp = b;
    }

    public void setExportRichText(Boolean b) {
        if (b == null) {
            return;
        }
        this.richText = b;
    }

    public IReport getReport(int sheetIndex) {
        Sheet2007Transfer st = new Sheet2007Transfer(this.wb, this.sheets[sheetIndex], this.fonts);
        st.setFormulaAsExp(this.formulaAsExp);
        st.setExportRichText(this.richText);
        return st.toReport();
    }

    public int getReportCount() {
        return this.sheets.length;
    }

    public String[] saveTo(String raqDir) throws Exception {
        String prefix;
        int pos;
        if (!(raqDir = Sentence.replace((String)raqDir, (String)"\\", (String)"/", (int)1)).endsWith("/")) {
            raqDir = String.valueOf(raqDir) + "/";
        }
        if ((pos = (prefix = this.excelFile).lastIndexOf(".")) >= 0) {
            prefix = prefix.substring(0, pos);
        }
        if ((pos = (prefix = Sentence.replace((String)prefix, (String)"\\", (String)"/", (int)1)).lastIndexOf("/")) >= 0) {
            prefix = prefix.substring(pos + 1);
        }
        if (this.sheets.length == 1) {
            String raqFile = String.valueOf(raqDir) + prefix + ".raq";
            return new String[]{this.save(this.sheets[0], raqFile)};
        }
        int i = 0;
        while (i < this.sheets.length) {
            XSSFSheet sheet = this.sheets[i];
            String raqFile = String.valueOf(raqDir) + prefix + "_" + this.sheetNames[i] + ".raq";
            String name = this.save(sheet, raqFile);
            if (name != null) {
                this.fileNames.add(name);
            }
            ++i;
        }
        String[] ss = new String[this.fileNames.size()];
        int i2 = 0;
        while (i2 < this.fileNames.size()) {
            ss[i2] = (String)this.fileNames.get(i2);
            ++i2;
        }
        return ss;
    }

    private String save(XSSFSheet sheet, String raqFile) throws Exception {
        File file = new File(raqFile);
        if (file.exists() && JOptionPane.showConfirmDialog(null, String.valueOf(Lang.getText((String)"excelimporter.file")) + raqFile + Lang.getText((String)"excelimporter.querymsg")) == 1) {
            int i = 1;
            while (i < 100) {
                String tmp = raqFile.substring(0, raqFile.lastIndexOf("."));
                if (!new File(tmp = String.valueOf(tmp) + "_" + i + ".raq").exists()) {
                    raqFile = tmp;
                    break;
                }
                ++i;
            }
        }
        Sheet2007Transfer st = new Sheet2007Transfer(this.wb, sheet, this.fonts);
        st.setFormulaAsExp(this.formulaAsExp);
        st.setExportRichText(this.richText);
        if (st.toReport() == null) {
            return null;
        }
        st.save(raqFile);
        return raqFile;
    }

    public boolean hasFormula() {
        int k = 0;
        while (k < this.sheets.length) {
            XSSFSheet sheet = this.sheets[k];
            int rows = sheet.getLastRowNum() + 1;
            int cols = Sheet2007Transfer.getLastCol(sheet);
            if (rows != 1 || cols != 0) {
                int i = 0;
                while (i < rows) {
                    XSSFRow r = sheet.getRow(i);
                    if (r != null) {
                        int j = 0;
                        while (j < cols) {
                            XSSFCell cell = r.getCell(j);
                            if (cell != null && cell.getCellType() == 2) {
                                return true;
                            }
                            j = (short)(j + 1);
                        }
                    }
                    ++i;
                }
            }
            ++k;
        }
        return false;
    }
}

