/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.view.excel2007;

import com.runqian.base4.resources.DataSetMessage;
import com.runqian.base4.resources.EngineMessage;
import com.runqian.base4.resources.MessageManager;
import com.runqian.base4.resources.SplitPageMessage;
import com.runqian.base4.util.ImageUtils;
import com.runqian.base4.util.Logger;
import com.runqian.base4.util.PwdUtils;
import com.runqian.base4.util.ReportError;
import com.runqian.report4.control.LeanLine;
import com.runqian.report4.model.NormalCell;
import com.runqian.report4.model.engine.ExtCell;
import com.runqian.report4.model.engine.ExtCellSet;
import com.runqian.report4.model.engine.ExtNormalCell;
import com.runqian.report4.model.engine2.ExtNCell;
import com.runqian.report4.model.engine2.ExtRow;
import com.runqian.report4.model.engine2.RowReport;
import com.runqian.report4.usermodel.Area;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.Engine;
import com.runqian.report4.usermodel.ExportConfig;
import com.runqian.report4.usermodel.IByteMap;
import com.runqian.report4.usermodel.IColCell;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.IRowCell;
import com.runqian.report4.usermodel.PageBuilder;
import com.runqian.report4.usermodel.PagerInfo;
import com.runqian.report4.usermodel.PrintSetup;
import com.runqian.report4.usermodel.dmgraph.DMImageValue;
import com.runqian.report4.usermodel.graph.ImageValue;
import com.runqian.report4.util.ImgUtils;
import com.runqian.report4.util.ReportParser;
import com.runqian.report4.util.ReportUtils;
import com.runqian.report4.util.RichTextElement;
import com.runqian.report4.util.RichTextLine;
import com.runqian.report4.util.RichTextUtil;
import com.runqian.report4.view.LicenseException;
import com.runqian.report4.view.excel2007.Excel2007Cell;
import com.view.pdf.PdfCell;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Excel2007Report {
    private static int bindCodeCount = 0;
    private XSSFWorkbook wb;
    private ArrayList<IReport> pages = new ArrayList();
    private ArrayList<String> labels = new ArrayList();
    private ArrayList<Format> formats = new ArrayList();
    private ArrayList<PagerInfo> settings = new ArrayList();
    private String passwd;
    private boolean hiddenRow = true;
    private boolean hiddenCol = true;
    private boolean fullPaged = false;
    private int dispRatio = 100;
    private PagerInfo pi = null;
    public final int MAX_ROW_NUM = 65535;
    private boolean hasExp = false;
    private Locale locale = Locale.CHINESE;
    public static final float TRANS_CONSTANT_ROW = 19.62f;
    public static final float TRANS_CONSTANT_COL = 42.74f;
    private byte unit = 0;

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public Excel2007Report() {
        this.wb = new XSSFWorkbook();
    }

    public void resetExport() {
        this.hasExp = false;
        this.hiddenRow = true;
        this.hiddenCol = true;
        this.passwd = null;
    }

    public int getDispRatio() {
        return this.dispRatio;
    }

    public void setDispRatio(int ratio) {
        this.dispRatio = ratio;
    }

    public boolean getFomulaExported() {
        return this.hasExp;
    }

    public void setFomulaExported(Boolean b) {
        this.hasExp = b;
    }

    public String getFilePassword() {
        return this.passwd;
    }

    public void setFilePassword(String password) {
        if (this.pages.size() < 1) {
            this.passwd = password;
        }
    }

    public void export(IReport report) {
        int size = this.pages.size();
        MessageManager mm = DataSetMessage.get((Locale)this.locale);
        this.export(mm.getMessage("info.page", (Object)Integer.toString(size + 1)), report);
    }

    public void export(PageBuilder pb) {
        int size = this.pages.size();
        MessageManager mm = DataSetMessage.get((Locale)this.locale);
        this.export(mm.getMessage("info.table", (Object)Integer.toString(size + 1)), pb);
    }

    public void export(String sheetName, IReport report) {
        if (this.hasExp) {
            if (report instanceof ExtCellSet) {
                if (((ExtCellSet)report).isLoaded()) {
                    MessageManager mm = SplitPageMessage.get((Locale)this.locale);
                    throw new ReportError(mm.getMessage("ExcelReport.loadRat"));
                }
            } else if (report instanceof RowReport && ((RowReport)report).isLoaded()) {
                MessageManager mm = SplitPageMessage.get((Locale)this.locale);
                throw new ReportError(mm.getMessage("ExcelReport.loadRat"));
            }
        }
        int size = this.pages.size();
        ExportConfig ec = report.getExportConfig();
        if (ec != null) {
            if (size == 0) {
                this.passwd = PwdUtils.decrypt((String)ec.getExcelFilePassword());
            }
            this.hiddenCol = !ec.getExcelHiddenColExported();
            this.hiddenRow = !ec.getExcelHiddenRowExported();
            this.fullPaged = ec.getFullyPaged();
        } else {
            this.hiddenCol = false;
            this.hiddenRow = false;
            this.fullPaged = false;
        }
        PrintSetup pb = report.getPrintSetup();
        if (pb == null) {
            pb = new PrintSetup();
        }
        PagerInfo pif = new PagerInfo(pb);
        Format format = new Format(this.hiddenRow, this.hiddenCol, this.hasExp, this.fullPaged);
        this.pages.add(report);
        if (sheetName != null && sheetName.length() > 31) {
            this.labels.add(String.valueOf(sheetName.substring(0, 28)) + "...");
            Logger.warn((Object)"Excel Sheet Name's length is out of range(32)!");
        } else {
            this.labels.add(sheetName);
        }
        this.formats.add(format);
        this.settings.add(pif);
    }

    public void export(String sheetNamePrefix, PageBuilder pb) {
        int count = pb.getPageCount();
        ExportConfig ec = null;
        try {
            ec = pb.getPage(0).getExportConfig();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ec != null) {
            this.passwd = PwdUtils.decrypt((String)ec.getExcelFilePassword());
            this.hiddenCol = !ec.getExcelHiddenColExported();
            this.hiddenRow = !ec.getExcelHiddenRowExported();
            this.fullPaged = false;
        } else {
            this.hiddenCol = false;
            this.hiddenRow = false;
            this.fullPaged = false;
        }
        Format format = new Format(this.hiddenRow, this.hiddenCol, false, this.fullPaged);
        PagerInfo pif = pb.getPagerInfo();
        if (pif == null) {
            pif = new PagerInfo(new PrintSetup());
        }
        String number = "";
        int prefixLength = sheetNamePrefix == null ? 0 : sheetNamePrefix.length();
        int i = 1;
        while (i <= count) {
            try {
                this.pages.add(pb.getPage(i));
                if (count > 1) {
                    number = "" + i;
                    if (prefixLength + number.length() > 31) {
                        this.labels.add(String.valueOf(sheetNamePrefix.substring(0, 28 - number.length())) + "..." + number);
                        Logger.warn((Object)"Excel Sheet Name's length is out of range(32)!");
                    } else {
                        this.labels.add(String.valueOf(sheetNamePrefix) + i);
                    }
                } else if (prefixLength > 32) {
                    this.labels.add(String.valueOf(sheetNamePrefix.substring(0, 28)) + "...");
                    Logger.warn((Object)"Excel Sheet Name's length is out of range(32)!");
                } else {
                    this.labels.add(sheetNamePrefix);
                }
                this.formats.add(format);
                this.settings.add(pif);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void saveTo(OutputStream os) {
        ExtCellSet lc = ExtCellSet.get();
        if (lc == null || !lc.getExportEnabled() || !lc.checkExpiration()) {
            MessageManager mm = DataSetMessage.get((Locale)this.locale);
            throw new ReportError(mm.getMessage("error.licenceError"));
        }
        String forceExport = System.getProperty("forceExport");
        forceExport = "true";
        if (!(forceExport != null && forceExport.equalsIgnoreCase("true") || lc.getType() != 0 || ExtCellSet.checkDog())) {
            MessageManager mm = DataSetMessage.get((Locale)this.locale);
            throw new ReportError(mm.getMessage("error.noDog"));
        }
        try {
            this.createWorkbook(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ReportError(e.getMessage());
        }
        if (this.labels != null && this.labels.size() > 0) {
            int i = 0;
            int iCount = this.labels.size();
            while (i < iCount) {
                String sheetName = this.labels.get(i);
                this.wb.setSheetName(i, sheetName);
                ++i;
            }
        }
        try {
            this.wb.write(os);
        }
        catch (Exception e) {
            throw new ReportError(e.getMessage());
        }
    }

    public XSSFWorkbook createWorkbook() {
        ExtCellSet lc = ExtCellSet.get();
        if (lc == null || !lc.getExportEnabled() || !lc.checkExpiration()) {
            MessageManager mm = DataSetMessage.get((Locale)this.locale);
            throw new ReportError(mm.getMessage("error.licenceError"));
        }
        String forceExport = System.getProperty("forceExport");
        if (!(forceExport != null && forceExport.equalsIgnoreCase("true") || lc.getType() != 0 || ExtCellSet.checkDog())) {
            MessageManager mm = DataSetMessage.get((Locale)this.locale);
            throw new ReportError(mm.getMessage("error.noDog"));
        }
        try {
            this.createWorkbook(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ReportError(e.getMessage());
        }
        if (this.labels != null && this.labels.size() > 0) {
            int i = 0;
            int iCount = this.labels.size();
            while (i < iCount) {
                String sheetName = this.labels.get(i);
                this.wb.setSheetName(i, sheetName);
                ++i;
            }
        }
        return this.wb;
    }

    public void saveTo(String fileName) {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(fileName);
                this.saveTo(fos);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ReportError(e.getMessage());
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new ReportError(e.getMessage());
                }
            }
        }
    }

    private int[] createAPage(XSSFSheet sheet, IReport cellset, ArrayList<XSSFFont> fonts, ArrayList<XSSFCellStyle> styles, int firstRow, short firstCol, Hashtable<String, String> formats) {
        short paper;
        Excel2007Cell cell = null;
        ExportConfig ec = cellset.getExportConfig();
        this.unit = cellset.getUnit();
        ReportParser parser = new ReportParser(cellset);
        int rowCount = parser.getRowCount();
        short colCount = parser.getColCount() + 1;
        int startRow = 1;
        int endRow = rowCount;
        Area pageHeader = parser.getPageHeader();
        Area pageFooter = parser.getPageFooter();
        if (pageHeader != null) {
            startRow = pageHeader.getEndRow() + 1;
        }
        if (pageFooter != null) {
            endRow = pageFooter.getBeginRow() - 1;
        }
        XSSFDrawing patriarch = null;
        short currCol = firstCol;
        short col = 1;
        while (col < colCount) {
            block171: {
                short colWidth;
                block170: {
                    float colw = this.getColWidth(cellset, col);
                    colWidth = (short)Math.ceil(colw * 42.74f);
                    if (parser.isColVisible(col)) break block170;
                    if (!this.hiddenCol && !this.hasExp) break block171;
                    sheet.setColumnHidden((int)currCol, true);
                }
                short s = currCol;
                currCol = (short)(s + 1);
                sheet.setColumnWidth((int)s, (int)colWidth);
            }
            col = (short)(col + 1);
        }
        int currRow = firstRow;
        Context ctx = new Context();
        int row = startRow;
        while (row <= endRow) {
            block173: {
                XSSFRow hssfRow;
                short rowHeight;
                block172: {
                    float rowh = this.getRowHeight(cellset, row);
                    rowHeight = (short)Math.ceil(rowh * 19.62f);
                    hssfRow = null;
                    if (parser.isRowVisible(row)) break block172;
                    if (!this.hiddenRow && !this.hasExp) break block173;
                    hssfRow = sheet.createRow(currRow);
                    hssfRow.setZeroHeight(true);
                }
                if (hssfRow == null) {
                    hssfRow = sheet.createRow(currRow);
                }
                hssfRow.setHeight(rowHeight);
                currCol = firstCol;
                short col2 = 1;
                while (col2 < colCount) {
                    block174: {
                        block169: {
                            boolean isLeanLine;
                            byte dataType;
                            INormalCell ncell;
                            block179: {
                                XSSFCell hssfCell;
                                block178: {
                                    block177: {
                                        String hyperLink;
                                        block175: {
                                            block176: {
                                                if (!parser.isColVisible(col2) && !this.hiddenCol && !this.hasExp) break block174;
                                                cell = new Excel2007Cell(cellset, row, col2, this.wb, fonts, styles, formats);
                                                hssfCell = hssfRow.createCell((int)currCol);
                                                XSSFCellStyle style = cell.getStyle(this.hasExp);
                                                hssfCell.setCellStyle((CellStyle)style);
                                                if (!parser.isMerged(row, col2)) break block175;
                                                if (this.isMergedFirstCell(parser, row, col2, this.hiddenRow, this.hiddenCol)) break block176;
                                                currCol = (short)(currCol + 1);
                                                break block174;
                                            }
                                            int colSpan = parser.getColSpan(row, col2, this.hiddenCol);
                                            int rowSpan = parser.getRowSpan(row, col2, this.hiddenRow);
                                            if (colSpan > 1 || rowSpan > 1) {
                                                sheet.addMergedRegion(new CellRangeAddress(currRow, currRow + rowSpan - 1, (int)currCol, (int)((short)(currCol + colSpan - 1))));
                                            }
                                        }
                                        if ((ncell = cellset.getCell(row, col2)) == null || !ncell.isVisible() && !this.hasExp) break block169;
                                        String tips = ncell.getTip();
                                        if (tips != null && tips.trim().length() > 0) {
                                            if (patriarch == null) {
                                                patriarch = sheet.createDrawingPatriarch();
                                            }
                                            XSSFComment comment1 = null;
                                            comment1 = patriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 1023, 255, (int)colCount, rowCount + 1, (int)((short)(colCount + 1)), rowCount + 2));
                                            comment1.setString((RichTextString)new XSSFRichTextString(tips));
                                            comment1.setAuthor("report4");
                                            hssfCell.setCellComment((Comment)comment1);
                                        }
                                        if ((hyperLink = ncell.getHyperlink()) != null && hyperLink.trim().length() > 0 && (ec == null || ec.isExportURL(hyperLink))) {
                                            XSSFHyperlink hhlink = null;
                                            XSSFCreationHelper helper = this.wb.getCreationHelper();
                                            if (helper != null) {
                                                hhlink = helper.createHyperlink(1);
                                                hhlink.setAddress(hyperLink);
                                            }
                                            if (hhlink != null) {
                                                hssfCell.setHyperlink((Hyperlink)hhlink);
                                            }
                                        }
                                        dataType = ncell.getCellType();
                                        byte leanStyle = ncell.getDiagonalStyle();
                                        isLeanLine = leanStyle != 80;
                                        String cellExp = null;
                                        if (this.hasExp) {
                                            if (ncell instanceof ExtNormalCell) {
                                                ((ExtCellSet)cellset).setCurrent((ExtCell)((ExtNormalCell)ncell));
                                                cellExp = ((ExtNormalCell)ncell).calcExcelExp(ctx);
                                            } else if (ncell instanceof ExtNCell) {
                                                ExtRow extRow = ((ExtNCell)ncell).getRow();
                                                ((RowReport)cellset).setCurrent(extRow, ((ExtNCell)ncell).getSource());
                                                cellExp = extRow.calcExcelExp(ctx, col2);
                                            }
                                        }
                                        if (cellExp == null) break block177;
                                        hssfCell.setCellType(2);
                                        hssfCell.setCellFormula(cellExp);
                                        break block169;
                                    }
                                    if (dataType != -64 && dataType != -59 || isLeanLine) break block178;
                                    String s = null;
                                    IByteMap expMap = ncell.getExpMap();
                                    s = ncell instanceof NormalCell && expMap != null && expMap.containsKey((byte)40) ? (String)expMap.get((byte)40) : cell.getText();
                                    Object v = ncell.getValue();
                                    if (v instanceof Date && ((Date)v).getTime() >= 0L) {
                                        hssfCell.setCellType(0);
                                        hssfCell.setCellValue((Date)v);
                                    } else if (s.trim().startsWith("0") && s.indexOf(".") < 0 && s.trim().length() > 1) {
                                        hssfCell.setCellValue(s);
                                        hssfCell.setCellType(1);
                                    } else if (v instanceof String) {
                                        hssfCell.setCellValue(s);
                                        hssfCell.setCellType(1);
                                        if (s != null) {
                                            s.equals(v);
                                        }
                                    } else {
                                        try {
                                            double d = Double.parseDouble(s);
                                            String strim = s.trim();
                                            char checkChar = strim.charAt(strim.length() - 1);
                                            if (s.toLowerCase().indexOf("e") >= 0) {
                                                throw new Exception();
                                            }
                                            if (d <= 9.9999999999999E13 && checkChar != 'f' && checkChar != 'F' && checkChar != 'd' && checkChar != 'D') {
                                                if (!s.equals(cell.getValue())) {
                                                    throw new Exception();
                                                }
                                                hssfCell.setCellType(0);
                                                hssfCell.setCellValue(d);
                                                break block169;
                                            }
                                            hssfCell.setCellValue(s);
                                        }
                                        catch (Throwable e) {
                                            String s1 = cell.getValue().trim();
                                            if (s1.equals(s)) {
                                                if (s == null || s.length() == 0) {
                                                    hssfCell.setCellType(3);
                                                } else {
                                                    hssfCell.setCellValue(s);
                                                }
                                                break block169;
                                            }
                                            try {
                                                double d = Double.parseDouble(s1);
                                                String fmt = ncell.getFormat();
                                                if (fmt != null && fmt.trim().length() > 0) {
                                                    hssfCell.setCellType(0);
                                                    hssfCell.setCellValue(d);
                                                } else {
                                                    hssfCell.setCellValue(s);
                                                }
                                                break block169;
                                            }
                                            catch (Throwable e1) {
                                                hssfCell.setCellValue(s);
                                            }
                                        }
                                    }
                                    break block169;
                                }
                                if (dataType != -56) break block179;
                                Object v = ncell.getValue();
                                if (!(v instanceof String)) break block174;
                                String text = (String)v;
                                ArrayList rtls = RichTextUtil.getRichTextLineList((IReport)cellset, (INormalCell)ncell, (String)text);
                                ArrayList<int[]> locList = new ArrayList<int[]>();
                                ArrayList<XSSFFont> fontList = new ArrayList<XSSFFont>();
                                String richText = "";
                                int begin = 0;
                                int end = 0;
                                int lCount = rtls == null ? 0 : rtls.size();
                                int li = 0;
                                while (li < lCount) {
                                    RichTextLine rtl = (RichTextLine)rtls.get(li);
                                    int eCount = rtl.count();
                                    int ei = 0;
                                    while (ei < eCount) {
                                        String eText;
                                        RichTextElement rte = rtl.getElement(ei);
                                        if (rte != null && (eText = rte.text) != null && eText.length() >= 1) {
                                            int eLen = eText.length();
                                            XSSFFont font = this.getRichFont(rte.fontName, rte.fontSize, rte.fontColor, rte.isBold, rte.isItalic, rte.isUnderline, rte.scriptType, fonts);
                                            richText = String.valueOf(richText) + eText;
                                            int[] loc = new int[]{begin, end += eLen};
                                            begin += eLen;
                                            locList.add(loc);
                                            fontList.add(font);
                                        }
                                        ++ei;
                                    }
                                    if (li < lCount - 1) {
                                        richText = String.valueOf(richText) + '\n';
                                        ++begin;
                                        ++end;
                                    }
                                    ++li;
                                }
                                if (richText != null && richText.length() > 0) {
                                    XSSFRichTextString rts = new XSSFRichTextString(richText);
                                    int ei = 0;
                                    int eiCount = locList.size();
                                    while (ei < eiCount) {
                                        int[] loc = (int[])locList.get(ei);
                                        XSSFFont font = (XSSFFont)fontList.get(ei);
                                        rts.applyFont(loc[0], loc[1], (Font)font);
                                        ++ei;
                                    }
                                    hssfCell.setCellValue((RichTextString)rts);
                                    hssfCell.setCellType(1);
                                }
                                break block169;
                            }
                            Object obj = null;
                            if (dataType == -60) {
                                Object sub = ncell.getValue();
                                int h = parser.getMergedHeight(row, col2, false);
                                short w = (short)parser.getMergedWidth(row, col2, false);
                                if (sub instanceof IReport) {
                                    obj = this.drawSubReport((IReport)sub, w, h, ncell);
                                }
                            } else if (dataType == -58) {
                                int h = parser.getMergedHeight(row, col2, false);
                                short w = (short)parser.getMergedWidth(row, col2, false);
                                Image img = parser.getHTMLCellImage(row, col2, 1.0f, (int)w, h);
                                obj = null;
                                try {
                                    obj = ImageUtils.writeJPEG((RenderedImage)ImageUtils.toBufferedImage((Image)img));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            if (obj == null) {
                                if (isLeanLine) {
                                    int width = parser.getColWidth(col2);
                                    int height = parser.getRowHeight(row);
                                    if (ncell.isMerged()) {
                                        Area area = ncell.getMergedArea();
                                        int mergeCol = area.getEndCol() - area.getBeginCol() + 1;
                                        int mergeRow = area.getEndRow() - area.getBeginRow() + 1;
                                        int i = 1;
                                        while (i < mergeCol) {
                                            if (parser.isColVisible((short)(col2 + i))) {
                                                width += parser.getColWidth((short)(col2 + i));
                                            }
                                            ++i;
                                        }
                                        i = 1;
                                        while (i < mergeRow) {
                                            if (parser.isRowVisible(row + i)) {
                                                height += parser.getRowHeight(row + i);
                                            }
                                            ++i;
                                        }
                                    }
                                    LeanLine leanline = new LeanLine(parser, row, col2);
                                    try {
                                        obj = leanline.toBytes(width, height);
                                    }
                                    catch (Exception e) {
                                        throw new ReportError(e.getMessage());
                                    }
                                } else {
                                    obj = ncell.getValue();
                                }
                            }
                            if (obj != null && (obj instanceof ImageValue || obj instanceof byte[] || obj instanceof Image || obj instanceof DMImageValue)) {
                                byte[] value = new byte[1];
                                if (obj instanceof ImageValue) {
                                    value = ((ImageValue)obj).getValue();
                                } else if (obj instanceof DMImageValue) {
                                    int cellw = parser.getMergedWidth(row, col2, false);
                                    int cellh = parser.getMergedHeight(row, col2, false);
                                    try {
                                        value = ((DMImageValue)obj).calcImageBytes(null, cellw, cellh);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                } else if (obj instanceof byte[]) {
                                    value = (byte[])obj;
                                } else if (obj instanceof String) {
                                    try {
                                        FileInputStream in = new FileInputStream((String)obj);
                                        in.close();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (value != null) {
                                    int rh;
                                    int miniY;
                                    byte[] getBytes = value;
                                    if (patriarch == null) {
                                        patriarch = sheet.createDrawingPatriarch();
                                    }
                                    short rightCol = (short)(col2 + parser.getColSpan(row, col2, this.hiddenCol) - 2);
                                    int bottomRow = row + parser.getRowSpan(row, col2, this.hiddenRow) - 2;
                                    byte adjust = ncell.getAdjustSizeMode();
                                    XSSFClientAnchor anch = null;
                                    ImageIcon imi = null;
                                    int cw = parser.getColWidth(col2);
                                    int miniX = (int)(1024.0 / (double)cw + 0.5);
                                    if (miniX >= 1024) {
                                        miniX = 1023;
                                    }
                                    if ((miniY = (int)(256.0 / (double)(rh = parser.getRowHeight(row)) + 0.5)) >= 256) {
                                        miniY = 255;
                                    }
                                    if (adjust == 49) {
                                        int br;
                                        int cellw = parser.getMergedWidth(row, col2, false);
                                        int cellh = parser.getMergedHeight(row, col2, false);
                                        imi = new ImageIcon(getBytes);
                                        int imagew = imi.getIconWidth();
                                        int imageh = imi.getIconHeight();
                                        if (cellw > imagew && cellh > imageh) {
                                            int bAdj;
                                            int tAdj;
                                            int tr;
                                            int rAdj;
                                            short rc;
                                            int lAdj;
                                            short lc;
                                            float adjh = (float)(cellw - imagew) / 2.0f;
                                            if (adjh < 0.0f) {
                                                adjh = 0.0f;
                                            }
                                            byte halign = ncell.getHAlign();
                                            float ladj = adjh;
                                            if (halign == -47) {
                                                lc = (short)(col2 - 1);
                                                cw = parser.getColWidth((short)(lc + 1));
                                                while (ladj > 0.0f && lc <= rightCol) {
                                                    if (!this.hiddenCol || parser.isColVisible((short)(lc + 1))) {
                                                        cw = this.getColWidth(parser, (short)(lc + 1));
                                                        if (!(ladj >= (float)cw)) break;
                                                        ladj -= (float)cw;
                                                    }
                                                    lc = (short)(lc + 1);
                                                }
                                                if ((lAdj = (int)((double)ladj * 1024.0 / (double)cw)) < miniX) {
                                                    lAdj = miniX;
                                                }
                                                rc = rightCol;
                                                cw = parser.getColWidth((short)(rc + 1));
                                                while (adjh > 0.0f && rc >= lc) {
                                                    if (!this.hiddenCol || parser.isColVisible((short)(rc + 1))) {
                                                        cw = this.getColWidth(parser, (short)(rc + 1));
                                                        if (!(adjh >= (float)cw)) break;
                                                        adjh -= (float)cw;
                                                    }
                                                    rc = (short)(rc - 1);
                                                }
                                                rAdj = (int)((double)adjh * 1024.0 / (double)cw);
                                            } else if (halign == -48) {
                                                adjh *= 2.0f;
                                                rc = rightCol;
                                                cw = parser.getColWidth((short)(rc + 1));
                                                while (adjh > 0.0f && rc >= col2 - 1) {
                                                    if (!this.hiddenCol || parser.isColVisible((short)(rc + 1))) {
                                                        cw = this.getColWidth(parser, (short)(rc + 1));
                                                        if (!(adjh >= (float)cw)) break;
                                                        adjh -= (float)cw;
                                                    }
                                                    rc = (short)(rc - 1);
                                                }
                                                rAdj = (int)((double)adjh * 1024.0 / (double)cw);
                                                lAdj = miniX;
                                                lc = (short)(col2 - 1);
                                            } else {
                                                ladj *= 2.0f;
                                                lc = (short)(col2 - 1);
                                                cw = parser.getColWidth((short)(lc + 1));
                                                while (ladj > 0.0f && lc <= rightCol) {
                                                    if (!this.hiddenCol || parser.isColVisible((short)(lc + 1))) {
                                                        cw = this.getColWidth(parser, (short)(lc + 1));
                                                        if (!(ladj >= (float)cw)) break;
                                                        ladj -= (float)cw;
                                                    }
                                                    lc = (short)(lc + 1);
                                                }
                                                if ((lAdj = (int)((double)ladj * 1024.0 / (double)cw)) < miniX) {
                                                    lAdj = miniX;
                                                }
                                                rAdj = 0;
                                                rc = rightCol;
                                            }
                                            float adjv = (float)(cellh - imageh) / 2.0f;
                                            if (adjv < 0.0f) {
                                                adjv = 0.0f;
                                            }
                                            byte valign = ncell.getVAlign();
                                            float tadj = adjv;
                                            if (valign == -31) {
                                                tr = row - 1;
                                                rh = parser.getRowHeight(tr + 1);
                                                while (tadj > 0.0f && tr <= bottomRow) {
                                                    if (!this.hiddenRow || parser.isRowVisible(tr + 1)) {
                                                        rh = this.getRowHeight(parser, tr + 1);
                                                        if (!(tadj >= (float)rh)) break;
                                                        tadj -= (float)rh;
                                                    }
                                                    ++tr;
                                                }
                                                if ((tAdj = (int)((double)tadj * 256.0 / (double)rh)) < miniY) {
                                                    tAdj = miniY;
                                                }
                                                br = bottomRow;
                                                rh = parser.getRowHeight(br + 1);
                                                while (adjv > 0.0f && br >= tr) {
                                                    if (!this.hiddenRow || parser.isRowVisible(br + 1)) {
                                                        rh = this.getRowHeight(parser, br + 1);
                                                        if (!(adjv >= (float)rh)) break;
                                                        adjv -= (float)rh;
                                                    }
                                                    --br;
                                                }
                                                bAdj = (int)((double)adjv * 256.0 / (double)rh);
                                            } else if (valign == -32) {
                                                adjv *= 2.0f;
                                                tr = row - 1;
                                                br = bottomRow;
                                                rh = parser.getRowHeight(br + 1);
                                                while (adjv > 0.0f && br >= tr) {
                                                    if (!this.hiddenRow || parser.isRowVisible(br + 1)) {
                                                        rh = this.getRowHeight(parser, br + 1);
                                                        if (!(adjv >= (float)rh)) break;
                                                        adjv -= (float)rh;
                                                    }
                                                    --br;
                                                }
                                                bAdj = (int)((double)adjv * 256.0 / (double)rh);
                                                tAdj = miniY;
                                                tr = row - 1;
                                            } else {
                                                tadj *= 2.0f;
                                                tr = row - 1;
                                                rh = parser.getRowHeight(tr + 1);
                                                while (tadj > 0.0f && tr <= bottomRow) {
                                                    if (!this.hiddenRow || parser.isRowVisible(tr + 1)) {
                                                        rh = this.getRowHeight(parser, tr + 1);
                                                        if (!(tadj >= (float)rh)) break;
                                                        tadj -= (float)rh;
                                                    }
                                                    ++tr;
                                                }
                                                if ((tAdj = (int)((double)tadj * 256.0 / (double)rh)) < miniY) {
                                                    tAdj = miniY;
                                                }
                                                bAdj = 0;
                                                br = bottomRow;
                                            }
                                            lc = (short)(lc + currCol - col2 + 1);
                                            rc = (short)(rc + currCol - col2 + 1);
                                            tr = tr + currRow - row + 1;
                                            br = br + currRow - row + 1;
                                            anch = new XSSFClientAnchor(lAdj, tAdj, 1023 - rAdj, 255 - bAdj, (int)lc, tr, (int)rc, br);
                                        } else if (cellw * imageh >= cellh * imagew) {
                                            int lAdj;
                                            short lc;
                                            float adj = (float)(cellw - cellh * imagew / imageh) / 2.0f;
                                            if (adj < 0.0f) {
                                                adj = 0.0f;
                                            }
                                            byte halign = ncell.getHAlign();
                                            float ladj = adj;
                                            if (halign == -47) {
                                                lc = (short)(col2 - 1);
                                                cw = parser.getColWidth((short)(lc + 1));
                                                while (ladj > 0.0f && lc <= rightCol) {
                                                    if (!this.hiddenCol || parser.isColVisible((short)(lc + 1))) {
                                                        cw = this.getColWidth(parser, (short)(lc + 1));
                                                        if (!(ladj >= (float)cw)) break;
                                                        ladj -= (float)cw;
                                                    }
                                                    lc = (short)(lc + 1);
                                                }
                                                if ((lAdj = (int)((double)ladj * 1024.0 / (double)cw)) < miniX) {
                                                    lAdj = miniX;
                                                }
                                                short rc = rightCol;
                                                cw = parser.getColWidth((short)(rc + 1));
                                                while (adj > 0.0f && rc >= lc) {
                                                    if (!this.hiddenCol || parser.isColVisible((short)(rc + 1))) {
                                                        cw = this.getColWidth(parser, (short)(rc + 1));
                                                        if (!(adj >= (float)cw)) break;
                                                        adj -= (float)cw;
                                                    }
                                                    rc = (short)(rc - 1);
                                                }
                                                int rAdj = (int)((double)adj * 1024.0 / (double)cw);
                                                lc = (short)(lc + currCol - col2 + 1);
                                                rc = (short)(rc + currCol - col2 + 1);
                                                anch = new XSSFClientAnchor(lAdj, miniY, 1023 - rAdj, 255, (int)lc, currRow, (int)rc, bottomRow + currRow - row + 1);
                                            } else if (halign == -48) {
                                                adj *= 2.0f;
                                                short rc = rightCol;
                                                cw = parser.getColWidth((short)(rc + 1));
                                                while (adj > 0.0f && rc >= col2 - 1) {
                                                    if (!this.hiddenCol || parser.isColVisible((short)(rc + 1))) {
                                                        cw = this.getColWidth(parser, (short)(rc + 1));
                                                        if (!(adj >= (float)cw)) break;
                                                        adj -= (float)cw;
                                                    }
                                                    rc = (short)(rc - 1);
                                                }
                                                int rAdj = (int)((double)adj * 1024.0 / (double)cw);
                                                rc = (short)(rc + currCol - col2 + 1);
                                                anch = new XSSFClientAnchor(miniX, miniY, 1023 - rAdj, 255, (int)currCol, currRow, (int)rc, bottomRow + currRow - row + 1);
                                            } else {
                                                ladj *= 2.0f;
                                                lc = (short)(col2 - 1);
                                                cw = parser.getColWidth((short)(lc + 1));
                                                while (ladj > 0.0f && lc <= rightCol) {
                                                    if (!this.hiddenCol || parser.isColVisible((short)(lc + 1))) {
                                                        cw = this.getColWidth(parser, (short)(lc + 1));
                                                        if (!(ladj >= (float)cw)) break;
                                                        ladj -= (float)cw;
                                                    }
                                                    lc = (short)(lc + 1);
                                                }
                                                if ((lAdj = (int)((double)ladj * 1024.0 / (double)cw)) < miniX) {
                                                    lAdj = miniX;
                                                }
                                                lc = (short)(lc + currCol - col2 + 1);
                                                anch = new XSSFClientAnchor(lAdj, miniY, 1023, 255, (int)lc, currRow, (int)((short)(rightCol + currCol - col2 + 1)), bottomRow + currRow - row + 1);
                                            }
                                        } else {
                                            int tAdj;
                                            int tr;
                                            float adj = (float)(cellh - cellw * imageh / imagew) / 2.0f;
                                            if (adj < 0.0f) {
                                                adj = 0.0f;
                                            }
                                            byte valign = ncell.getVAlign();
                                            float tadj = adj;
                                            if (valign == -31) {
                                                tr = row - 1;
                                                rh = parser.getRowHeight(tr + 1);
                                                while (tadj > 0.0f && tr <= bottomRow) {
                                                    if (!this.hiddenRow || parser.isRowVisible(tr + 1)) {
                                                        rh = this.getRowHeight(parser, tr + 1);
                                                        if (!(tadj >= (float)rh)) break;
                                                        tadj -= (float)rh;
                                                    }
                                                    ++tr;
                                                }
                                                if ((tAdj = (int)((double)tadj * 256.0 / (double)rh)) < miniY) {
                                                    tAdj = miniY;
                                                }
                                                br = bottomRow;
                                                rh = parser.getRowHeight(br + 1);
                                                while (adj > 0.0f && br >= tr) {
                                                    if (!this.hiddenRow || parser.isRowVisible(br + 1)) {
                                                        rh = this.getRowHeight(parser, br + 1);
                                                        if (!(adj >= (float)rh)) break;
                                                        adj -= (float)rh;
                                                    }
                                                    --br;
                                                }
                                                int bAdj = (int)((double)adj * 256.0 / (double)rh);
                                                tr = tr + currRow - row + 1;
                                                br = br + currRow - row + 1;
                                                anch = new XSSFClientAnchor(miniX, tAdj, 1023, 255 - bAdj, (int)currCol, tr, (int)((short)(rightCol + currCol - col2 + 1)), br);
                                            } else if (valign == -32) {
                                                adj *= 2.0f;
                                                tr = row - 1;
                                                int br2 = bottomRow;
                                                rh = parser.getRowHeight(br2 + 1);
                                                while (adj > 0.0f && br2 >= tr) {
                                                    if (!this.hiddenRow || parser.isRowVisible(br2 + 1)) {
                                                        rh = this.getRowHeight(parser, br2 + 1);
                                                        if (!(adj >= (float)rh)) break;
                                                        adj -= (float)rh;
                                                    }
                                                    --br2;
                                                }
                                                int bAdj = (int)((double)adj * 256.0 / (double)rh);
                                                tr = tr + currRow - row + 1;
                                                br2 = br2 + currRow - row + 1;
                                                anch = new XSSFClientAnchor(miniX, miniY, 1023, 255 - bAdj, (int)currCol, row - startRow, (int)((short)(rightCol + currCol - col2 + 1)), br2);
                                            } else {
                                                tadj *= 2.0f;
                                                tr = row - 1;
                                                rh = parser.getRowHeight(tr + 1);
                                                while (tadj > 0.0f && tr <= bottomRow) {
                                                    if (!this.hiddenRow || parser.isRowVisible(tr + 1)) {
                                                        rh = this.getRowHeight(parser, tr + 1);
                                                        if (!(tadj >= (float)rh)) break;
                                                        tadj -= (float)rh;
                                                    }
                                                    ++tr;
                                                }
                                                if ((tAdj = (int)((double)tadj * 256.0 / (double)rh)) < miniY) {
                                                    tAdj = miniY;
                                                }
                                                tr = tr + currRow - row + 1;
                                                anch = new XSSFClientAnchor(miniX, tAdj, 1023, 255, (int)currCol, tr, (int)((short)(rightCol + currCol - col2 + 1)), bottomRow + currRow - row + 1);
                                            }
                                        }
                                    } else {
                                        anch = new XSSFClientAnchor(miniX, miniY, 1023, 255, (int)currCol, currRow, (int)((short)(rightCol + currCol - col2 + 1)), bottomRow + currRow - row + 1);
                                    }
                                    byte imageType = ImgUtils.getImageType((byte[])getBytes);
                                    int picIndex = 0;
                                    if (imageType == 1) {
                                        picIndex = this.wb.addPicture(getBytes, 5);
                                    } else if (imageType == 2) {
                                        imi = new ImageIcon(getBytes);
                                        try {
                                            getBytes = ImageUtils.writePNG((RenderedImage)ImageUtils.toBufferedImage((Image)imi.getImage()));
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        picIndex = this.wb.addPicture(getBytes, 6);
                                    } else if (imageType == 3) {
                                        picIndex = isLeanLine ? this.wb.addPicture(getBytes, 6) : (dataType != -61 ? this.wb.addPicture(getBytes, 6) : this.wb.addPicture(getBytes, 6));
                                    }
                                    XSSFCreationHelper helper = this.wb.getCreationHelper();
                                    anch.setCol2(anch.getCol2() + 1);
                                    anch.setRow2(anch.getRow2() + 1);
                                    patriarch.createPicture(anch, picIndex);
                                    anch = helper.createClientAnchor();
                                }
                            }
                        }
                        currCol = (short)(currCol + 1);
                    }
                    col2 = (short)(col2 + 1);
                }
                if (currRow == 0) {
                    XSSFCell endCell = hssfRow.createCell((int)currCol);
                    endCell.setCellValue(" ");
                }
                if (currRow == -1) break;
                ++currRow;
            }
            ++row;
        }
        boolean seekRowHead = false;
        boolean seekColHead = false;
        int freezeRow = 0;
        int freezeCol = 0;
        int frHidden = 0;
        int fcHidden = 0;
        int pageHeadRow = 0;
        int r = 1;
        while (r <= rowCount) {
            IRowCell rc = cellset.getRowCell(r);
            byte rt = rc.getRowType();
            if (rt == -95) {
                seekRowHead = true;
            }
            if (rt == -93) {
                pageHeadRow = r;
            }
            if (rt == -90 || rt == -91 || rt == -94 || rt == -89 || rt == -92) {
                if (!seekRowHead) break;
                freezeRow = r - 1;
                break;
            }
            if (!(this.hiddenRow || this.hasExp || rc.getRowVisible())) {
                ++frHidden;
            }
            ++r;
        }
        if (freezeRow > 0) {
            freezeRow -= pageHeadRow;
        }
        short c = 1;
        while (c < colCount) {
            IColCell cc = cellset.getColCell(c);
            byte ct = cc.getColType();
            if (ct == -80) {
                seekColHead = true;
            }
            if (ct == -79 || ct == -78) {
                if (!seekColHead) break;
                freezeCol = c - 1;
                break;
            }
            if (!(this.hiddenCol || this.hasExp || cc.getColVisible())) {
                ++fcHidden;
            }
            ++c;
        }
        if (seekColHead || seekRowHead) {
            sheet.createFreezePane(freezeCol - fcHidden, freezeRow - frHidden);
        }
        if (this.dispRatio < 0) {
            sheet.setZoom(3, 4);
        } else {
            sheet.setZoom(this.dispRatio, 100);
        }
        XSSFPrintSetup hps = sheet.getPrintSetup();
        hps.setHResolution((short)600);
        short pageSize = paper = this.pi.getPaper();
        if (pageSize == 256) {
            pageSize = 9;
            PrintSetup ps = cellset.getPrintSetup();
            if (ps != null) {
                pageSize = ps.getPaper();
            }
        }
        hps.setPaperSize(pageSize);
        byte orientation = this.pi.getOrientation();
        if (orientation == 0) {
            hps.setLandscape(true);
        } else {
            hps.setLandscape(false);
        }
        this.setMargin(sheet, (short)3, this.pi.getBottomMargin());
        this.setMargin(sheet, (short)0, this.pi.getLeftMargin());
        this.setMargin(sheet, (short)1, this.pi.getRightMargin());
        this.setMargin(sheet, (short)2, this.pi.getTopMargin());
        int[] rowCols = new int[]{currRow - 1, currCol - 1};
        return rowCols;
    }

    private void createWorkbook(boolean b) throws Exception {
        if (this.labels == null) {
            throw new ReportError("No Custom Excel Label!");
        }
        if (this.labels.size() != this.pages.size()) {
            throw new ReportError("Wrong Custom Excel Label Size");
        }
        if (this.passwd != null) {
            this.passwd.trim().length();
        }
        Hashtable<String, String> fmts = new Hashtable<String, String>();
        ArrayList<XSSFFont> fonts = new ArrayList<XSSFFont>();
        ArrayList<XSSFCellStyle> styles = new ArrayList<XSSFCellStyle>();
        int size = this.pages.size();
        int page = 0;
        while (page < size) {
            XSSFSheet sheet = this.wb.createSheet(this.labels.get(page));
            IReport cellset = this.pages.get(page);
            Format format = this.formats.get(page);
            this.hiddenRow = format.hiddenRow;
            this.hiddenCol = format.hiddenCol;
            this.fullPaged = format.fullPaged;
            ExportConfig ec = cellset.getExportConfig();
            if (ec != null) {
                this.hiddenRow = !ec.getExcelHiddenRowExported();
                this.hiddenCol = !ec.getExcelHiddenColExported();
                this.fullPaged = ec.getFullyPaged();
            }
            if (this.hasExp) {
                this.hiddenRow = true;
                this.hiddenCol = true;
            }
            this.pi = this.settings.get(page);
            int[] rowCols = this.createAPage(sheet, cellset, fonts, styles, 0, (short)0, fmts);
            if (this.fullPaged) {
                PageBuilder pb = null;
                try {
                    pb = new PageBuilder(cellset);
                    pb.createPages();
                    IReport[] rps = pb.getAllPages();
                    int xsize = pb.getXPageCount();
                    int ysize = pb.getYPageCount();
                    int cbegin = 0;
                    int rbegin = 0;
                    int cols = 0;
                    int rows = 0;
                    short c = 1;
                    short cCount = cellset.getColCount();
                    while (c <= cCount) {
                        IColCell cc = cellset.getColCell(c);
                        if (cc != null) {
                            byte ct = cc.getColType();
                            if (ct != -80) break;
                            if (this.hiddenCol || this.hasExp) {
                                cbegin = (short)(cbegin + 1);
                            } else if (cc.getColVisible()) {
                                cbegin = (short)(cbegin + 1);
                            }
                        }
                        c = (short)(c + 1);
                    }
                    int r = 1;
                    int rCount = cellset.getRowCount();
                    while (r <= rCount) {
                        IRowCell rc = cellset.getRowCell(r);
                        if (rc != null) {
                            byte rt = rc.getRowType();
                            if (rt == -95 || rt == -96 || rt == -90) {
                                if (this.hiddenRow || this.hasExp) {
                                    ++rbegin;
                                } else if (rc.getRowVisible()) {
                                    ++rbegin;
                                }
                            } else if (rt != -93) break;
                        }
                        ++r;
                    }
                    int pagex = 0;
                    while (pagex < xsize - 1) {
                        IReport xpage = rps[pagex];
                        short c2 = 1;
                        short cCount2 = xpage.getColCount();
                        while (c2 <= cCount2) {
                            byte ct;
                            IColCell cc = xpage.getColCell(c2);
                            if (cc != null && (ct = cc.getColType()) == -79) {
                                if (this.hiddenCol || this.hasExp) {
                                    cols = (short)(cols + 1);
                                } else if (cc.getColVisible()) {
                                    cols = (short)(cols + 1);
                                }
                            }
                            c2 = (short)(c2 + 1);
                        }
                        if (cols > 0) {
                            sheet.setColumnBreak((int)((short)(cols + cbegin - 1)));
                        }
                        ++pagex;
                    }
                    int pagey = 0;
                    while (pagey < ysize - 1) {
                        IReport ypage = rps[pagey * xsize];
                        int r2 = 1;
                        int rCount2 = ypage.getRowCount();
                        while (r2 <= rCount2) {
                            byte rt;
                            IRowCell rc = ypage.getRowCell(r2);
                            if (rc != null && (rt = rc.getRowType()) == -91) {
                                if (this.hiddenRow || this.hasExp) {
                                    ++rows;
                                } else if (rc.getRowVisible()) {
                                    ++rows;
                                }
                            }
                            ++r2;
                        }
                        if (rows > 0) {
                            sheet.setRowBreak(rows + rbegin - 1);
                        }
                        ++pagey;
                    }
                }
                catch (Throwable e) {
                    throw new ReportError("Can't create pages correctly: " + e.getMessage());
                }
            }
            if (this.pi != null && this.pi.getLayout() == 1) {
                sheet.getPrintSetup().setLeftToRight(false);
            } else {
                sheet.getPrintSetup().setLeftToRight(true);
            }
            this.setRepeatRowsCols(this.wb, page, cellset, this.hiddenRow, this.hiddenCol, this.hasExp);
            if (this.setUserUnitName(sheet, rowCols[0] + 1)) {
                rowCols[0] = rowCols[0] + 1;
            }
            this.wb.setPrintArea(page, 0, rowCols[1], 0, rowCols[0]);
            ++page;
        }
    }

    private void setMargin(XSSFSheet sheet, short location, double margin) {
        double margin1 = margin / 25.4;
        sheet.setMargin(location, margin1);
    }

    private void setRepeatRowsCols(XSSFWorkbook wb, int page, IReport rd, boolean hiddenRow, boolean hiddenCol, boolean hasExp) {
        ReportParser csp = new ReportParser(rd);
        PrintSetup ps = rd.getPrintSetup();
        boolean ty_repeat = ps.getTitleYMode() == 0;
        boolean hy_repeat = ps.getRowTableHeaderAndFooterMode() == 0;
        boolean hx_repeat = ps.getColTableHeaderAndFooterMode() == 0;
        int startRow = -1;
        int startCol = -1;
        int endRow = -1;
        int endCol = -1;
        Area left = csp.getLeftHeader();
        if (left != null && hx_repeat) {
            startCol = left.getBeginCol() - 1;
            endCol = left.getEndCol() - 1;
        }
        Area title = csp.getTitleField();
        Area top = csp.getTopHeader();
        if (title != null && top != null) {
            if (ty_repeat) {
                startRow = 0;
                endRow = hy_repeat ? top.getEndRow() - title.getBeginRow() : title.getEndRow() - title.getBeginRow();
            } else if (hy_repeat) {
                startRow = title.getEndRow() - title.getBeginRow() + 1;
                endRow = top.getEndRow() - title.getBeginRow();
            }
        } else if (title == null && top != null && hy_repeat) {
            startRow = 0;
            endRow = top.getEndRow() - top.getBeginRow();
        } else if (title != null && top == null && ty_repeat) {
            startRow = 0;
            endRow = title.getEndRow() - title.getBeginRow();
        }
        if (!hasExp && !hiddenRow) {
            int oldSR = startRow;
            int oldER = endRow;
            int r = 0;
            while (r < oldSR) {
                if (!csp.isRowVisible(r + 1)) {
                    --startRow;
                    --endRow;
                }
                ++r;
            }
            while (r <= oldER) {
                if (!csp.isRowVisible(r + 1)) {
                    --endRow;
                }
                ++r;
            }
        }
        if (!hasExp && !hiddenCol) {
            int oldSC = startCol;
            int oldEC = endCol;
            int c = 0;
            while (c < oldSC) {
                if (!csp.isColVisible((short)(c + 1))) {
                    --startCol;
                    --endCol;
                }
                c = (short)(c + 1);
            }
            while (c <= oldEC) {
                if (!csp.isColVisible((short)(c + 1))) {
                    --endCol;
                }
                c = (short)(c + 1);
            }
        }
        wb.setRepeatingRowsAndColumns(page, startCol, endCol, startRow, endRow);
    }

    private boolean setUserUnitName(XSSFSheet sheet, int row) throws Exception {
        String s;
        block5: {
            ExtCellSet llo = ExtCellSet.get();
            s = Excel2007Report.checkLLObject(llo);
            if (s.length() != 0) break block5;
            return false;
        }
        try {
            XSSFRow r = sheet.createRow(row);
            short cells = sheet.getRow(row - 1).getLastCellNum();
            int c = 0;
            short i = 0;
            while (i < cells) {
                if (sheet.getColumnWidth((int)i) > 100) {
                    c = i;
                    break;
                }
                i = (short)(i + 1);
            }
            XSSFCell cell = r.createCell(c);
            cell.setCellValue(s);
            return true;
        }
        catch (LicenseException le) {
            throw new Exception(le.getMessage());
        }
    }

    private static String checkLLObject(ExtCellSet llo) throws LicenseException, Exception {
        long now;
        ++bindCodeCount;
        long end = llo.getExpirationTime();
        long days = (end - (now = new Date().getTime())) / 86400000L;
        if (days < 7L && days > -1L) {
            return "\u62a5\u8868\u7cfb\u7edf\u6388\u6743\u5c06\u5728" + days + "\u5929\u5185\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u7533\u8bf7\u6388\u6743";
        }
        if (llo.getVersion() == 20 || llo.getVersion() == 21) {
            if (llo.getPrompt() == null) {
                MessageManager mm = EngineMessage.get();
                if (llo.getVersion() == 20) {
                    return mm.getMessage("pdfreport.demo1");
                }
                return mm.getMessage("pdfreport.demo2");
            }
            return llo.getPrompt();
        }
        return "";
    }

    private byte[] drawSubReport(IReport subReport, int w, int h, INormalCell cell) {
        int x1 = 0;
        int y1 = 0;
        ReportParser subParser = new ReportParser(subReport);
        int bkColor = cell.getBackColor();
        byte hAlign = cell.getHAlign();
        byte vAlign = cell.getVAlign();
        int realh = subParser.getReportHeight();
        int realw = subParser.getReportWidth();
        BufferedImage bi = null;
        if (realh < h) {
            if (vAlign == -31) {
                y1 = (h - realh) / 2;
            } else if (vAlign == -30) {
                y1 = h - realh;
            }
            realh = h;
        }
        if (realw < w) {
            if (hAlign == -47) {
                x1 = (w - realw) / 2;
            } else if (hAlign == -46) {
                x1 = w - realw;
            }
            realw = w;
        }
        bi = new BufferedImage(realw, realh, 1);
        Graphics2D g = bi.createGraphics();
        this.drawBackground(g, bkColor, 0, 0, realw, realh);
        try {
            int height;
            int i;
            int totalX;
            short colCount = subParser.getColCount();
            int rowCount = subParser.getRowCount();
            int[] x = new int[colCount + 1];
            x[0] = totalX = x1;
            short i2 = 1;
            while (i2 <= colCount) {
                int width = subParser.getColWidth(i2);
                if (!subParser.isColVisible(i2)) {
                    width = 0;
                }
                x[i2] = totalX += width;
                i2 = (short)(i2 + 1);
            }
            int[] y = new int[rowCount + 1];
            int totalY = y1;
            int startHeader = 0;
            int endHeader = 0;
            int startFooter = 0;
            int endFooter = 0;
            y[0] = totalY;
            Area headField = subParser.getPageHeader();
            if (headField != null && (startHeader = headField.getBeginRow()) != (endHeader = headField.getEndRow())) {
                y[endHeader] = totalY;
                int i3 = endHeader - 1;
                while (i3 >= startHeader) {
                    int height2 = subParser.getRowHeight(i3);
                    if (!subParser.isRowVisible(i3)) {
                        height2 = 0;
                    }
                    if ((totalY -= height2) < 0) {
                        totalY = 0;
                    }
                    y[i3] = totalY;
                    --i3;
                }
            }
            Area footField = subParser.getPageFooter();
            totalY = h + y1;
            if (footField != null && (startFooter = footField.getBeginRow()) != (endFooter = footField.getEndRow())) {
                i = startFooter + 1;
                while (i <= endFooter) {
                    y[i] = totalY;
                    height = subParser.getRowHeight(i);
                    if (!subParser.isRowVisible(i)) {
                        height = 0;
                    }
                    totalY += height;
                    ++i;
                }
                y[endFooter + 1] = totalY;
            }
            y[endHeader + 1] = totalY = y1;
            i = 1;
            while (i <= rowCount) {
                if (!(i >= startHeader && i <= endHeader || i >= startFooter && i <= endFooter)) {
                    height = subParser.getRowHeight(i);
                    if (!subParser.isRowVisible(i)) {
                        height = 0;
                    }
                    y[i] = totalY += height;
                }
                ++i;
            }
            i = 1;
            while (i <= rowCount) {
                if (subParser.isRowVisible(i)) {
                    short j = 1;
                    while (j <= colCount) {
                        if (subParser.isColVisible(j) && subParser.isCellVisible(i, j)) {
                            PdfCell pc = new PdfCell(subParser, i, j, g);
                            pc.drawCell(x, y);
                        }
                        j = (short)(j + 1);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ReportError(e.getMessage(), (Throwable)e);
        }
        return Excel2007Report.getImageByteArray(bi);
    }

    public static byte[] getImageByteArray(BufferedImage bi) {
        ByteArrayOutputStream baos = null;
        try {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = iter.hasNext() ? iter.next() : null;
            baos = new ByteArrayOutputStream();
            ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
            writer.setOutput(ios);
            writer.write(new IIOImage(bi, null, null));
            writer.dispose();
        }
        catch (Exception e) {
            throw new ReportError(e.getMessage(), (Throwable)e);
        }
        return baos.toByteArray();
    }

    private void drawBackground(Graphics2D g, int bkColor, int x1, int y1, int x2, int y2) {
        if (bkColor == 0xFFFFFF) {
            bkColor = -1;
        }
        Color color = new Color(bkColor);
        try {
            g.setColor(color);
            g.fillRect(x1, y1, x2 - x1, y2 - y1);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static void main(String[] args) throws Throwable {
        try {
            String licenseFile = "D:\\source\\report4\\jdeploy\\\u6da6\u4e7e\u5f00\u53d1ide_\u51681.lic";
            ExtCellSet.setLicenseFileName((String)licenseFile);
            String reportFile = "D:\\raqs\\ques\\report4\\test004.raq";
            IReport rd = ReportUtils.read((String)reportFile);
            Engine engine = new Engine(rd, new Context());
            IReport report = engine.calc();
            String outputFileName = "D:\\raqs\\ques\\report4\\test.xlsx";
            Excel2007Report excel = null;
            excel = new Excel2007Report();
            PageBuilder pb = new PageBuilder(report);
            excel.export(report);
            excel.setDispRatio(100);
            excel.setFomulaExported(Boolean.TRUE);
            excel.saveTo(outputFileName);
            System.out.println("- done -");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("- over -");
    }

    private float getColWidth(IReport rp, short col) {
        IColCell c = rp.getColCell(col);
        float w = c.getColWidth();
        w = this.unitTransfer(w);
        return w;
    }

    private float getRowHeight(IReport rp, int row) {
        IRowCell c = rp.getRowCell(row);
        float h = c.getRowHeight();
        h = this.unitTransfer(h);
        return h;
    }

    private float unitTransfer(float f) {
        if (this.unit == 2) {
            f *= 72.0f;
        } else if (this.unit == 1) {
            f = f * 72.0f / 25.4f;
        }
        return f;
    }

    private boolean isMergedFirstCell(ReportParser parser, int row, short col, boolean hiddenRow, boolean hiddenCol) {
        if (!parser.isMerged(row, col)) {
            return false;
        }
        Area area = parser.getMergedArea(row, col);
        int r1 = area.getBeginRow();
        short c1 = area.getBeginCol();
        if (hiddenRow && hiddenCol) {
            return row == r1 && col == c1;
        }
        int r2 = area.getEndRow();
        short c2 = area.getEndCol();
        if (hiddenRow) {
            short c = c1;
            while (c <= c2) {
                if (parser.isColVisible(c)) {
                    return row == r1 && col == c;
                }
                c = (short)(c + 1);
            }
        } else if (hiddenCol) {
            int r = r1;
            while (r <= r2) {
                if (parser.isRowVisible(r)) {
                    return row == r && col == c1;
                }
                ++r;
            }
        } else {
            int r = r1;
            while (r <= r2) {
                if (parser.isRowVisible(r)) {
                    short c = c1;
                    while (c <= c2) {
                        if (parser.isColVisible(c)) {
                            return row == r && col == c;
                        }
                        c = (short)(c + 1);
                    }
                }
                ++r;
            }
        }
        return false;
    }

    private XSSFFont getRichFont(String fontName, short fontSize, int foreColor, boolean isBold, boolean isItalic, boolean isUnderLine, byte rise, ArrayList<XSSFFont> fonts) {
        XSSFFont font;
        XSSFColor fontColor = new XSSFColor(new Color(foreColor));
        short fontBold = isBold ? (short)700 : 400;
        boolean fontItalic = isItalic;
        byte fontUnderline = isUnderLine ? (byte)1 : 0;
        short offset = 0;
        if (rise == RichTextUtil.RICH_SCRIPT_SUB) {
            offset = 2;
        } else if (rise == RichTextUtil.RICH_SCRIPT_SUPER) {
            offset = 1;
        }
        int i = 0;
        while (i < fonts.size()) {
            font = fonts.get(i);
            if (font.getFontName().equalsIgnoreCase(fontName) && font.getFontHeightInPoints() == fontSize && fontColor.equals((Object)font.getXSSFColor()) && font.getBoldweight() == fontBold && font.getItalic() == fontItalic && font.getUnderline() == fontUnderline && font.getTypeOffset() == offset) {
                return font;
            }
            ++i;
        }
        font = this.wb.createFont();
        font.setFontName(fontName);
        font.setFontHeightInPoints(fontSize);
        font.setColor(fontColor);
        font.setBoldweight(fontBold);
        font.setItalic(fontItalic);
        font.setUnderline(fontUnderline);
        font.setTypeOffset(offset);
        font.setCharSet((byte)-122);
        fonts.add(font);
        return font;
    }

    private int getColWidth(ReportParser parser, short c) {
        if (parser.isColVisible(c)) {
            return parser.getColWidth(c);
        }
        return 0;
    }

    private int getRowHeight(ReportParser parser, int r) {
        if (parser.isRowVisible(r)) {
            return parser.getRowHeight(r);
        }
        return 0;
    }

    private class Format {
        private boolean hiddenRow = true;
        private boolean hiddenCol = true;
        private boolean fullPaged = false;

        private Format() {
        }

        private Format(boolean row, boolean col, boolean exp, boolean fullPaged) {
            this.hiddenRow = row;
            this.hiddenCol = col;
            Excel2007Report.this.hasExp = exp;
            this.fullPaged = fullPaged;
        }
    }
}

