/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report4.view.excel2007;

import com.runqian.base4.util.StringUtils;
import com.runqian.report4.model.ReportDefine2;
import com.runqian.report4.usermodel.Area;
import com.runqian.report4.usermodel.IByteMap;
import com.runqian.report4.usermodel.INormalCell;
import com.runqian.report4.usermodel.IReport;
import com.runqian.report4.usermodel.PrintSetup;
import com.runqian.report4.util.ReportParser;
import java.awt.Color;
import java.awt.Font;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Sheet2007Transfer {
    private CellRangeAddress[] regions;
    private IReport report;
    private ReportParser parser;
    private XSSFWorkbook wb;
    private XSSFSheet sheet;
    private XSSFFont[] fonts;
    private boolean isInvalidSheet;
    private boolean formulaAsExp = false;
    private boolean exportRich = false;

    public Sheet2007Transfer(XSSFWorkbook wb, XSSFSheet sheet, XSSFFont[] fonts) {
        this.wb = wb;
        this.sheet = sheet;
        this.fonts = fonts;
        int rows = sheet.getLastRowNum() + 1;
        int cols = Sheet2007Transfer.getLastCol(sheet);
        if (rows == 1 && cols == 0) {
            this.isInvalidSheet = true;
            return;
        }
        this.report = new ReportDefine2(rows, cols);
        this.report.setUnit((byte)0);
        this.parser = new ReportParser(this.report);
        int i = 1;
        while (i <= rows) {
            XSSFRow r = sheet.getRow(i - 1);
            if (r != null) {
                float h = r.getHeight();
                h /= 19.62f;
                if (r.getZeroHeight()) {
                    this.report.getRowCell(i).setRowVisible(false);
                }
                this.report.getRowCell(i).setRowHeight(h);
            }
            ++i;
        }
        i = 1;
        while (i <= cols) {
            float w = sheet.getColumnWidth((int)((short)(i - 1)));
            if (w == 8.0f) {
                w = 2304.0f;
            }
            w /= 42.74f;
            if (sheet.isColumnHidden((int)((short)(i - 1)))) {
                this.report.getColCell((short)i).setColVisible(false);
            }
            this.report.getColCell((short)i).setColWidth(w);
            ++i;
        }
        this.regions = new CellRangeAddress[sheet.getNumMergedRegions()];
        i = 0;
        while (i < this.regions.length) {
            this.regions[i] = sheet.getMergedRegion(i);
            ++i;
        }
    }

    public void setFormulaAsExp(boolean b) {
        this.formulaAsExp = b;
    }

    public void setExportRichText(boolean b) {
        this.exportRich = b;
    }

    public IReport toReport() {
        if (this.isInvalidSheet) {
            return null;
        }
        XSSFDataFormat dataFormat = this.wb.createDataFormat();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DecimalFormat df = new DecimalFormat("#.##################");
        HashMap<String, String> transFont = new HashMap<String, String>();
        int row = 1;
        while (row <= this.report.getRowCount()) {
            XSSFRow r = this.sheet.getRow(row - 1);
            if (r != null) {
                short col = 1;
                while (col <= this.report.getColCount()) {
                    XSSFCell cell = r.getCell((int)((short)(col - 1)));
                    if (cell != null) {
                        String link;
                        XSSFFont font;
                        String fontName;
                        String canDisp;
                        int type = cell.getCellType();
                        INormalCell icell = this.parser.getCell(row, col);
                        String value = "";
                        boolean isRich = false;
                        switch (type) {
                            case 1: {
                                XSSFRichTextString rts = cell.getRichStringCellValue();
                                if (this.exportRich && rts != null && rts.numFormattingRuns() > 0) {
                                    isRich = true;
                                }
                                value = Sheet2007Transfer.transferString(cell, this.exportRich, this.fonts);
                                break;
                            }
                            case 0: {
                                String sformat;
                                double d = cell.getNumericCellValue();
                                if (Sheet2007Transfer.isCellDateFormatted(cell, dataFormat)) {
                                    Date dd = cell.getDateCellValue();
                                    int dateType = this.getDateType(cell.getCellStyle().getDataFormat());
                                    if (dateType == 0) {
                                        value = sdf.format(dd);
                                        break;
                                    }
                                    if (dateType == 1) {
                                        value = new SimpleDateFormat("HH:mm:ss").format(dd);
                                        break;
                                    }
                                    if (dateType != 2) break;
                                    value = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dd);
                                    break;
                                }
                                value = df.format(d);
                                int pos = value.indexOf(".");
                                if (pos >= 0) {
                                    boolean allZero = true;
                                    ++pos;
                                    while (pos < value.length()) {
                                        if (value.charAt(pos) != '0') {
                                            allZero = false;
                                            break;
                                        }
                                        ++pos;
                                    }
                                    if (allZero) {
                                        value = value.substring(0, value.indexOf("."));
                                    }
                                }
                                if ((sformat = this.getFormatString(cell)) == null || sformat.trim().length() <= 0 || sformat.equalsIgnoreCase("General") || sformat.equalsIgnoreCase("text") || sformat.equalsIgnoreCase("@")) break;
                                int _pos = (sformat = sformat.trim()).indexOf("_");
                                if (_pos > 0) {
                                    sformat = sformat.substring(0, _pos);
                                }
                                icell.setFormat(sformat);
                                break;
                            }
                            case 2: {
                                if (this.formulaAsExp) {
                                    value = "";
                                    IByteMap map = icell.getExpMap(true);
                                    map.put((byte)40, (Object)cell.getCellFormula());
                                    break;
                                }
                                value = null;
                                try {
                                    value = df.format(cell.getNumericCellValue());
                                }
                                catch (Exception map) {
                                    // empty catch block
                                }
                                String sformat = this.getFormatString(cell);
                                if (sformat == null || sformat.trim().length() <= 0 || sformat.equalsIgnoreCase("General") || sformat.equalsIgnoreCase("text") || sformat.equalsIgnoreCase("@")) break;
                                int _pos = (sformat = sformat.trim()).indexOf("_");
                                if (_pos > 0) {
                                    sformat = sformat.substring(0, _pos);
                                }
                                icell.setFormat(sformat);
                            }
                        }
                        if (value != null && value.trim().length() > 0) {
                            icell.setValue((Object)value);
                        }
                        if (isRich) {
                            icell.setCellType((byte)-56);
                        }
                        XSSFCellStyle style = cell.getCellStyle();
                        int align = -48;
                        short align1 = style.getAlignment();
                        if (align1 == 2) {
                            align = -47;
                        } else if (align1 == 3) {
                            align = -46;
                        } else if (align1 == 0) {
                            try {
                                Double.parseDouble(value);
                                align = -46;
                            }
                            catch (Exception e2) {
                                try {
                                    if (cell.getDateCellValue() != null) {
                                        align = -46;
                                    }
                                }
                                catch (Exception _pos) {
                                    // empty catch block
                                }
                            }
                        }
                        icell.setHAlign((byte)align);
                        byte valign = -31;
                        short valign1 = style.getVerticalAlignment();
                        if (valign1 == 0) {
                            valign = -32;
                        } else if (valign1 == 2) {
                            valign = -30;
                        }
                        icell.setVAlign(valign);
                        if (style.getWrapText()) {
                            icell.setTextWrap(true);
                        }
                        if ((canDisp = (String)transFont.get(fontName = (font = this.fonts[style.getFontIndex()]).getFontName())) == null) {
                            if (new Font(fontName, 0, 12).canDisplay('A')) {
                                transFont.put(fontName, "1");
                            } else {
                                transFont.put(fontName, "0");
                                fontName = "Dialog";
                            }
                        } else if ("0".equals(canDisp)) {
                            fontName = "Dialog";
                        }
                        icell.setFontName(fontName);
                        short fontSize = font.getFontHeightInPoints();
                        icell.setFontSize(fontSize);
                        icell.setForeColor(Sheet2007Transfer.getColor(font.getXSSFColor(), Color.black));
                        if (font.getBoldweight() == 700) {
                            icell.setBold(true);
                        }
                        icell.setItalic(font.getItalic());
                        if (font.getUnderline() != 0) {
                            icell.setUnderline(true);
                        }
                        this.setBorder(style.getBorderTop(), style.getTopBorderXSSFColor(), row, col, 1);
                        this.setBorder(style.getBorderBottom(), style.getBottomBorderXSSFColor(), row, col, 2);
                        this.setBorder(style.getBorderLeft(), style.getLeftBorderXSSFColor(), row, col, 3);
                        this.setBorder(style.getBorderRight(), style.getRightBorderXSSFColor(), row, col, 4);
                        icell.setBackColor(this.getColor(style, Color.WHITE));
                        XSSFHyperlink hlink = cell.getHyperlink();
                        if (hlink != null && (link = hlink.getAddress()) != null && link.trim().length() > 0) {
                            icell.setHyperlink(link);
                        }
                    }
                    col = (short)(col + 1);
                }
            }
            ++row;
        }
        this.setMergedArea();
        PrintSetup ps = this.report.getPrintSetup();
        XSSFPrintSetup hps = this.sheet.getPrintSetup();
        ps.setPaper(hps.getPaperSize());
        if (hps.getLandscape()) {
            ps.setOrientation((byte)0);
        } else {
            ps.setOrientation((byte)1);
        }
        ps.setLeftMargin((float)(this.sheet.getMargin((short)0) * 25.4));
        ps.setRightMargin((float)(this.sheet.getMargin((short)1) * 25.4));
        ps.setTopMargin((float)(this.sheet.getMargin((short)2) * 25.4));
        ps.setBottomMargin((float)(this.sheet.getMargin((short)3) * 25.4));
        return this.report;
    }

    public int getColor(XSSFCellStyle cs, Color defColor) {
        if (cs != null) {
            XSSFColor xc = cs.getFillForegroundXSSFColor();
            return Sheet2007Transfer.getColor(xc, defColor);
        }
        return defColor.getRGB();
    }

    public static int getColor(XSSFColor xc, Color defColor) {
        byte[] argb;
        Color c = defColor;
        if (xc != null && (argb = xc.getRgb()) != null) {
            c = new Color(Sheet2007Transfer.byteToInt(argb[1]), Sheet2007Transfer.byteToInt(argb[2]), Sheet2007Transfer.byteToInt(argb[3]), Sheet2007Transfer.byteToInt(argb[0]));
        }
        return c.getRGB();
    }

    private static int byteToInt(byte b) {
        if (b >= 0) {
            return b;
        }
        return b + 256;
    }

    public static String transferString(XSSFCell cell, boolean exportRich, XSSFFont[] fonts) {
        if (cell == null) {
            return null;
        }
        XSSFRichTextString rts = cell.getRichStringCellValue();
        String str = cell.getStringCellValue();
        if (!exportRich || rts == null || rts.numFormattingRuns() < 1) {
            return str;
        }
        XSSFFont defFont = fonts[cell.getCellStyle().getFontIndex()];
        int length = rts.numFormattingRuns();
        XSSFFont styleFont = defFont;
        try {
            styleFont = rts.getFontOfFormattingRun(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int seek = rts.getIndexOfFormattingRun(0);
        StringBuffer sb = new StringBuffer();
        if (seek > 0) {
            sb.append(str.substring(0, seek));
        }
        int i = 1;
        while (i < length) {
            int index = rts.getIndexOfFormattingRun(i);
            String subs = str.substring(seek, index);
            Sheet2007Transfer.appendSubString(styleFont, sb, defFont, subs);
            styleFont = rts.getFontOfFormattingRun(i);
            seek = index;
            ++i;
        }
        String subs = str.substring(seek);
        Sheet2007Transfer.appendSubString(styleFont, sb, defFont, subs);
        return sb.toString();
    }

    private static void appendSubString(XSSFFont font, StringBuffer sb, XSSFFont defFont, String subs) {
        if (subs == null || subs.length() < 1) {
            return;
        }
        int defColor = 0;
        if (defFont != null && defFont.getXSSFColor() != null) {
            defColor = Sheet2007Transfer.getColor(defFont.getXSSFColor(), Color.BLACK);
        }
        String fontName = font.getFontName();
        short bw = font.getBoldweight();
        int colorIndex = -1;
        int color = 0;
        XSSFColor xc = font.getXSSFColor();
        if (xc == null) {
            colorIndex = font.getColor();
        } else {
            color = Sheet2007Transfer.getColor(xc, Color.BLACK);
        }
        short size = font.getFontHeightInPoints();
        boolean italic = font.getItalic();
        short offset = font.getTypeOffset();
        byte underline = font.getUnderline();
        if (offset == 2) {
            sb.append("<sub>");
        } else if (offset == 1) {
            sb.append("<sup>");
        }
        sb.append("<font ").append(" style=\"");
        if (fontName != null && !fontName.equals(defFont)) {
            sb.append("font-family:").append(fontName).append(";");
        }
        if (size != defFont.getFontHeightInPoints()) {
            sb.append("font-size:").append(size).append(";");
        }
        if (bw != defFont.getBoldweight()) {
            if (bw == 700) {
                sb.append("font-weight:bold;");
            } else if (bw == 400) {
                sb.append("font-weight:normal;");
            }
        }
        if (italic != defFont.getItalic()) {
            if (italic) {
                sb.append("font-style:italic;");
            } else {
                sb.append("font-style:normal;");
            }
        }
        if (underline != defFont.getUnderline()) {
            if (underline != 0) {
                sb.append("text-decoration:underline;");
            } else {
                sb.append("text-decoration:none;");
            }
        }
        if (color != defColor) {
            sb.append("color:");
            Sheet2007Transfer.appendColor(sb, color);
        }
        sb.append("\">");
        sb.append(subs);
        sb.append("</font>");
        if (offset == 2) {
            sb.append("</sub>");
        } else if (offset == 1) {
            sb.append("</sup>");
        }
    }

    private static void appendColor(StringBuffer sb, int color) {
        if ((color >> 24 & 0xFF) == 0) {
            sb.append("transparent");
            return;
        }
        sb.append('#');
        StringUtils.appendHexString((StringBuffer)sb, (long)color, (int)3);
    }

    public void save(String raqFile) throws Exception {
        if (this.isInvalidSheet) {
            return;
        }
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(raqFile));
        oos.writeObject(this.report);
        oos.close();
    }

    private void setMergedArea() {
        int i = 0;
        while (i < this.regions.length) {
            int row1 = this.regions[i].getFirstRow() + 1;
            int row2 = this.regions[i].getLastRow() + 1;
            short col1 = (short)(this.regions[i].getFirstColumn() + 1);
            short col2 = (short)(this.regions[i].getLastColumn() + 1);
            INormalCell cell = this.parser.getCell(row1, col1);
            cell.setMergedArea(new Area(row1, col1, row2, col2));
            int r = row1;
            while (r <= row2) {
                short c = col1;
                while (c <= col2) {
                    this.report.setCell(r, c, cell);
                    c = (short)(c + 1);
                }
                ++r;
            }
            ++i;
        }
    }

    private void setBorder(short border, XSSFColor xc, int row, short col, int location) {
        byte bs = 80;
        float bw = 0.75f;
        switch (border) {
            case 7: 
            case 9: 
            case 11: {
                bs = 81;
                break;
            }
            case 3: {
                bs = 82;
                break;
            }
            case 6: {
                bs = 84;
                break;
            }
            case 4: {
                bs = 83;
                break;
            }
            case 2: {
                bs = 83;
                bw = 1.5f;
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                bs = 81;
                bw = 1.5f;
                break;
            }
            case 8: {
                bs = 82;
                bw = 1.5f;
                break;
            }
            case 0: {
                bs = 80;
                return;
            }
            case 5: {
                bs = 83;
                bw = 2.0f;
                break;
            }
            case 1: {
                bs = 83;
                bw = 1.0f;
            }
        }
        switch (location) {
            case 1: {
                this.report.setTBStyle(row, col, bs);
                this.report.setTBWidth(row, col, bw);
                this.report.setTBColor(row, col, Sheet2007Transfer.getColor(xc, Color.black));
                break;
            }
            case 2: {
                this.report.setBBStyle(row, col, bs);
                this.report.setBBWidth(row, col, bw);
                this.report.setBBColor(row, col, Sheet2007Transfer.getColor(xc, Color.black));
                break;
            }
            case 3: {
                this.report.setLBStyle(row, col, bs);
                this.report.setLBWidth(row, col, bw);
                this.report.setLBColor(row, col, Sheet2007Transfer.getColor(xc, Color.black));
                break;
            }
            case 4: {
                this.report.setRBStyle(row, col, bs);
                this.report.setRBWidth(row, col, bw);
                this.report.setRBColor(row, col, Sheet2007Transfer.getColor(xc, Color.black));
            }
        }
    }

    static int getLastCol(XSSFSheet sheet) {
        short col = 0;
        int rows = sheet.getLastRowNum();
        int i = 0;
        while (i <= rows) {
            short n;
            XSSFRow r = sheet.getRow(i);
            if (r != null && (n = r.getLastCellNum()) > col) {
                col = n;
            }
            ++i;
        }
        return col;
    }

    private int getDateType(short format) {
        switch (format) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 32: 
            case 33: 
            case 55: 
            case 56: {
                return 1;
            }
            case 22: {
                return 2;
            }
        }
        if (format >= 201 && format <= 211) {
            return 1;
        }
        return 0;
    }

    private String getFormatString(XSSFCell cell) {
        XSSFDataFormat df = this.wb.createDataFormat();
        return df.getFormat(cell.getCellStyle().getDataFormat());
    }

    private static boolean isCellDateFormatted(XSSFCell cell, XSSFDataFormat df) {
        if (df == null) {
            return Sheet2007Transfer.isCellDateFormatted(cell);
        }
        if (cell == null) {
            return false;
        }
        double d = cell.getNumericCellValue();
        if (Sheet2007Transfer.isValidExcelDate(d)) {
            XSSFCellStyle style = cell.getCellStyle();
            short i = style.getDataFormat();
            if (Sheet2007Transfer.isInternalDateFormat(i)) {
                return true;
            }
            String pattern = df.getFormat(i);
            return Sheet2007Transfer.hasYMDHMS(pattern);
        }
        return false;
    }

    private static boolean isCellDateFormatted(XSSFCell cell) {
        if (cell == null) {
            return false;
        }
        boolean bDate = false;
        double d = cell.getNumericCellValue();
        if (Sheet2007Transfer.isValidExcelDate(d)) {
            XSSFCellStyle style = cell.getCellStyle();
            short i = style.getDataFormat();
            String f = style.getDataFormatString();
            bDate = Sheet2007Transfer.isADateFormat(i, f);
        }
        return bDate;
    }

    private static boolean isValidExcelDate(double value) {
        return value > -4.9E-324;
    }

    private static boolean isInternalDateFormat(int format) {
        switch (format) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 45: 
            case 46: 
            case 47: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    private static boolean hasYMDHMS(String pattern) {
        if (pattern == null) {
            return false;
        }
        int len = pattern.length();
        int i = 0;
        block7: while (i < len) {
            char ch = pattern.charAt(i);
            block0 : switch (ch) {
                case '\\': {
                    i += 2;
                    break;
                }
                case '\"': {
                    while (++i < len) {
                        if (pattern.charAt(i) != '\"') continue;
                        ++i;
                        break block0;
                    }
                    continue block7;
                }
                case '[': {
                    while (++i < len) {
                        if (pattern.charAt(i) != ']') continue;
                        ++i;
                        break block0;
                    }
                    continue block7;
                }
                case 'a': {
                    if (i <= len - 3 && pattern.charAt(i + 1) == 'a' && pattern.charAt(i + 2) == 'a') {
                        return true;
                    }
                    ++i;
                    break;
                }
                case 'd': 
                case 'h': 
                case 'm': 
                case 's': 
                case 'y': {
                    return true;
                }
                default: {
                    ++i;
                }
            }
        }
        return false;
    }

    private static boolean isADateFormat(int formatIndex, String formatString) {
        if (Sheet2007Transfer.isInternalDateFormat(formatIndex)) {
            return true;
        }
        if (formatString == null || formatString.length() == 0) {
            return false;
        }
        String fs = formatString;
        fs = fs.replaceAll("\\\\-", "-");
        fs = fs.replaceAll("\\\\,", ",");
        fs = fs.replaceAll("\\\\ ", " ");
        fs = fs.replaceAll(";@", "");
        fs = fs.replaceAll("^\\[\\$\\-.*?\\]", "");
        return (fs = fs.replaceAll("^\\[[a-zA-Z]+\\]", "")).matches("^[yYmMdDhHsS\\-/,. :]+[ampAMP/]*$");
    }
}

