/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base4.swing;

import com.runqian.base4.swing.CheckBoxRenderer;
import com.runqian.base4.swing.JComboBoxEx;
import com.runqian.base4.swing.JComboBoxExEditor;
import com.runqian.base4.swing.JComboBoxExRenderer;
import com.runqian.base4.swing.JTableExListener;
import com.runqian.base4.swing.JTextAreaEditor;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.Sentence;
import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JTableEx
extends JTable
implements MouseListener,
JTableExListener {
    public static int ALIGN_CENTER;
    public static int ALIGN_LEFT;
    public static int ALIGN_RIGHT;
    public HashSet clickedListener;
    private HashMap columnKeeper;
    public DefaultTableModel data = new DefaultTableModel();
    private Color disabledBackColor;
    private Color disabledForeColor;
    private boolean ifFireRowfocusChangedEvent = true;
    private int indexCol = -1;
    private int n;
    private int oldRow = -1;
    public Object tag;

    static {
        ALIGN_LEFT = 2;
        ALIGN_CENTER = 0;
        ALIGN_RIGHT = 4;
    }

    public JTableEx(String columnNames) {
        this();
        ArgumentTokenizer st = new ArgumentTokenizer(columnNames);
        ArrayList<String> al = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            al.add(st.nextToken());
        }
        String[] cols = new String[al.size()];
        int i = 0;
        while (i < cols.length) {
            cols[i] = (String)al.get(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < cols.length) {
            this.addColumn(cols[i2]);
            this.setColumnDefaultEditor(i2);
            ++i2;
        }
        this.holdColumnNames();
        this.oldRow = -1;
    }

    public JTableEx(String[] colNames) {
        this();
        int i = 0;
        while (i < colNames.length) {
            this.addColumn(colNames[i]);
            this.setColumnDefaultEditor(i);
            ++i;
        }
        this.holdColumnNames();
        this.oldRow = -1;
    }

    public JTableEx() {
        this.columnKeeper = new HashMap();
        this.clickedListener = new HashSet();
        this.disabledBackColor = Color.lightGray;
        this.disabledForeColor = Color.black;
        this.setModel(this.data);
        this.addMouseListener(this);
        this.addTableExListener(this);
        this.getColumnModel().addColumnModelListener(new TableColListener(this));
        this.getTableHeader().setReorderingAllowed(false);
    }

    public void acceptText() {
        if (this.getCellEditor() != null && this.getRowCount() > 0) {
            int r = this.getSelectedRow();
            int c = this.getRowCount();
            int e = this.getEditingRow();
            if (e >= c) {
                return;
            }
            this.getCellEditor().stopCellEditing();
        }
    }

    public void addColumn(String colName) {
        this.data.addColumn(colName);
        this.holdColumnNames();
    }

    public int addRow() {
        return this.addRow(new Vector());
    }

    public int addRow(Object[] oa) {
        this.acceptText();
        this.data.addRow(oa);
        int r = this.data.getRowCount() - 1;
        this.setEditingRow(r);
        this.selectRow(r);
        this.resetIndex();
        return r;
    }

    public int addRow(Vector v) {
        return this.addRow(v.toArray());
    }

    public void addTableExListener(JTableExListener jcl) {
        this.clickedListener.add(jcl);
    }

    public boolean checkColumnData(int colIndex, String colDesc) {
        return this.verifyColumnData(colIndex, colDesc);
    }

    public void clicked(int xpos, int ypos, int row, int col, MouseEvent e) {
    }

    public void deleteColumn(TableColumn aColumn) {
        String colName = (String)aColumn.getIdentifier();
        int cc = this.data.getColumnCount();
        DefaultTableModel dataModel = new DefaultTableModel();
        TableColumnModel tcm = this.getColumnModel();
        int i = 0;
        while (i < cc) {
            String tmpName = (String)tcm.getColumn(i).getIdentifier();
            if (!tmpName.equalsIgnoreCase(colName)) {
                Vector cData = this.getColumnData(i);
                dataModel.addColumn((Object)tmpName, cData);
            }
            ++i;
        }
        this.setModel(dataModel);
    }

    public boolean deleteSelectedRow() {
        this.acceptText();
        int cr = this.getSelectedRow();
        if (cr < 0) {
            return false;
        }
        this.data.removeRow(this.getSelectedRow());
        int r = this.getRowCount() - 1;
        this.clearSelection();
        if (cr < r) {
            r = cr;
        }
        this.selectRow(r);
        this.resetIndex();
        return true;
    }

    public boolean deleteSelectedRows() {
        this.acceptText();
        int cr = this.getSelectedRow();
        if (cr < 0) {
            return false;
        }
        this.removeCurrentRow();
        int r = this.getRowCount() - 1;
        this.clearSelection();
        if (cr < r) {
            r = cr;
        }
        this.selectRow(r);
        this.resetIndex();
        return true;
    }

    public void disableRowfocusChanged() {
        this.ifFireRowfocusChangedEvent = false;
    }

    public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
    }

    public void enableRowfocusChanged() {
        this.ifFireRowfocusChangedEvent = true;
    }

    public boolean exportData(boolean exportTitle, FileWriter fw, boolean dosFormat) throws Exception {
        int c;
        String sRow = "";
        String sTmp = "";
        int cc = this.getColumnCount();
        int rc = this.getRowCount();
        String rowSep = dosFormat ? "\r\n" : "\r";
        if (exportTitle) {
            if (cc == 0) {
                return false;
            }
            c = 0;
            while (c < cc) {
                sTmp = sTmp + "\t" + this.getColumnName(c);
                ++c;
            }
            sRow = rowSep + sTmp.substring(1);
        }
        int r = 0;
        while (r < rc) {
            sTmp = "";
            c = 0;
            while (c < cc) {
                sTmp = sTmp + "\t" + this.data.getValueAt(r, c);
                ++c;
            }
            sRow = sRow + rowSep + sTmp.substring(1);
            ++r;
        }
        fw.write(sRow.substring(rowSep.length()));
        return true;
    }

    public void fireClicked(int xpos, int ypos, MouseEvent e) {
        Iterator it = this.clickedListener.iterator();
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row == -1) {
            row = this.rowAtPoint(new Point(e.getX(), e.getY()));
        }
        if (col == -1) {
            col = this.columnAtPoint(new Point(e.getX(), e.getY()));
        }
        while (it.hasNext()) {
            JTableExListener lis = (JTableExListener)it.next();
            if (e.getButton() == 3) {
                lis.rightClicked(xpos, ypos, row, col, e);
                continue;
            }
            if (e.getButton() != 1) continue;
            switch (e.getClickCount()) {
                case 1: {
                    lis.clicked(xpos, ypos, row, col, e);
                    break;
                }
                case 2: {
                    lis.doubleClicked(xpos, ypos, row, col, e);
                    break;
                }
            }
        }
    }

    private void fireRowfocusChanged(int oldRow, int newRow) {
        if (!this.ifFireRowfocusChangedEvent) {
            return;
        }
        Iterator it = this.clickedListener.iterator();
        if (oldRow >= this.getRowCount()) {
            oldRow = -1;
        }
        while (it.hasNext()) {
            JTableExListener lis = (JTableExListener)it.next();
            lis.rowfocusChanged(oldRow, newRow);
        }
        this.resizeAndRepaint();
    }

    public void focusGained(FocusEvent e) {
    }

    public String getBlockData() {
        StringBuffer sb = new StringBuffer(1024);
        this.acceptText();
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.isRowSelected(i)) {
                String row = this.getRowData(i);
                sb.append(row);
                if (i < this.getRowCount() - 1) {
                    sb.append("\n");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public TableColumn getColumn(int columnIndex) {
        return this.getColumn(this.getColumnName(columnIndex));
    }

    public Vector getColumnData(int colIndex) {
        Vector<Object> cData = new Vector<Object>();
        int r = 0;
        while (r < this.data.getRowCount()) {
            cData.add(this.data.getValueAt(r, colIndex));
            ++r;
        }
        return cData;
    }

    public int getColumnIndex(String colName) {
        int i = 0;
        while (i < this.getColumnCount()) {
            String name = this.getColumnName(i);
            if (name.equals(colName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getRowData(int row) {
        if (row < 0) {
            return "";
        }
        int rowCount = this.data.getRowCount();
        if (row >= rowCount) {
            return "";
        }
        int colCount = this.data.getColumnCount();
        StringBuffer rowData = new StringBuffer(1024);
        int i = 0;
        while (i < colCount) {
            Object item = this.data.getValueAt(row, i);
            if (item == null) {
                item = "";
            }
            rowData.append(item.toString());
            if (i < colCount - 1) {
                rowData.append("\t");
            }
            ++i;
        }
        return rowData.toString();
    }

    public void hideColumn(String columnName) {
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.getColumn(columnName);
        Object id = col.getIdentifier();
        this.columnKeeper.put(id, col);
        this.removeColumn(col);
    }

    void holdColumnNames() {
        if (this.columnKeeper == null) {
            return;
        }
        this.columnKeeper.clear();
        TableColumnModel cm = this.getColumnModel();
        Enumeration<TableColumn> cols = cm.getColumns();
        while (cols.hasMoreElements()) {
            TableColumn tmpCol = cols.nextElement();
            tmpCol.setCellEditor(new SimpleEditor(new JTextField(), this));
            Object tmpName = tmpCol.getIdentifier();
            this.columnKeeper.put(tmpName, tmpCol);
        }
    }

    public boolean isColumnVisible(Object column) {
        TableColumnModel cm = this.getColumnModel();
        int i = 0;
        while (i < cm.getColumnCount()) {
            TableColumn tc = cm.getColumn(i);
            if (tc.getIdentifier().equals(column)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isItemDataChanged(int row, int column, Object newValue) {
        if (column == this.indexCol) {
            return false;
        }
        Object oldValue = this.getValueAt(row, column);
        if (newValue instanceof String) {
            if (GM.isValidString(oldValue)) {
                return !oldValue.equals(newValue);
            }
            return GM.isValidString(newValue);
        }
        if (oldValue != null) {
            return !oldValue.equals(newValue);
        }
        return newValue != null;
    }

    public void mouseClicked(MouseEvent e) {
        Container p = this.getParent();
        Container ct = this.getTopLevelAncestor();
        int absoluteX = e.getX();
        int absoluteY = e.getY();
        while (p != ct) {
            absoluteX += p.getX();
            absoluteY += p.getY();
            p = p.getParent();
        }
        this.fireClicked(absoluteX, absoluteY, e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void removeAllRows() {
        this.data.setRowCount(0);
        this.oldRow = -1;
    }

    public void removeClickedListener(JTableExListener jcl) {
        this.clickedListener.remove(jcl);
    }

    public int removeCurrentRow() {
        this.acceptText();
        int cr = 0;
        int i = this.getRowCount();
        while (i >= 0) {
            if (this.isRowSelected(i)) {
                this.data.removeRow(i);
                ++cr;
            }
            --i;
        }
        return cr;
    }

    public int removeRow(int row) {
        if (row < 0) {
            return -1;
        }
        int c = this.data.getRowCount();
        if (row >= c) {
            return -1;
        }
        this.data.removeRow(row);
        int t = this.getRowCount();
        if (t == row) {
            --row;
        }
        this.selectRow(row);
        this.setEditingRow(row);
        return row;
    }

    public void resetColumns(ArrayList newColNames) {
        this.data.setColumnCount(0);
        int i = 0;
        while (i < newColNames.size()) {
            this.data.addColumn(newColNames.get(i));
            ++i;
        }
        this.holdColumnNames();
    }

    public void resetIndex() {
        if (this.indexCol == -1) {
            return;
        }
        int c = this.getRowCount();
        int i = 0;
        while (i < c) {
            this.data.setValueAt(new Integer(i + 1), i, this.indexCol);
            ++i;
        }
    }

    public void rightClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
    }

    public void rowfocusChanged(int oldRow, int newRow) {
    }

    public void rowfocusChanging(int oldRow, int newRow) {
    }

    public int searchValue(Object value, int searchColumn) {
        int i = 0;
        while (i < this.getRowCount()) {
            Object o = this.getValueAt(i, searchColumn);
            if (value.equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void selectRow(int row) {
        DefaultListSelectionModel selectModel = new DefaultListSelectionModel();
        selectModel.addSelectionInterval(row, row);
        this.setSelectionModel(selectModel);
        this.setEditingRow(row);
        int n = row;
        this.fireRowfocusChanged(this.oldRow, row);
        this.oldRow = n;
    }

    public int setBlockData(String ls_data) {
        this.acceptText();
        if (!GM.isValidString(ls_data)) {
            return -1;
        }
        int r = 0;
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (row < 0) {
            row = this.getRowCount() + 1;
        }
        if (col < 0) {
            col = 0;
        }
        ls_data = Sentence.replace(ls_data, "\r\n", "\r", 1);
        ls_data = Sentence.replace(ls_data, "\n", "\r", 1);
        ArgumentTokenizer rows = new ArgumentTokenizer(ls_data, '\r');
        while (rows.hasMoreTokens()) {
            String ls_row = rows.nextToken();
            if (!GM.isValidString(ls_row)) continue;
            if (row >= this.getRowCount()) {
                row = this.addRow();
            }
            int li_col = col;
            int colCount = this.data.getColumnCount();
            ArgumentTokenizer items = new ArgumentTokenizer(ls_row, '\t');
            while (items.hasMoreTokens()) {
                String item = items.nextToken();
                this.data.setValueAt(item, row, li_col);
                if (++li_col == colCount) break;
            }
            ++row;
            ++r;
        }
        return r;
    }

    public void setClickCountToStart(int startCount) {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                TableCellEditor editor = this.getCellEditor(row, col);
                if (editor != null && editor instanceof DefaultCellEditor) {
                    ((DefaultCellEditor)editor).setClickCountToStart(startCount);
                }
                ++col;
            }
            ++row;
        }
    }

    public void setColumnAlign(String columnName, int alignment) {
        TableCellEditor oldEditor;
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.getColumn(columnName);
        TableCellRenderer oldRender = col.getCellRenderer();
        if (oldRender == null || oldRender != null && oldRender instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer cbRender = new DefaultTableCellRenderer();
            cbRender.setHorizontalAlignment(alignment);
            col.setCellRenderer(cbRender);
        }
        if ((oldEditor = col.getCellEditor()) == null || oldEditor != null && oldEditor instanceof SimpleEditor) {
            JTextField tf = new JTextField();
            tf.setHorizontalAlignment(alignment);
            col.setCellEditor(new SimpleEditor(tf, this));
        }
    }

    public void setColumnAlign(int columnIndex, int alignment) {
        this.setColumnAlign(this.getColumnName(columnIndex), alignment);
    }

    public void setColumnCheckBox(String columnName) {
        JCheckBox checkBoxEditor = new JCheckBox();
        checkBoxEditor.setHorizontalAlignment(0);
        DefaultCellEditor cellEditor = new DefaultCellEditor(checkBoxEditor);
        CheckBoxRenderer cellRenderer = new CheckBoxRenderer();
        TableColumn col = this.getColumn(columnName);
        col.setCellEditor(cellEditor);
        col.setCellRenderer(cellRenderer);
    }

    public void setColumnCheckBox(int columnIndex) {
        this.setColumnCheckBox(this.getColumnName(columnIndex));
    }

    public void setColumnDefaultEditor(String columnName) {
        TableColumn col = this.getColumn(columnName);
        col.setCellEditor(new SimpleEditor(new JTextField(), this));
        DefaultTableCellRenderer dr = new DefaultTableCellRenderer();
        col.setCellRenderer(dr);
    }

    public void setColumnDefaultEditor(int columnIndex) {
        this.setColumnDefaultEditor(this.getColumnName(columnIndex));
    }

    public void setColumnDropDown(String columnName, Vector codeItems, Vector dispItems, boolean editable) {
        JComboBoxEx combo = new JComboBoxEx();
        combo.x_setData(codeItems, dispItems);
        combo.setEditable(editable);
        TableColumn col = this.getColumn(columnName);
        JComboBoxExEditor cellEditor = new JComboBoxExEditor(combo);
        JComboBoxExRenderer cellRenderer = new JComboBoxExRenderer(combo);
        col.setCellEditor(cellEditor);
        col.setCellRenderer(cellRenderer);
    }

    public void setColumnDropDown(String columnName, Vector codeItems, Vector dispItems) {
        this.setColumnDropDown(columnName, codeItems, dispItems, false);
    }

    public void setColumnDropDown(int columnIndex, Vector codeItems, Vector dispItems, boolean editable) {
        this.setColumnDropDown(this.getColumnName(columnIndex), codeItems, dispItems, editable);
    }

    public void setColumnDropDown(int columnIndex, Vector codeItems, Vector dispItems) {
        this.setColumnDropDown(this.getColumnName(columnIndex), codeItems, dispItems);
    }

    public void setColumnEditable(String columnName, boolean allowEdit) {
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        if (!allowEdit) {
            TableColumn col = this.getColumn(columnName);
            JTextField jtf = new JTextField();
            jtf.setEditable(allowEdit);
            col.setCellEditor(new DefaultCellEditor(jtf));
            DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
            col.setCellRenderer(dtcr);
        } else {
            this.setColumnDefaultEditor(columnName);
        }
    }

    public void setColumnEditable(int columnIndex, boolean allowEdit) {
        this.setColumnEditable(this.getColumnName(columnIndex), allowEdit);
    }

    public void setColumnEnable(String columnName, boolean enable) {
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.getColumn(columnName);
        TableCellRenderer o = col.getCellRenderer();
        int align = ALIGN_LEFT;
        if (o != null && o instanceof DefaultTableCellRenderer) {
            align = ((DefaultTableCellRenderer)o).getHorizontalAlignment();
        }
        JTextField jtf = new JTextField();
        jtf.setHorizontalAlignment(align);
        if (enable) {
            col.setCellEditor(new DefaultCellEditor(jtf));
            DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
            dtcr.setHorizontalAlignment(align);
            col.setCellRenderer(dtcr);
        } else {
            col.setCellEditor(new DisabledEditor(jtf));
            DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
            dtcr.setHorizontalAlignment(align);
            dtcr.setForeground(this.disabledForeColor);
            dtcr.setBackground(this.disabledBackColor);
            col.setCellRenderer(dtcr);
        }
    }

    public void setColumnEnable(int columnIndex, boolean enable) {
        this.setColumnEnable(this.getColumnName(columnIndex), enable);
    }

    public void setColumnFixedWidth(int columnIndex, int width) {
        String columnName = this.getColumnName(columnIndex);
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.getColumn(columnName);
        col.setPreferredWidth(width);
        col.setMaxWidth(width);
    }

    public void setColumnSpinner(String columnName) {
        JTextAreaEditor integerEditor = new JTextAreaEditor(this, 3);
        TableColumn tc = this.getColumn(columnName);
        tc.setCellEditor(integerEditor);
    }

    public void setColumnSpinner(int columnIndex) {
        this.setColumnSpinner(this.getColumnName(columnIndex));
    }

    public void setColumnVisible(String colName, boolean vis) {
        if (vis) {
            this.showColumn(colName);
        } else {
            this.hideColumn(colName);
        }
    }

    public void setColumnWidth(String columnName, int width) {
        if (!this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = this.getColumn(columnName);
        col.setPreferredWidth(width);
    }

    public void setColumnWidth(int columnIndex, int width) {
        this.setColumnWidth(this.getColumnName(columnIndex), width);
    }

    public void setDisabledColor(Color foreColor, Color backColor) {
        this.disabledForeColor = foreColor;
        this.disabledBackColor = backColor;
    }

    public void setIndexCol(int indexCol) {
        this.indexCol = indexCol;
        this.setColumnAlign(indexCol, ALIGN_CENTER);
        this.setColumnEnable(indexCol, false);
        this.setColumnFixedWidth(indexCol, 40);
    }

    public void setModel(TableModel dataModel) {
        this.data = (DefaultTableModel)dataModel;
        super.setModel(this.data);
        this.holdColumnNames();
        this.oldRow = -1;
    }

    public int shiftRowDown(int row) {
        int cr = row < 0 ? this.getSelectedRow() : row;
        if (cr < 0 || cr >= this.getRowCount() - 1) {
            return -1;
        }
        this.data.moveRow(cr, cr, cr + 1);
        this.selectRow(cr + 1);
        return cr + 1;
    }

    public int shiftRowUp(int row) {
        int cr = row < 0 ? this.getSelectedRow() : row;
        if (cr <= 0) {
            return -1;
        }
        this.data.moveRow(cr, cr, cr - 1);
        this.selectRow(cr - 1);
        return cr - 1;
    }

    public void showColumn(String columnName) {
        if (this.isColumnVisible(columnName)) {
            return;
        }
        TableColumn col = (TableColumn)this.columnKeeper.get(columnName);
        if (col == null) {
            return;
        }
        this.addColumn(col);
    }

    public void valueChanged(ListSelectionEvent e) {
        int r = this.getSelectedRow();
        if (r < 0) {
            return;
        }
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.n = r;
        if (this.n == this.oldRow) {
            return;
        }
        this.fireRowfocusChanged(this.oldRow, r);
        this.oldRow = this.n;
    }

    public boolean verifyColumnData(int colIndex, String colDesc) {
        this.acceptText();
        HashSet<String> keys = new HashSet<String>();
        int r = this.getRowCount();
        int i = 0;
        while (i < r) {
            String key = (String)this.data.getValueAt(i, colIndex);
            if (!GM.isValidString(key)) {
                JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("jtableex.nullkey1") + (i + 1) + Lang.getText("jtableex.nullkey2") + colDesc + Lang.getText("jtableex.nullkey3"), Lang.getText("public.note"), 2);
                return false;
            }
            if (keys.contains(key)) {
                JOptionPane.showMessageDialog(GV.appFrame, Lang.getText("jtableex.repeat") + colDesc + "\uff1a" + key, Lang.getText("public.note"), 2);
                return false;
            }
            keys.add(key);
            ++i;
        }
        return true;
    }

    class TableColListener
    implements TableColumnModelListener {
        JTableEx table;

        public TableColListener(JTableEx table) {
            this.table = table;
        }

        public void columnAdded(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
            this.table.acceptText();
        }

        public void columnMoved(TableColumnModelEvent e) {
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    class SimpleEditor
    extends DefaultCellEditor
    implements KeyListener,
    MouseListener,
    FocusListener {
        JTableEx parent;

        public SimpleEditor(JTextField tf, JTableEx parent) {
            super(tf);
            tf.addKeyListener(this);
            tf.addFocusListener(this);
            tf.addMouseListener(this);
            tf.setBorder(BorderFactory.createEmptyBorder());
            this.parent = parent;
            this.setClickCountToStart(1);
        }

        public void focusGained(FocusEvent e) {
            this.parent.focusGained(e);
        }

        public void focusLost(FocusEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            JComponent editor = (JComponent)e.getSource();
            Container ct = editor.getTopLevelAncestor();
            int absoluteX = e.getX() + editor.getX();
            int absoluteY = e.getY() + editor.getY();
            Container p = editor.getParent();
            while (p != ct) {
                absoluteX += p.getX();
                absoluteY += p.getY();
                p = p.getParent();
            }
            this.parent.fireClicked(absoluteX, absoluteY, e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    class DisabledEditor
    extends DefaultCellEditor {
        public DisabledEditor(JTextField jTxt) {
            super(jTxt);
            jTxt.setBackground(JTableEx.this.disabledBackColor);
            jTxt.setEditable(false);
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }
    }
}

