/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base4.swing;

import com.runqian.base4.swing.JTableEx;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;

public class JTextAreaEditor
extends DefaultCellEditor
implements MouseListener {
    public static final int TYPE_SIGNED_DOUBLE = 6;
    public static final int TYPE_SIGNED_INTEGER = 4;
    public static final int TYPE_TEXT_SIMPLE = 1;
    public static final int TYPE_TEXT_WRAP = 2;
    public static final int TYPE_UNSIGNED_DOUBLE = 5;
    public static final int TYPE_UNSIGNED_INTEGER = 3;
    int editorType;
    JScrollPane jsp;
    JTableEx parent;
    JSpinner sInteger = null;
    JSpinner sNumber = null;
    JTextField textSimple = null;
    JTextPane textWrap = null;
    JSpinner uInteger = null;
    JSpinner uNumber = null;
    Object value = null;

    public JTextAreaEditor(JTableEx parent, int editorType) {
        super(new JTextField(""));
        this.editorType = editorType;
        this.parent = parent;
        switch (editorType) {
            case 2: {
                this.textWrap = new JTextPane();
                this.textWrap.addMouseListener(this);
                this.textWrap.setBorder(BorderFactory.createEmptyBorder());
                this.jsp = new JScrollPane(this.textWrap);
                break;
            }
            case 4: {
                this.sInteger = new JSpinner();
                this.sInteger.addMouseListener(this);
                SpinnerNumberModel smodel = new SpinnerNumberModel(1, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
                this.sInteger.setModel(smodel);
                this.sInteger.setBorder(BorderFactory.createEmptyBorder());
                break;
            }
            case 3: {
                this.uInteger = new JSpinner();
                this.uInteger.addMouseListener(this);
                SpinnerNumberModel model = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
                this.uInteger.setModel(model);
                this.uInteger.setBorder(BorderFactory.createEmptyBorder());
                break;
            }
            case 5: {
                this.textSimple = new JTextField("");
                this.textSimple.setBorder(BorderFactory.createEmptyBorder());
                break;
            }
            case 6: {
                this.sNumber = new JSpinner();
                this.sInteger.addMouseListener(this);
                SpinnerNumberModel snmodel = new SpinnerNumberModel(1.0, Double.MIN_VALUE, Double.MAX_VALUE, 1.0);
                this.sNumber.setModel(snmodel);
                this.sNumber.setBorder(BorderFactory.createEmptyBorder());
                break;
            }
            default: {
                this.textSimple = new JTextField("");
                this.textSimple.addMouseListener(this);
                this.textSimple.setBorder(BorderFactory.createEmptyBorder());
            }
        }
        this.setClickCountToStart(1);
    }

    public JTextAreaEditor(JTableEx parent) {
        this(parent, 1);
    }

    public Object getCellEditorValue() {
        switch (this.editorType) {
            case 2: {
                this.value = this.textWrap.getText();
                break;
            }
            case 4: {
                this.value = this.sInteger.getValue();
                break;
            }
            case 3: {
                this.value = this.uInteger.getValue();
                break;
            }
            case 5: {
                this.value = this.textSimple.getText();
                break;
            }
            case 6: {
                this.value = this.sNumber.getValue();
                break;
            }
            default: {
                this.value = this.textSimple.getText();
            }
        }
        return this.value;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.setValue(value);
    }

    public void mouseClicked(MouseEvent e) {
        JComponent editor = (JComponent)e.getSource();
        Container ct = editor.getTopLevelAncestor();
        int absoluteX = e.getX() + editor.getX();
        int absoluteY = e.getY() + editor.getY();
        Container p = editor.getParent();
        while (p != ct) {
            absoluteX += p.getX();
            absoluteY += p.getY();
            p = p.getParent();
        }
        this.parent.fireClicked(absoluteX, absoluteY, e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public Component setValue(Object value) {
        JComponent o;
        switch (this.editorType) {
            case 2: {
                if (value == null) {
                    this.textWrap.setText("");
                } else {
                    this.textWrap.setText(value.toString());
                }
                o = this.jsp;
                break;
            }
            case 4: {
                if (value == null || !(value instanceof Integer)) {
                    this.sInteger.setValue(new Integer(0));
                } else {
                    this.sInteger.setValue(value);
                }
                o = this.sInteger;
                break;
            }
            case 3: {
                if (value == null || !(value instanceof Integer)) {
                    this.uInteger.setValue(new Integer(0));
                } else {
                    this.uInteger.setValue(value);
                }
                o = this.uInteger;
                break;
            }
            case 5: {
                if (value == null) {
                    this.textSimple.setText("");
                } else {
                    this.textSimple.setText(value.toString());
                }
                o = this.textSimple;
                break;
            }
            case 6: {
                if (value == null || !(value instanceof Double)) {
                    this.sNumber.setValue(new Double(0.0));
                } else {
                    this.sNumber.setValue(value);
                }
                o = this.sNumber;
                break;
            }
            default: {
                if (value == null) {
                    this.textSimple.setText("");
                } else {
                    this.textSimple.setText(value.toString());
                }
                o = this.textSimple;
            }
        }
        return o;
    }
}

