/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base4.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MemoryMonitor
extends JPanel {
    JPanel controls;
    static JCheckBox dateStampCB = new JCheckBox("Output Date Stamp");
    boolean doControls;
    public Surface surf;
    JTextField tf;

    public MemoryMonitor() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), "Memory Monitor"));
        this.surf = new Surface();
        this.add(this.surf);
        this.controls = new JPanel();
        this.controls.setPreferredSize(new Dimension(135, 80));
        Font font = new Font("serif", 0, 10);
        JLabel label = new JLabel("Sample Rate");
        label.setFont(font);
        label.setForeground(Color.black);
        this.controls.add(label);
        this.tf = new JTextField("1000");
        this.tf.setPreferredSize(new Dimension(45, 20));
        this.controls.add(this.tf);
        label = new JLabel("ms");
        this.controls.add(label);
        label.setFont(font);
        label.setForeground(Color.black);
        this.controls.add(dateStampCB);
        dateStampCB.setFont(font);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MemoryMonitor.this.removeAll();
                MemoryMonitor.this.doControls = !MemoryMonitor.this.doControls;
                if (MemoryMonitor.this.doControls) {
                    MemoryMonitor.this.surf.stop();
                    MemoryMonitor.this.add(MemoryMonitor.this.controls);
                } else {
                    try {
                        MemoryMonitor.this.surf.sleepAmount = Long.parseLong(MemoryMonitor.this.tf.getText().trim());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    MemoryMonitor.this.surf.start();
                    MemoryMonitor.this.add(MemoryMonitor.this.surf);
                }
                MemoryMonitor.this.validate();
                MemoryMonitor.this.repaint();
            }
        });
    }

    public static void main(String[] s) {
        final MemoryMonitor demo = new MemoryMonitor();
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            public void windowDeiconified(WindowEvent e) {
                demo.surf.start();
            }

            public void windowIconified(WindowEvent e) {
                demo.surf.stop();
            }
        };
        JFrame f = new JFrame("Java2D Demo - MemoryMonitor");
        f.addWindowListener(l);
        f.getContentPane().add("Center", demo);
        f.pack();
        f.setSize(new Dimension(200, 200));
        f.setVisible(true);
        demo.surf.start();
    }

    public class Surface
    extends JPanel
    implements Runnable {
        private int ascent;
        private Graphics2D big;
        private BufferedImage bimg;
        private int columnInc;
        private int descent;
        private Font font = new Font("Times New Roman", 0, 11);
        private float freeMemory;
        private Color graphColor;
        private Line2D graphLine;
        private Rectangle graphOutlineRect;
        private int h;
        private Color mfColor;
        private Rectangle2D mfRect;
        private Rectangle2D muRect;
        private int ptNum;
        private int[] pts;
        private Runtime r = Runtime.getRuntime();
        public long sleepAmount = 1000L;
        public Thread thread;
        private float totalMemory;
        private String usedStr;
        private int w;

        public Surface() {
            this.graphOutlineRect = new Rectangle();
            this.mfRect = new Rectangle2D.Float();
            this.muRect = new Rectangle2D.Float();
            this.graphLine = new Line2D.Float();
            this.graphColor = new Color(46, 139, 87);
            this.mfColor = new Color(0, 100, 0);
            this.setBackground(Color.black);
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Surface this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseClicked(MouseEvent e) {
                    if (this.this$1.thread == null) {
                        this.this$1.start();
                    } else {
                        this.this$1.stop();
                    }
                }
            });
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(135, 80);
        }

        public void paint(Graphics g) {
            if (this.big == null) {
                return;
            }
            this.big.setBackground(this.getBackground());
            this.big.clearRect(0, 0, this.w, this.h);
            float freeMemory = this.r.freeMemory();
            float totalMemory = this.r.totalMemory();
            this.big.setColor(Color.green);
            this.big.drawString(String.valueOf((int)totalMemory / 1024) + "K allocated", 4.0f, (float)this.ascent + 0.5f);
            this.usedStr = String.valueOf((int)(totalMemory - freeMemory) / 1024) + "K used";
            this.big.drawString(this.usedStr, 4, this.h - this.descent);
            float ssH = this.ascent + this.descent;
            float remainingHeight = (float)this.h - ssH * 2.0f - 0.5f;
            float blockHeight = remainingHeight / 10.0f;
            float blockWidth = 20.0f;
            float remainingWidth = (float)this.w - blockWidth - 10.0f;
            this.big.setColor(this.mfColor);
            int MemUsage = (int)(freeMemory / totalMemory * 10.0f);
            int i = 0;
            while (i < MemUsage) {
                this.mfRect.setRect(5.0, ssH + (float)i * blockHeight, blockWidth, blockHeight - 1.0f);
                this.big.fill(this.mfRect);
                ++i;
            }
            this.big.setColor(Color.green);
            while (i < 10) {
                this.muRect.setRect(5.0, ssH + (float)i * blockHeight, blockWidth, blockHeight - 1.0f);
                this.big.fill(this.muRect);
                ++i;
            }
            this.big.setColor(this.graphColor);
            int graphX = 30;
            int graphY = (int)ssH;
            int graphW = this.w - graphX - 5;
            int graphH = (int)remainingHeight;
            this.graphOutlineRect.setRect(graphX, graphY, graphW, graphH);
            this.big.draw(this.graphOutlineRect);
            int graphRow = graphH / 10;
            int j = graphY;
            while (j <= graphH + graphY) {
                this.graphLine.setLine(graphX, j, graphX + graphW, j);
                this.big.draw(this.graphLine);
                j += graphRow;
            }
            int graphColumn = graphW / 15;
            if (this.columnInc == 0) {
                this.columnInc = graphColumn;
            }
            int j2 = graphX + this.columnInc;
            while (j2 < graphW + graphX) {
                this.graphLine.setLine(j2, graphY, j2, graphY + graphH);
                this.big.draw(this.graphLine);
                j2 += graphColumn;
            }
            --this.columnInc;
            if (this.pts == null) {
                this.pts = new int[graphW];
                this.ptNum = 0;
            } else if (this.pts.length != graphW) {
                int[] tmp = null;
                if (this.ptNum < graphW) {
                    tmp = new int[this.ptNum];
                    System.arraycopy(this.pts, 0, tmp, 0, tmp.length);
                } else {
                    tmp = new int[graphW];
                    System.arraycopy(this.pts, this.pts.length - tmp.length, tmp, 0, tmp.length);
                    this.ptNum = tmp.length - 2;
                }
                this.pts = new int[graphW];
                System.arraycopy(tmp, 0, this.pts, 0, tmp.length);
            } else {
                this.big.setColor(Color.yellow);
                this.pts[this.ptNum] = (int)((float)graphY + (float)graphH * (freeMemory / totalMemory));
                int j3 = graphX + graphW - this.ptNum;
                int k = 0;
                while (k < this.ptNum) {
                    if (k != 0) {
                        if (this.pts[k] != this.pts[k - 1]) {
                            this.big.drawLine(j3 - 1, this.pts[k - 1], j3, this.pts[k]);
                        } else {
                            this.big.fillRect(j3, this.pts[k], 1, 1);
                        }
                    }
                    ++k;
                    ++j3;
                }
                if (this.ptNum + 2 == this.pts.length) {
                    int j4 = 1;
                    while (j4 < this.ptNum) {
                        this.pts[j4 - 1] = this.pts[j4];
                        ++j4;
                    }
                    --this.ptNum;
                } else {
                    ++this.ptNum;
                }
            }
            g.drawImage(this.bimg, 0, 0, this);
        }

        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me && !this.isShowing() || this.getSize().width == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            while (this.thread == me && this.isShowing()) {
                Dimension d = this.getSize();
                if (d.width != this.w || d.height != this.h) {
                    this.w = d.width;
                    this.h = d.height;
                    this.bimg = (BufferedImage)this.createImage(this.w, this.h);
                    this.big = this.bimg.createGraphics();
                    this.big.setFont(this.font);
                    FontMetrics fm = this.big.getFontMetrics(this.font);
                    this.ascent = fm.getAscent();
                    this.descent = fm.getDescent();
                }
                this.repaint();
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (!dateStampCB.isSelected()) continue;
                System.out.println(new Date().toString() + " " + this.usedStr);
            }
            this.thread = null;
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("MemoryMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.notify();
        }
    }
}

