/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base4.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;

public class DBTypes {
    public static final int UNKNOWN = 0;
    public static final int ORACLE = 1;
    public static final int SQLSVR = 2;
    public static final int SYBASE = 3;
    public static final int SQLANY = 4;
    public static final int INFMIX = 5;
    public static final int FOXPRO = 6;
    public static final int ACCESS = 7;
    public static final int FOXBAS = 8;
    public static final int DB2 = 9;
    public static final int MYSQL = 10;
    public static final int KINGBASE = 11;
    public static final int DERBY = 12;
    public static final int OLAP = 100;
    public static final int ESSBASE = 101;
    protected static final int[] dbTypes;
    protected static final String[] dbNames;
    protected static final int[] mdbTypes;
    protected static final String[] mdbNames;

    static {
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        dbTypes = nArray;
        dbNames = new String[]{"UNKNOWN", "ORACLE", "SQLSVR", "SYBASE", "SQLANY", "INFMIX", "FOXPRO", "ACCESS", "FOXBAS", "DB2", "MYSQL", "KINGBASE", "DERBY"};
        mdbTypes = new int[]{101};
        mdbNames = new String[]{"ESSBASE"};
    }

    public static String addQuotation(int n, String string) {
        if (string == null || string.length() == 0) {
            return "null";
        }
        char c = '\'';
        if (n == 5 || n == 6 || n == 8) {
            c = '\"';
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 10);
        stringBuffer.append(c);
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 == c) {
                stringBuffer.append(c2);
            }
            stringBuffer.append(c2);
            ++n3;
        }
        stringBuffer.append(c);
        return stringBuffer.toString();
    }

    public static String getCharConst(int n, String string) {
        return DBTypes.addQuotation(n, string);
    }

    public static String getDBConst(int n, Object object, int n2) {
        if (object == null) {
            return "null";
        }
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                return DBTypes.getCharConst(n, object.toString());
            }
            case 91: {
                return DBTypes.getDateConst(n, object.toString());
            }
            case 92: {
                if (object instanceof Time) {
                    DateFormat dateFormat = DateFormat.getTimeInstance(2);
                    object = dateFormat.format(object);
                }
                return DBTypes.getTimeConst(n, object.toString());
            }
            case 93: {
                if (object instanceof Timestamp) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
                    object = dateFormat.format(object);
                }
                return DBTypes.getTimestampConst(n, object.toString());
            }
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                String string = object.toString();
                if (string.length() == 0) {
                    return "null";
                }
                return string;
            }
        }
        System.out.println("The column dataType is " + n2);
        throw new IllegalArgumentException();
    }

    public static int getDBType(String string) {
        if (string == null) {
            return 0;
        }
        String string2 = string.trim();
        int n = 0;
        while (n < dbNames.length) {
            if (dbNames[n].equalsIgnoreCase(string2)) {
                return dbTypes[n];
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < mdbNames.length) {
            if (mdbNames[n2].equalsIgnoreCase(string2)) {
                return mdbTypes[n2];
            }
            ++n2;
        }
        return 0;
    }

    public static String getDBTypeName(int n) {
        int n2 = 0;
        while (n2 < dbTypes.length) {
            if (n == dbTypes[n2]) {
                return dbNames[n2];
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < mdbTypes.length) {
            if (n == mdbTypes[n3]) {
                return mdbNames[n3];
            }
            ++n3;
        }
        return dbNames[0];
    }

    public static String getDateConst(int n, String string) {
        if (string == null || string.length() == 0) {
            return "null";
        }
        switch (n) {
            case 1: {
                return "to_date('" + string + "','yyyy-mm-dd')";
            }
        }
        return "'" + string + "'";
    }

    public static char getQuotation(int n) {
        if (n == 5 || n == 6 || n == 7 || n == 8) {
            return '\"';
        }
        return '\'';
    }

    public static String getTimeConst(int n, String string) {
        if (string == null || string.length() == 0) {
            return "null";
        }
        switch (n) {
            case 1: {
                return "to_date('" + string + "','hh24:mi:ss')";
            }
        }
        return "'" + string + "'";
    }

    public static String getTimestampConst(int n, String string) {
        if (string == null || string.length() == 0) {
            return "null";
        }
        switch (n) {
            case 1: {
                return "to_date('" + string + "','yyyy-mm-dd hh24:mi:ss')";
            }
        }
        return "'" + string + "'";
    }

    public static String[] listSupportDBNames() {
        String[] stringArray = new String[dbNames.length - 1];
        int n = 1;
        while (n < dbNames.length) {
            stringArray[n - 1] = dbNames[n];
            ++n;
        }
        return stringArray;
    }
}

