/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.base4.util;

import com.runqian.base4.util.GifEncoder;
import com.runqian.base4.util.StringUtils;
import com.sun.media.jai.codec.BMPEncodeParam;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.PNGEncodeParam;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.ImageIcon;

public class ImageUtils {
    private static float _$1 = 0.9f;
    private static int _$2 = 11812;
    private static int _$3 = 11812;
    static /* synthetic */ Class class$com$runqian$base4$util$ImageUtils;

    static {
        try {
            Properties properties = new Properties();
            String string = "/com/runqian/base4/util/util.properties";
            InputStream inputStream = (class$com$runqian$base4$util$ImageUtils != null ? class$com$runqian$base4$util$ImageUtils : (class$com$runqian$base4$util$ImageUtils = ImageUtils.class$("com.runqian.base4.util.ImageUtils"))).getResourceAsStream(string);
            properties.load(inputStream);
            inputStream.close();
            String string2 = properties.getProperty("jpg.quality");
            if (!StringUtils.isSpaceString(string2)) {
                _$1 = Float.parseFloat(string2);
            }
            if (!StringUtils.isSpaceString(string2 = properties.getProperty("png.hsampling"))) {
                _$2 = (int)((double)(Integer.parseInt(string2) * 1000) / 25.4 + 1.0);
            }
            if (!StringUtils.isSpaceString(string2 = properties.getProperty("png.vsampling"))) {
                _$3 = (int)((double)(Integer.parseInt(string2) * 1000) / 25.4 + 1.0);
            }
        }
        catch (Throwable throwable) {}
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = ImageUtils.hasAlpha(image);
        int n = 1;
        if (bl) {
            n = 2;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage toBufferedImage(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            return (BufferedImage)renderedImage;
        }
        boolean bl = renderedImage.getColorModel().hasAlpha();
        int n = 1;
        if (bl) {
            n = 2;
        }
        BufferedImage bufferedImage = new BufferedImage(renderedImage.getWidth(), renderedImage.getHeight(), n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawRenderedImage(renderedImage, new AffineTransform());
        graphics2D.dispose();
        return bufferedImage;
    }

    public static byte[] writeBMP(RenderedImage renderedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        ImageUtils.writeBMP(renderedImage, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeBMP(RenderedImage renderedImage, OutputStream outputStream) throws IOException {
        BMPEncodeParam bMPEncodeParam = new BMPEncodeParam();
        ImageEncoder imageEncoder = ImageCodec.createImageEncoder((String)"BMP", (OutputStream)outputStream, (ImageEncodeParam)bMPEncodeParam);
        imageEncoder.encode(renderedImage);
    }

    public static byte[] writeGIF(Image image) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        ImageUtils.writeGIF(image, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeGIF(Image image, OutputStream outputStream) throws IOException {
        GifEncoder gifEncoder = new GifEncoder(image, outputStream);
        gifEncoder.encode();
    }

    public static byte[] writeJPEG(RenderedImage renderedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        ImageUtils.writeJPEG(renderedImage, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeJPEG(RenderedImage renderedImage, OutputStream outputStream) throws IOException {
        JPEGEncodeParam jPEGEncodeParam = new JPEGEncodeParam();
        jPEGEncodeParam.setQuality(_$1);
        ImageEncoder imageEncoder = ImageCodec.createImageEncoder((String)"JPEG", (OutputStream)outputStream, (ImageEncodeParam)jPEGEncodeParam);
        imageEncoder.encode(renderedImage);
    }

    public static byte[] writePNG(RenderedImage renderedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        ImageUtils.writePNG(renderedImage, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void writePNG(RenderedImage renderedImage, OutputStream outputStream) throws IOException {
        PNGEncodeParam pNGEncodeParam = PNGEncodeParam.getDefaultEncodeParam((RenderedImage)renderedImage);
        pNGEncodeParam.setPhysicalDimension(_$2, _$3, 1);
        ImageEncoder imageEncoder = ImageCodec.createImageEncoder((String)"PNG", (OutputStream)outputStream, (ImageEncodeParam)pNGEncodeParam);
        imageEncoder.encode(renderedImage);
    }
}

