/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.base;

import com.runqian.base4.tool.AppMenu;
import com.runqian.base4.tool.DialogConsole;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.datamanager.dialog.DialogCreateTables;
import com.runqian.datamanager.dialog.DialogDataBackup;
import com.runqian.datamanager.dialog.DialogDataRecover;
import com.runqian.datamanager.dialog.DialogRegistTables;
import com.runqian.datamanager.ide.GVData;
import com.runqian.report4.ide.base.ConfigOptions;
import com.runqian.report4.ide.dialog.DialogAbout;
import com.runqian.report4.ide.dialog.DialogDataSource;
import com.runqian.report4.ide.dialog.DialogMemory;
import com.runqian.report4.ide.dialog.DialogOptions;
import com.runqian.report4.remote.LogInfo;
import com.runqian.report4.remote.dialog.DialogLogin;
import com.runqian.report4.remote.dialog.DialogRemoteOpen;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class MenuFactory
extends AppMenu {
    public static JMenu baseSystemMenu;
    public static JMenu helpMenu;
    private static ActionListener menuAction;
    public static JCheckBoxMenuItem menuUseEditStyle;
    public static JMenu recentConn;
    public static JMenu recentFile;
    public static JMenu remoteMenu;
    private static JMenuItem remoteSaveas;
    public static JMenu systemMenu;
    private static HashSet tmpLiveMenuItems;
    public static JMenu windowMenu;

    static {
        tmpLiveMenuItems = new HashSet();
        menuAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem mi = (JMenuItem)e.getSource();
                String menuId = mi.getName();
                short cmdId = Short.parseShort(menuId);
                MenuFactory.executeCmd(cmdId);
            }
        };
    }

    public JMenuItem cloneMenuItem(short cmdId) {
        JMenuItem mItem = new JMenuItem();
        JMenuItem jmi = (JMenuItem)AppMenu.menuItems.get(cmdId);
        String text = jmi.getText();
        int pos = text.indexOf("(");
        if (pos > 0) {
            text = text.substring(0, pos);
        }
        mItem.setText(text);
        short cmd = Short.parseShort(jmi.getName());
        mItem.setName(Integer.toString(cmd + 10000));
        mItem.setIcon(jmi.getIcon());
        mItem.setVisible(jmi.isVisible());
        mItem.setEnabled(jmi.isEnabled());
        mItem.setAccelerator(jmi.getAccelerator());
        mItem.addActionListener(menuAction);
        return mItem;
    }

    public static void executeCmd(short cmdId) {
        try {
            switch (cmdId) {
                case 5005: {
                    GV.appFrame.openSemantic("");
                    break;
                }
                case 5010: {
                    File file = GM.dialogSelectFile("xml");
                    if (file != null) {
                        String filePath = file.getAbsolutePath();
                        GV.appFrame.openSemantic(filePath);
                    }
                    break;
                }
                case 5020: {
                    GVData.activeSheet.save();
                    break;
                }
                case 5025: {
                    GVData.activeSheet.saveAs();
                    break;
                }
                case 5504: {
                    GVData.activeSheet.remoteSaveAs();
                    break;
                }
                case 5030: {
                    GVData.getFrameManager().closeSheet(GVData.activeSheet);
                    break;
                }
                case 5060: {
                    GVData.getFrameManager().quit();
                    break;
                }
                case 630: {
                    new DialogConsole((Frame)GV.appFrame, GV.consoleTextArea).show();
                    break;
                }
                case 1005: {
                    new DialogAbout().show();
                    break;
                }
                case 1010: {
                    if (GV.dialogMemory == null) {
                        GV.dialogMemory = new DialogMemory();
                    }
                    GV.dialogMemory.show();
                    break;
                }
                case 905: 
                case 910: 
                case 915: 
                case 920: {
                    GV.appFrame.arrangeSheet(cmdId);
                    break;
                }
                case 5401: {
                    DialogDataSource dds = new DialogDataSource(GV.dsModel);
                    dds.show();
                    break;
                }
                case 5425: {
                    new DialogOptions().show();
                    break;
                }
                case 5405: {
                    DialogCreateTables dct = new DialogCreateTables();
                    dct.setViewManager(GVData.activeSheet.getViewManager());
                    dct.show();
                    break;
                }
                case 5410: {
                    DialogRegistTables drt = new DialogRegistTables();
                    drt.setViewManager(GVData.activeSheet.getViewManager());
                    drt.show();
                    break;
                }
                case 5415: {
                    DialogDataBackup ddb = new DialogDataBackup();
                    ddb.setViewManager(GVData.activeSheet.getViewManager());
                    ddb.show();
                    break;
                }
                case 5420: {
                    DialogDataRecover ddr = new DialogDataRecover();
                    ddr.setViewManager(GVData.activeSheet.getViewManager());
                    ddr.show();
                    break;
                }
                case 5501: {
                    new DialogLogin().show();
                    break;
                }
                case 5502: {
                    if (GV.remoteLogout()) {
                        GV.appMenu.setEnable(new short[]{5502, 5503, 5504}, false);
                        if (GVData.activeSheet != null) {
                            GVData.getFrameManager().closeSheet(GVData.activeSheet);
                        }
                    }
                    break;
                }
                case 5503: {
                    new DialogRemoteOpen(DialogRemoteOpen.T_OPENSEMANTIC).show();
                    break;
                }
                default: {
                    GVData.activeSheet.executeCmd(cmdId);
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static JMenu getBaseSystemMenu() {
        if (baseSystemMenu != null) {
            return baseSystemMenu;
        }
        JMenu menu = new JMenu();
        menu = GV.getMenuItem(true, "system", 'S');
        menu.add(MenuFactory.newMenuItem((short)5401, "system.dataSource", 'S', Boolean.FALSE, true));
        menu.addSeparator();
        menu.add(MenuFactory.newMenuItem((short)5425, "system.options", 'O', Boolean.FALSE, true));
        if (ConfigOptions.bIdeConsole.booleanValue()) {
            menu.add(MenuFactory.newMenuItem((short)630, "system.console", 'A', Boolean.FALSE));
        }
        baseSystemMenu = menu;
        return menu;
    }

    public static JMenu getHelperMenu() {
        if (helpMenu != null) {
            return helpMenu;
        }
        JMenu menu = new JMenu();
        menu = GV.getMenuItem(true, "help", 'H');
        menu.add(MenuFactory.newMenuItem((short)1005, "help.about", 'A', Boolean.FALSE, true));
        menu.add(MenuFactory.newMenuItem((short)1010, "help.memoryTidy", 'G', Boolean.FALSE));
        helpMenu = menu;
        return menu;
    }

    public static JMenu getRemoteMenu(boolean isBase) {
        if (remoteMenu != null) {
            if (isBase) {
                remoteSaveas.setVisible(false);
            } else {
                remoteSaveas.setVisible(true);
            }
            return remoteMenu;
        }
        JMenu menu = new JMenu();
        menu = GV.getMenuItem(true, "remote", 'R');
        menu.add(MenuFactory.newMenuItem((short)5501, "remote.login", 'I', Boolean.FALSE, true));
        menu.add(MenuFactory.newMenuItem((short)5502, "remote.logout", 'T', Boolean.FALSE, true));
        menu.add(MenuFactory.newMenuItem((short)5503, "remote.open", 'O', Boolean.FALSE, true));
        remoteSaveas = MenuFactory.newMenuItem((short)5504, "remote.saveas", 'A', Boolean.FALSE);
        if (isBase) {
            remoteSaveas.setVisible(false);
        } else {
            remoteSaveas.setVisible(true);
        }
        menu.add(remoteSaveas);
        remoteMenu = menu;
        return menu;
    }

    public static JMenu getSystemMenu() {
        if (systemMenu != null) {
            return systemMenu;
        }
        JMenu menu = new JMenu();
        menu = GV.getMenuItem(true, "system", 'S');
        menu.add(MenuFactory.newMenuItem((short)5401, "system.dataSource", 'S', Boolean.FALSE, true));
        menu.addSeparator();
        menu.add(MenuFactory.newMenuItem((short)5405, "system.tablemanager", 'T', Boolean.FALSE, true));
        menu.add(MenuFactory.newMenuItem((short)5410, "system.tableregister", 'R', Boolean.FALSE));
        menu.add(MenuFactory.newMenuItem((short)5415, "system.databackup", 'B', Boolean.FALSE));
        menu.add(MenuFactory.newMenuItem((short)5420, "system.datarecover", 'H', Boolean.FALSE));
        menu.addSeparator();
        menu.add(MenuFactory.newMenuItem((short)5425, "system.options", 'O', Boolean.FALSE, true));
        if (ConfigOptions.bIdeConsole.booleanValue()) {
            menu.add(MenuFactory.newMenuItem((short)630, "system.console", 'A', Boolean.FALSE));
        }
        menuUseEditStyle = new JCheckBoxMenuItem(Lang.get((byte)1, "useeditstyle"));
        menu.add(menuUseEditStyle);
        menuUseEditStyle.setSelected(ConfigOptions.bUseEditStyle);
        systemMenu = menu;
        return menu;
    }

    public static JMenu getWindowMenu() {
        if (windowMenu != null) {
            return windowMenu;
        }
        JMenu menu = new JMenu();
        menu = GV.getMenuItem(true, "window", 'W');
        menu.add(MenuFactory.newMenuItem((short)905, "window.cascade", 'C', Boolean.FALSE, true));
        menu.add(MenuFactory.newMenuItem((short)910, "window.tileHorizontal", 'H', Boolean.FALSE));
        menu.add(MenuFactory.newMenuItem((short)915, "window.tileVertical", 'V', Boolean.FALSE));
        menu.add(MenuFactory.newMenuItem((short)920, "window.layer", 'L', Boolean.FALSE));
        windowMenu = menu;
        return menu;
    }

    public static JMenuItem newMenuItem(short cmdId, String menuId, char mneKey, Boolean accelerator, boolean hasIcon) {
        JMenuItem mItem = GV.getMenuItem(cmdId, menuId, mneKey, accelerator, hasIcon);
        mItem.addActionListener(menuAction);
        AppMenu.menuItems.put(cmdId, mItem);
        return mItem;
    }

    public static JMenuItem newMenuItem(short cmdId, String menuId, char mneKey, Boolean accelerator) {
        return MenuFactory.newMenuItem(cmdId, menuId, mneKey, accelerator, false);
    }

    public void resetLiveMenu() {
        AppMenu.liveMenuItems = tmpLiveMenuItems;
        AppMenu.liveMenu = this.tmpLiveMenu;
    }

    public void resetPrivilegeMenu() {
        if (LogInfo.privilege == 0) {
            GV.appMenu.setEnable(new short[]{5502, 5503, 5504}, false);
        } else if (LogInfo.privilege != 0) {
            GV.appMenu.setEnable(new short[]{5502}, true);
            GV.appMenu.setEnable(new short[]{5503}, LogInfo.canOpenSemantic());
            GV.appMenu.setEnable(new short[]{5504}, LogInfo.canSaveAsSemantic());
        }
    }
}

