/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.base;

import com.runqian.base4.swing.JTableEx;
import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.tool.Section;
import com.runqian.report4.ide.base.Maps;
import com.runqian.report4.ide.base.TypesEx;
import com.runqian.report4.ide.dialog.DialogCellFormat;
import com.runqian.report4.semantics.OuterParam;
import com.runqian.report4.semantics.ParamList;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JScrollPane;

public abstract class TableOuterParam
extends JScrollPane {
    final byte COL_DATATYPE = 3;
    final byte COL_DESC = (byte)2;
    final byte COL_EDITSTYLE = 10;
    final byte COL_FORMAT = 7;
    final byte COL_INDEX = 0;
    final byte COL_NAME = 1;
    final byte COL_NULLABLE = 6;
    final byte COL_PARATYPE = 9;
    final byte COL_PRECISION = 4;
    final byte COL_SCALE = 5;
    final byte COL_VALUE = 8;
    String colNames;
    private boolean isDataChanged;
    boolean preventChange = false;
    JTableEx tableParam;

    public TableOuterParam() {
        this.COL_DATATYPE = (byte)3;
        this.COL_PRECISION = (byte)4;
        this.COL_SCALE = (byte)5;
        this.COL_NULLABLE = (byte)6;
        this.COL_FORMAT = (byte)7;
        this.COL_VALUE = (byte)8;
        this.COL_PARATYPE = (byte)9;
        this.COL_EDITSTYLE = (byte)10;
        this.colNames = Lang.getText("tableouterparam.colnames");
        this.tableParam = new JTableEx(this.colNames){

            public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
                if (col == 7) {
                    DialogCellFormat dcf = new DialogCellFormat();
                    String fmt = (String)this.data.getValueAt(row, col);
                    dcf.setFormat(fmt);
                    dcf.show();
                    this.acceptText();
                    if (dcf.getOption() == 0) {
                        this.setValueAt(dcf.getFormat(), row, col);
                        this.acceptText();
                    }
                } else {
                    GM.dialogEditTableText(TableOuterParam.this.tableParam, row, col);
                }
            }

            public void setValueAt(Object aValue, int row, int column) {
                if (!this.isItemDataChanged(row, column, aValue)) {
                    return;
                }
                super.setValueAt(aValue, row, column);
                TableOuterParam.this.setChanged();
            }
        };
        try {
            this.jbInit();
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addRow() {
        String name = GM.getTableUniqueName(this.tableParam, 1, "arg");
        int r = this.tableParam.addRow();
        this.tableParam.clearSelection();
        this.tableParam.selectRow(r);
        this.tableParam.data.setValueAt(name, r, 1);
        this.tableParam.data.setValueAt(name, r, 2);
        this.tableParam.data.setValueAt(new Byte(11), r, 3);
        this.tableParam.data.setValueAt(new Integer(8), r, 4);
        this.tableParam.data.setValueAt(new Integer(3), r, 5);
        this.tableParam.data.setValueAt(Boolean.FALSE, r, 6);
        this.tableParam.data.setValueAt(new Byte(0), r, 9);
    }

    public boolean checkData() {
        this.tableParam.acceptText();
        return this.tableParam.checkColumnData(1, Lang.getText("tableouterparam.paramname"));
    }

    public void clipBoard() {
        String blockData = this.tableParam.getBlockData();
        GM.clipBoard(blockData);
    }

    public void deleteRows() {
        this.tableParam.deleteSelectedRows();
    }

    public abstract void editChanged();

    public ParamList getOuterParams() {
        this.isDataChanged = false;
        this.tableParam.acceptText();
        if (this.tableParam.getRowCount() == 0) {
            return null;
        }
        ParamList pl = new ParamList();
        int i = 0;
        while (i < this.tableParam.getRowCount()) {
            OuterParam op = new OuterParam();
            op.setParamName((String)this.tableParam.data.getValueAt(i, 1));
            op.setDescription((String)this.tableParam.data.getValueAt(i, 2));
            op.setDataType((Byte)this.tableParam.data.getValueAt(i, 3));
            op.setPrecision(((Number)this.tableParam.data.getValueAt(i, 4)).shortValue());
            op.setScale(((Number)this.tableParam.data.getValueAt(i, 5)).shortValue());
            op.setNullable((Boolean)this.tableParam.data.getValueAt(i, 6));
            op.setFormat((String)this.tableParam.data.getValueAt(i, 7));
            op.setValue((String)this.tableParam.data.getValueAt(i, 8));
            op.setParamType(((Number)this.tableParam.data.getValueAt(i, 9)).byteValue());
            op.setEditStyleName((String)this.tableParam.data.getValueAt(i, 10));
            pl.addParam(op);
            ++i;
        }
        return pl;
    }

    private void init() {
        this.preventChange = true;
        this.tableParam.setSelectionMode(0);
        this.tableParam.setRowHeight(20);
        this.tableParam.setAutoResizeMode(0);
        this.tableParam.getTableHeader().setReorderingAllowed(false);
        this.tableParam.setIndexCol(0);
        this.tableParam.setColumnDropDown(3, TypesEx.listCodeTypes(false), TypesEx.listDispTypes(false));
        this.tableParam.setColumnDropDown(9, Maps.paraTypeCode(), Maps.paraTypeDisp());
        this.tableParam.setColumnCheckBox(6);
        this.tableParam.setColumnSpinner(4);
        this.tableParam.setColumnWidth(4, 40);
        this.tableParam.setColumnSpinner(5);
        this.tableParam.setColumnWidth(5, 40);
        this.tableParam.setClickCountToStart(1);
        this.preventChange = false;
    }

    public boolean isDataChanged() {
        return this.isDataChanged;
    }

    void jbInit() throws Exception {
        this.getViewport().add(this.tableParam);
    }

    public void paste() {
    }

    private void setChanged() {
        if (this.preventChange) {
            return;
        }
        this.isDataChanged = true;
        this.editChanged();
    }

    public void setOuterParams(ParamList pl, String[] editStyles) {
        this.tableParam.data.setRowCount(0);
        Vector code = new Section(editStyles).toVector();
        this.tableParam.setColumnDropDown(10, code, code);
        if (pl == null) {
            return;
        }
        this.preventChange = true;
        int i = 0;
        while (i < pl.getParamCount()) {
            OuterParam op = pl.getParam(i);
            this.tableParam.addRow();
            this.tableParam.data.setValueAt(op.getParamName(), i, 1);
            this.tableParam.data.setValueAt(op.getDescription(), i, 2);
            this.tableParam.data.setValueAt(new Byte(op.getDataType()), i, 3);
            this.tableParam.data.setValueAt(new Integer(op.getPrecision()), i, 4);
            this.tableParam.data.setValueAt(new Integer(op.getScale()), i, 5);
            this.tableParam.data.setValueAt(new Boolean(op.isNullable()), i, 6);
            this.tableParam.data.setValueAt(op.getFormat(), i, 7);
            this.tableParam.data.setValueAt(op.getValue(), i, 8);
            this.tableParam.data.setValueAt(new Byte(op.getParamType()), i, 9);
            this.tableParam.data.setValueAt(op.getEditStyleName(), i, 10);
            ++i;
        }
        this.preventChange = false;
    }
}

