/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.datawindow;

import com.runqian.datamanager.datawindow.ColHeaderListener;
import com.runqian.datamanager.datawindow.DWColInfo;
import com.runqian.datamanager.datawindow.DWUtils;
import com.runqian.datamanager.datawindow.DataWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

class ColHeader
extends JPanel {
    private int dragX;
    private int dragingCol = -1;
    private DataWindow dw;

    public ColHeader(DataWindow dw) {
        this.dw = dw;
        ColHeaderListener listener = new ColHeaderListener(dw);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public Dimension getPreferredSize() {
        int w = 0;
        if (this.dw.currColNames != null) {
            int i = 0;
            while (i < this.dw.currColNames.length) {
                DWColInfo info = this.dw.getColInfo(this.dw.currColNames[i]);
                w += info.getWidth();
                ++i;
            }
        }
        return new Dimension(w + 1, this.dw.getRowHeight() + 1);
    }

    public void paint(Graphics g) {
        if (this.dw.currColNames == null) {
            return;
        }
        int h = this.dw.getRowHeight();
        g.clearRect(0, 0, Integer.MAX_VALUE, h + 1);
        int w = 0;
        int i = 0;
        while (i < this.dw.currColNames.length) {
            DWColInfo info = this.dw.getColInfo(this.dw.currColNames[i]);
            this.dw.W[i] = info.getWidth();
            this.dw.X[i] = w;
            w += this.dw.W[i];
            int x = this.dw.X[i];
            int ww = this.dw.W[i];
            if (i > 0) {
                ++x;
                --ww;
            }
            DWUtils.drawHeader(g, x, 0, ww, h, info.getColTitle(), this.dw.getFont(), Color.lightGray);
            ++i;
        }
        if (this.dragingCol > -1) {
            DWColInfo colInfo = this.dw.getColInfo(this.dw.currColNames[this.dragingCol]);
            int ww = colInfo.getWidth();
            DWUtils.drawTransparentHeader(g, this.dragX, 0, ww, h, colInfo.getColTitle(), this.dw.getFont());
        }
        this.setPreferredSize(new Dimension(w + 1, h + 1));
        g.dispose();
    }

    protected void setDragCol(int col, int dragX) {
        this.dragingCol = col;
        this.dragX = dragX;
    }
}

