/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.datawindow;

import com.runqian.datamanager.datawindow.DWColInfo;
import com.runqian.datamanager.datawindow.DataWindow;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;

class DWUtils {
    public static void drawHeader(Graphics g, int x, int y, int w, int h, String label, Font font, Color backColor) {
        g.setFont(font);
        DWUtils.gradientPaint(g, x, y, w, h, backColor);
        g.setColor(new Color(236, 236, 236));
        g.drawLine(x, y, x + w, y);
        g.drawLine(x, y, x, y + h);
        g.setColor(Color.darkGray);
        g.drawLine(x + w, y + h, x, y + h);
        g.drawLine(x + w, y + h, x + w, y);
        g.setColor(Color.black);
        FontMetrics fm = g.getFontMetrics(font);
        int fontW = fm.stringWidth(label);
        int topSpace = (h - fm.getHeight()) / 2;
        if (topSpace < 0) {
            topSpace = 0;
        }
        int yy = y + topSpace + fm.getHeight() - fm.getDescent();
        while (fontW > w) {
            label = label.substring(0, label.length() - 1);
            fontW = fm.stringWidth(label);
        }
        g.drawString(label, x + (w - fontW) / 2, yy);
    }

    public static void drawText(Graphics g, int x, int y, int w, int h, String text, DWColInfo colInfo, Font font) {
        if (text == null || text.trim().length() == 0) {
            return;
        }
        g.setColor(Color.black);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics(font);
        int indent = 4;
        int fw = fm.stringWidth(text);
        int x1 = x;
        int align = colInfo.getAlign();
        if (align == 2) {
            x1 = (x += indent) + ((w -= indent * 2) - fw) / 2;
        } else if (align == 1) {
            w -= indent;
            x1 = x += indent;
        } else if (align == 3) {
            x1 = x + (w -= indent) - fw;
        }
        if (x1 < x) {
            x1 = x;
        }
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        float topSpace = (float)(h - fm.getHeight()) / 2.0f;
        if (topSpace > 0.0f) {
            y += (int)topSpace;
            h -= (int)(topSpace * 2.0f);
        }
        int y1 = y + ascent;
        y1 = y + (h - ascent - descent) / 2 + ascent;
        g.drawString(text, x1, y1);
    }

    public static void drawTransparentHeader(Graphics g, int x, int y, int w, int h, String label, Font font) {
        g.setFont(font);
        g.setColor(Color.white);
        g.setXORMode(new Color(124, 124, 124));
        g.fillRect(x, y, w, h);
        g.setXORMode(new Color(12, 34, 154));
        FontMetrics fm = g.getFontMetrics(font);
        int fontW = fm.stringWidth(label);
        int topSpace = (h - fm.getHeight()) / 2;
        if (topSpace < 0) {
            topSpace = 0;
        }
        int yy = y + topSpace + fm.getHeight() - fm.getDescent();
        g.drawString(label, x + (w - fontW) / 2, yy);
        g.setPaintMode();
    }

    static void gradientPaint(Graphics g, int x, int y, int w, int h, Color c) {
        Graphics2D g2 = (Graphics2D)g;
        Paint storedPaint = g2.getPaint();
        g2.setPaint(new GradientPaint(x + w / 2, y + h / 2, c, x + w / 2, y, c.brighter()));
        g2.fillRect(x, y, w, h);
        g2.setPaint(storedPaint);
    }

    public static int lookupHeaderIndex(int x, DataWindow dw) {
        int[] X = dw.X;
        int[] w = dw.W;
        int i = 0;
        while (i < X.length) {
            if (x > X[i] && x <= X[i] + w[i]) {
                return i;
            }
            ++i;
        }
        return -2;
    }
}

