/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.datawindow;

import com.runqian.base4.tool.GM;
import com.runqian.base4.tool.GV;
import com.runqian.base4.tool.Lang;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.SQLParser;
import com.runqian.base4.util.SQLTool;
import com.runqian.datamanager.datawindow.DWColInfo;
import com.runqian.datamanager.datawindow.DWMessage;
import com.runqian.datamanager.datawindow.DataPanel;
import com.runqian.datamanager.datawindow.Row;
import com.runqian.datamanager.ide.GVData;
import com.runqian.report4.dataset.DataSet;
import com.runqian.report4.dataset.SQLDataSetFactory;
import com.runqian.report4.dataset.ViewDataSetFactory;
import com.runqian.report4.ide.base.DataSource;
import com.runqian.report4.ide.base.TypesEx;
import com.runqian.report4.ide.dialog.DialogInputArgument;
import com.runqian.report4.model.SemanticsParser;
import com.runqian.report4.semantics.CustomView;
import com.runqian.report4.semantics.ICustomViewDataSetFactory;
import com.runqian.report4.semantics.TableView;
import com.runqian.report4.semantics.View;
import com.runqian.report4.usermodel.Context;
import com.runqian.report4.usermodel.DataSourceConfig;
import com.runqian.report4.usermodel.ParamMetaData;
import com.runqian.report4.usermodel.SQLDataSetConfig;
import com.runqian.report4.usermodel.Types;
import com.runqian.report4.usermodel.ViewDataSetConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class DataStore {
    private DWColInfo[] colInfos;
    Context ctx;
    String dataSource;
    private ArrayList deleteBuffer;
    private ArrayList originBuffer;
    private ArrayList primaryBuffer;
    private String sql = null;
    String tableName = null;

    public DataStore(String[] colNames) {
        this.colInfos = new DWColInfo[colNames.length];
        int i = 0;
        while (i < this.colInfos.length) {
            this.colInfos[i] = new DWColInfo();
            this.colInfos[i].setColName(colNames[i]);
            this.colInfos[i].setColTitle(colNames[i]);
            this.colInfos[i].setWidth(120);
            ++i;
        }
        this.primaryBuffer = new ArrayList();
    }

    public DataStore(String sql) {
        this.sql = sql;
        SQLParser parser = new SQLParser(sql);
        this.tableName = parser.getClause(1);
        this.primaryBuffer = new ArrayList();
        this.colInfos = null;
    }

    private void checkColIndex(int colIndex) {
        if (colIndex < 1 || colIndex > this.colInfos.length) {
            throw new RuntimeException(DWMessage.getMessage("outofColNo", String.valueOf(colIndex), String.valueOf(this.colInfos.length)));
        }
    }

    private void checkRowIndex(int rowIndex) {
        if (rowIndex < 1 || rowIndex > this.primaryBuffer.size()) {
            throw new RuntimeException(DWMessage.getMessage("outofRowNo", String.valueOf(rowIndex), String.valueOf(this.primaryBuffer.size())));
        }
    }

    public void deleteRow(int rowIndex) {
        this.checkRowIndex(rowIndex);
        Row row = (Row)this.primaryBuffer.remove(rowIndex - 1);
        if (this.deleteBuffer == null) {
            this.deleteBuffer = new ArrayList();
        }
        this.deleteBuffer.add(row);
    }

    public int getColCount() {
        return this.colInfos.length;
    }

    public int getColIndex(String colName) {
        int i = 0;
        while (i < this.colInfos.length) {
            if (colName.equalsIgnoreCase(this.colInfos[i].getColName())) {
                return i + 1;
            }
            ++i;
        }
        throw new RuntimeException(DWMessage.getMessage("noCol", colName));
    }

    public DWColInfo getColInfo(int colIndex) {
        this.checkColIndex(colIndex);
        return this.colInfos[colIndex - 1];
    }

    public DWColInfo getColInfo(String colName) {
        return this.getColInfo(this.getColIndex(colName));
    }

    public Object getDeletedItemOrigin(int rowIndex, String colName) {
        return this.getDeletedItemOrigin(rowIndex, this.getColIndex(colName));
    }

    public Object getDeletedItemOrigin(int rowIndex, int colIndex) {
        if (this.deleteBuffer == null) {
            return null;
        }
        if (rowIndex < 1 || rowIndex > this.deleteBuffer.size()) {
            throw new RuntimeException(DWMessage.getMessage("outofRowNo", String.valueOf(rowIndex), String.valueOf(this.deleteBuffer.size())));
        }
        this.checkColIndex(colIndex);
        Row row = (Row)this.deleteBuffer.get(rowIndex - 1);
        row = row.getOriginRow();
        if (row == null) {
            return null;
        }
        return row.getItem(colIndex);
    }

    public int getDeletedRowCount() {
        if (this.deleteBuffer == null) {
            return 0;
        }
        return this.deleteBuffer.size();
    }

    public Object getItem(int rowIndex, String colName) {
        return this.getItem(rowIndex, this.getColIndex(colName));
    }

    public Object getItem(int rowIndex, int colIndex) {
        this.checkRowIndex(rowIndex);
        this.checkColIndex(colIndex);
        Row row = (Row)this.primaryBuffer.get(rowIndex - 1);
        return row.getItem(colIndex);
    }

    public Object getOriginItem(int rowIndex, String colName) {
        return this.getOriginItem(rowIndex, this.getColIndex(colName));
    }

    public Object getOriginItem(int rowIndex, int colIndex) {
        this.checkRowIndex(rowIndex);
        this.checkColIndex(colIndex);
        Row row = (Row)this.primaryBuffer.get(rowIndex - 1);
        row = row.getOriginRow();
        if (row == null) {
            return null;
        }
        return row.getItem(colIndex);
    }

    Row getRow(int rowIndex) {
        this.checkRowIndex(rowIndex);
        Row row = (Row)this.primaryBuffer.get(rowIndex - 1);
        return row;
    }

    public int getRowCount() {
        return this.primaryBuffer.size();
    }

    public int getRowStatus(int rowIndex) {
        this.checkRowIndex(rowIndex);
        Row row = (Row)this.primaryBuffer.get(rowIndex - 1);
        return row.getStatus();
    }

    public int insertRow(int rowIndex) {
        Row row = new Row(this.getColCount());
        row.setStatus(3);
        if (rowIndex < 1 || rowIndex > this.primaryBuffer.size()) {
            this.primaryBuffer.add(row);
            rowIndex = this.primaryBuffer.size();
        } else {
            this.primaryBuffer.add(rowIndex - 1, row);
        }
        return rowIndex;
    }

    private boolean isBlob(int type) {
        switch (type) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    public void reset() {
        this.primaryBuffer = new ArrayList();
        this.originBuffer = new ArrayList();
        this.deleteBuffer = new ArrayList();
        DataPanel.activeRow = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve(Context ctx, String dsName) throws Exception {
        if (this.sql == null) {
            return;
        }
        if (!GM.isValidString(dsName) && !GM.isValidString(dsName = ctx.getDefDataSourceName())) {
            return;
        }
        this.ctx = ctx;
        this.dataSource = dsName;
        DataSourceConfig dsc = ctx.getDataSourceConfig(dsName);
        Connection con = null;
        Statement stmt = null;
        try {
            if (this.colInfos == null) {
                con = ctx.getConnectionFactory(dsName).getConnection();
                ResultSet rsKey = con.getMetaData().getPrimaryKeys(null, null, this.tableName);
                ArrayList<String> alKey = new ArrayList<String>();
                while (rsKey.next()) {
                    alKey.add(rsKey.getString("COLUMN_NAME"));
                }
                rsKey.close();
                stmt = con.createStatement();
                String newSql = SQLParser.modify(this.sql, 2, "1=0");
                ResultSet rs = stmt.executeQuery(newSql);
                ResultSetMetaData rsmd = rs.getMetaData();
                int colCount = rsmd.getColumnCount();
                this.colInfos = new DWColInfo[colCount];
                int i = 1;
                while (i <= colCount) {
                    this.colInfos[i - 1] = new DWColInfo();
                    this.colInfos[i - 1].setWidth(120);
                    this.colInfos[i - 1].setColType(rsmd.getColumnType(i));
                    String colname = rsmd.getColumnName(i);
                    this.colInfos[i - 1].setColName(colname);
                    if (!this.colInfos[i - 1].isPrimaryKey()) {
                        int k = 0;
                        while (k < alKey.size()) {
                            if (colname.equalsIgnoreCase((String)alKey.get(k))) {
                                this.colInfos[i - 1].setPrimaryKey(true);
                            }
                            ++k;
                        }
                    }
                    ++i;
                }
            }
            SQLDataSetConfig sqldsc = new SQLDataSetConfig();
            sqldsc.setSQL(this.sql);
            sqldsc.setDataSourceName(dsName);
            SQLDataSetFactory dsf = new SQLDataSetFactory();
            DataSet ds = dsf.createDataSet(ctx, sqldsc, true);
            int colCount = ds.getColCount();
            int rowCount = ds.getRowCount();
            this.primaryBuffer = new ArrayList();
            this.originBuffer = new ArrayList();
            this.deleteBuffer = new ArrayList();
            int i = 1;
            while (i <= rowCount) {
                Row row = new Row(colCount);
                Row originRow = new Row(colCount);
                row.setStatus(1);
                int j = 1;
                while (j <= colCount) {
                    Object value = ds.getData(i, j);
                    originRow.setItem(j, value);
                    row.setItem(j, value);
                    ++j;
                }
                row.setOriginRow(originRow);
                this.primaryBuffer.add(row);
                this.originBuffer.add(originRow);
                ++i;
            }
            ds = null;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                }
            }
            if (con != null && !con.isClosed()) {
                try {
                    con.close();
                }
                catch (Exception e) {
                }
            }
        }
    }

    public void retrieve(Context ctx, ViewDataSetConfig vConfig) throws Exception {
        DataSet ds;
        String factory;
        this.ctx = ctx;
        ParamMetaData paras = SemanticsParser.parseParameter(ctx.getSemanticsManager(), vConfig);
        if (paras != null && paras.getParamCount() != 0) {
            DialogInputArgument dia = new DialogInputArgument(GVData.activeSheet.getViewManager(), ctx);
            dia.setParam(paras);
            dia.show();
            if (dia.getOption() != 0) {
                return;
            }
            HashMap values = dia.getParamValue();
            Iterator it = values.keySet().iterator();
            while (it.hasNext()) {
                String paraName = (String)it.next();
                byte type = paras.getParam(paraName).getDataType();
                String value = (String)values.get(paraName);
                ctx.setParamValue(paraName, Types.getProperData(type, value));
            }
        }
        View view = ctx.getSemanticsManager().getView(vConfig.getViewName());
        this.dataSource = view.getDataSourceName();
        if (!GM.isValidString(this.dataSource)) {
            this.dataSource = ctx.getDefDataSourceName();
        }
        if (view instanceof CustomView) {
            CustomView cv = (CustomView)view;
            factory = cv.getViewDataSetFactoryClass();
            if (!GM.isValidString(factory)) {
                throw new Exception(Lang.getText("datastore.falsename"));
            }
            ICustomViewDataSetFactory cvdsf = (ICustomViewDataSetFactory)Class.forName(factory).newInstance();
            ds = cvdsf.createDataSet(ctx, vConfig, true);
        } else {
            DataSource dsrc;
            factory = vConfig.getFactoryClass();
            ViewDataSetFactory vdsf = (ViewDataSetFactory)Class.forName(factory).newInstance();
            boolean useSchema = true;
            if (GV.dsModel != null && (dsrc = GV.dsModel.getDataSource(this.dataSource)) != null) {
                useSchema = dsrc.isUseSchema();
            }
            ds = vdsf.createDataSet(ctx, vConfig, true, useSchema);
        }
        int colCount = ds.getColCount();
        int rowCount = ds.getRowCount();
        this.primaryBuffer = new ArrayList();
        this.originBuffer = new ArrayList();
        this.deleteBuffer = new ArrayList();
        int i = 1;
        while (i <= rowCount) {
            Row row = new Row(colCount);
            Row originRow = new Row(colCount);
            row.setStatus(1);
            int j = 1;
            while (j <= colCount) {
                Object value = ds.getData(i, j);
                if (this.getColInfo(j).getDataType() != 62) {
                    originRow.setItem(j, value);
                    row.setItem(j, value);
                }
                ++j;
            }
            row.setOriginRow(originRow);
            this.primaryBuffer.add(row);
            this.originBuffer.add(originRow);
            ++i;
        }
        ds = null;
    }

    public void setColInfos(View view) {
        this.colInfos = new DWColInfo[view.getColCount()];
        int i = 1;
        while (i <= view.getColCount()) {
            this.colInfos[i - 1] = new DWColInfo();
            this.colInfos[i - 1].setWidth(120);
            this.colInfos[i - 1].setColName(view.getColInfo(i - 1).getColName());
            this.colInfos[i - 1].setColTitle(view.getColInfo(i - 1).getColTitle());
            this.colInfos[i - 1].setColType(TypesEx.getDBTypeBySQLType(view.getColInfo(i - 1).getDataType()));
            this.colInfos[i - 1].setDataType(view.getColInfo(i - 1).getDataType());
            this.colInfos[i - 1].setDataDescription(view.getColInfo(i - 1).getDataDescription());
            this.colInfos[i - 1].setDataPrecision(view.getColInfo(i - 1).getDataPrecision());
            this.colInfos[i - 1].setDataType(view.getColInfo(i - 1).getDataType());
            this.colInfos[i - 1].setDataWidth(view.getColInfo(i - 1).getDataWidth());
            this.colInfos[i - 1].setPrimaryKey(view.getColInfo(i - 1).isPrimaryKey());
            this.colInfos[i - 1].setCustomManipulate(view.getColInfo(i - 1).isCustomManipulate());
            ++i;
        }
        if (view instanceof TableView) {
            TableView tv = (TableView)view;
            this.tableName = tv.getTableName();
        }
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setItem(int rowIndex, int colIndex, Object value) {
        this.checkRowIndex(rowIndex);
        this.checkColIndex(colIndex);
        Row row = (Row)this.primaryBuffer.get(rowIndex - 1);
        row.setItem(colIndex, value);
        if (row.getStatus() == 1) {
            row.setStatus(2);
        } else if (row.getStatus() == 3) {
            row.setStatus(4);
        }
    }

    public void setItem(int rowIndex, String colName, Object value) {
        this.setItem(rowIndex, this.getColIndex(colName), value);
    }

    public void setRowStatus(int rowIndex, int status) {
        this.checkRowIndex(rowIndex);
        Row row = (Row)this.primaryBuffer.get(rowIndex - 1);
        row.setStatus(status);
    }

    public void setWhere(String where) {
        this.sql = SQLParser.modify(this.sql, 2, where);
    }

    public void sort(String sortString) throws Exception {
        ArgumentTokenizer at = new ArgumentTokenizer(sortString, ',');
        String newSort = "";
        while (at.hasMoreTokens()) {
            String tmp = at.nextToken().trim();
            if (tmp.length() == 0) continue;
            if (newSort.length() > 0) {
                newSort = newSort + ",";
            }
            StringTokenizer st = new StringTokenizer(tmp, " ");
            String colName = st.nextToken();
            newSort = newSort + this.getColIndex(colName) + " ";
            int flag = 1;
            if (st.hasMoreTokens() && (tmp = st.nextToken()).equalsIgnoreCase("desc")) {
                flag = -1;
            }
            newSort = newSort + flag;
        }
        int rowCount = this.getRowCount();
        Object[] rows = new Row[rowCount];
        int i = 0;
        while (i < rowCount) {
            rows[i] = (Row)this.primaryBuffer.get(i);
            ((Row)rows[i]).setSortString(newSort);
            ++i;
        }
        try {
            Arrays.sort(rows);
        }
        catch (Exception e) {
            throw new Exception(Lang.getText("datastore.cantsort"));
        }
        int i2 = 0;
        while (i2 < rowCount) {
            this.primaryBuffer.set(i2, rows[i2]);
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Connection con) throws Exception {
        if (this.tableName == null || this.tableName.trim().length() == 0) {
            return;
        }
        if (this.tableName.indexOf(",") > 0) {
            return;
        }
        Statement upStmt = null;
        Statement inStmt = null;
        Statement delStmt = null;
        boolean oldAuto = con.getAutoCommit();
        try {
            con.setAutoCommit(false);
            int colCount = this.getColCount();
            int[] colTypes = new int[colCount];
            int i = 0;
            while (i < colCount) {
                colTypes[i] = TypesEx.getDBTypeBySQLType(this.colInfos[i].getColType());
                ++i;
            }
            int delCount = this.getDeletedRowCount();
            int row = 1;
            while (row <= delCount) {
                Row delRow = (Row)this.deleteBuffer.get(row - 1);
                int rowStatus = delRow.getStatus();
                if (rowStatus != 3 && rowStatus != 4) {
                    if (delStmt == null) {
                        StringBuffer delSql = new StringBuffer(50);
                        delSql.append("delete from ").append(this.tableName).append(" where ");
                        StringBuffer where = new StringBuffer();
                        int col = 1;
                        while (col <= colCount) {
                            if (this.colInfos[col - 1].isPrimaryKey()) {
                                if (where.length() > 0) {
                                    where.append(" and ");
                                }
                                where.append(this.colInfos[col - 1].getColName()).append(" = ?");
                            }
                            ++col;
                        }
                        if (where.length() == 0) {
                            throw new Exception(DWMessage.getMessage("noPrimary"));
                        }
                        delSql.append(where.toString());
                        delStmt = con.prepareStatement(delSql.toString());
                    }
                    int primaryCount = 0;
                    int col = 1;
                    while (col <= colCount) {
                        if (this.colInfos[col - 1].isPrimaryKey()) {
                            Object value = this.getDeletedItemOrigin(row, col);
                            SQLTool.setObject(GV.dsModel.getDataSource(this.dataSource).getDBType(), (PreparedStatement)delStmt, ++primaryCount, value, colTypes[col - 1]);
                        }
                        ++col;
                    }
                    delStmt.execute();
                }
                ++row;
            }
            int rowCount = this.getRowCount();
            int needUpdateCols = 0;
            int row2 = 1;
            while (row2 <= rowCount) {
                int rowStatus = this.getRowStatus(row2);
                if (rowStatus != 3 && rowStatus != 1) {
                    int col;
                    if (rowStatus == 4) {
                        if (inStmt == null) {
                            StringBuffer insertSql = new StringBuffer(50);
                            insertSql.append("insert into ").append(this.tableName);
                            StringBuffer cols = new StringBuffer();
                            StringBuffer values = new StringBuffer();
                            int col2 = 1;
                            while (col2 <= colCount) {
                                if (!this.isBlob(this.colInfos[col2 - 1].getColType()) && !this.colInfos[col2 - 1].isCustomManipulate()) {
                                    if (cols.length() > 0) {
                                        cols.append(", ");
                                    }
                                    cols.append(this.colInfos[col2 - 1].getColName());
                                    if (values.length() > 0) {
                                        values.append(", ");
                                    }
                                    values.append("?");
                                }
                                ++col2;
                            }
                            insertSql.append(" ( ").append(cols.toString()).append(" ) values ( ").append(values.toString()).append(" )");
                            inStmt = con.prepareStatement(insertSql.toString());
                        }
                        boolean isKeyEmpty = false;
                        int paramIndex = 0;
                        col = 1;
                        while (col <= colCount) {
                            if (!this.isBlob(this.colInfos[col - 1].getColType()) && !this.colInfos[col - 1].isCustomManipulate()) {
                                ++paramIndex;
                                Object value = this.getItem(row2, col);
                                if (value == null && this.colInfos[col - 1].isPrimaryKey()) {
                                    isKeyEmpty = true;
                                    break;
                                }
                                SQLTool.setObject(GV.dsModel.getDataSource(this.dataSource).getDBType(), (PreparedStatement)inStmt, paramIndex, value, colTypes[col - 1]);
                            }
                            ++col;
                        }
                        if (!isKeyEmpty) {
                            inStmt.execute();
                        }
                    } else if (rowStatus == 2) {
                        if (upStmt == null) {
                            StringBuffer upSql = new StringBuffer(50);
                            upSql.append("update ").append(this.tableName).append(" set ");
                            StringBuffer where = new StringBuffer();
                            col = 1;
                            while (col <= colCount) {
                                if (!this.isBlob(this.colInfos[col - 1].getColType())) {
                                    String colName = this.colInfos[col - 1].getColName();
                                    if (!this.colInfos[col - 1].isCustomManipulate()) {
                                        if (needUpdateCols > 0) {
                                            upSql.append(", ");
                                        }
                                        ++needUpdateCols;
                                        upSql.append(colName).append(" = ?");
                                    }
                                    if (this.colInfos[col - 1].isPrimaryKey()) {
                                        if (where.length() > 0) {
                                            where.append(" and ");
                                        }
                                        where.append(colName).append(" = ?");
                                    }
                                }
                                ++col;
                            }
                            if (where.length() == 0) {
                                throw new Exception(DWMessage.getMessage("noPrimary"));
                            }
                            upSql.append(" where ").append(where);
                            upStmt = con.prepareStatement(upSql.toString());
                        }
                        boolean isKeyEmpty = false;
                        int primaryCount = 0;
                        int paramIndex = 0;
                        int col3 = 1;
                        while (col3 <= colCount) {
                            if (!this.isBlob(this.colInfos[col3 - 1].getColType())) {
                                Object value = this.getItem(row2, col3);
                                if (!this.colInfos[col3 - 1].isCustomManipulate()) {
                                    SQLTool.setObject(GV.dsModel.getDataSource(this.dataSource).getDBType(), (PreparedStatement)upStmt, ++paramIndex, value, colTypes[col3 - 1]);
                                }
                                if (this.colInfos[col3 - 1].isPrimaryKey()) {
                                    if (value == null) {
                                        isKeyEmpty = true;
                                        break;
                                    }
                                    Object primaryValue = this.getOriginItem(row2, col3);
                                    SQLTool.setObject(GV.dsModel.getDataSource(this.dataSource).getDBType(), (PreparedStatement)upStmt, needUpdateCols + ++primaryCount, primaryValue, colTypes[col3 - 1]);
                                }
                            }
                            ++col3;
                        }
                        if (!isKeyEmpty) {
                            upStmt.execute();
                        }
                    }
                }
                ++row2;
            }
            try {
                con.commit();
            }
            catch (Exception e1) {
                con.rollback();
                e1.printStackTrace();
            }
            if (this.deleteBuffer != null) {
                this.deleteBuffer.clear();
            }
            if (this.originBuffer != null) {
                this.originBuffer.clear();
            }
            int row3 = 1;
            while (row3 <= rowCount) {
                this.setRowStatus(row3, 1);
                Row originRow = new Row(colCount);
                int i2 = 1;
                while (i2 <= colCount) {
                    Object value = this.getItem(row3, i2);
                    originRow.setItem(i2, value);
                    ++i2;
                }
                this.getRow(row3).setOriginRow(originRow);
                ++row3;
            }
        }
        finally {
            try {
                con.rollback();
            }
            catch (Exception e) {}
            con.setAutoCommit(oldAuto);
            try {
                if (upStmt != null) {
                    upStmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (inStmt != null) {
                    inStmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (delStmt != null) {
                    delStmt.close();
                }
            }
            catch (Exception e) {
            }
        }
    }
}

