/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.datamanager.datawindow;

import com.runqian.datamanager.datawindow.DWUtils;
import com.runqian.datamanager.datawindow.DataWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

class RowHeader
extends JPanel
implements MouseListener {
    private DataWindow dw;
    private int width;

    public RowHeader(DataWindow dw) {
        this.dw = dw;
        int count = dw.getRowCount();
        this.width = new BufferedImage(10, 10, 1).getGraphics().getFontMetrics(dw.getFont()).stringWidth(String.valueOf(count)) + 8;
        this.addMouseListener(this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width + 1, this.dw.getRowHeight() * this.dw.getRowCount() + 1);
    }

    public void mouseClicked(MouseEvent e) {
        int y = e.getY() - 1;
        int row = y / this.dw.getRowHeight() + 1;
        if (row > this.dw.getRowCount()) {
            row = -1;
        }
        this.dw.fireMouseClicked(e, row, 0);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void paint(Graphics g) {
        int h = this.dw.getRowHeight();
        int rowCount = this.dw.getRowCount();
        g.clearRect(0, 0, this.width + 1, Integer.MAX_VALUE);
        Rectangle displayWin = this.dw.getViewport().getViewRect();
        int startRow = displayWin.y / h + 1;
        int endRow = (displayWin.y + displayWin.height) / h + 1;
        if (endRow > rowCount) {
            endRow = rowCount;
        }
        int row = startRow;
        while (row <= endRow) {
            int y = (row - 1) * h;
            int hh = h;
            if (row > 1) {
                ++y;
                --hh;
            }
            Color backColor = Color.lightGray;
            if (this.dw.getRowSelected(row)) {
                backColor = this.dw.selectedRowColor;
            }
            if (this.dw.getCurrentRow() == row) {
                backColor = this.dw.currRowColor;
            }
            DWUtils.drawHeader(g, 0, y, this.width, hh, String.valueOf(row), this.dw.getFont(), backColor);
            ++row;
        }
        this.setPreferredSize(new Dimension(this.width + 1, h * rowCount + 1));
        g.dispose();
    }
}

